/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;
import org.kie.camel.BaseKieComponentTest;
import org.kie.camel.KieCamelUtils;
import org.kie.camel.KieComponent;
import org.kie.internal.executor.api.STATUS;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.definition.ProcessDefinition;
import org.kie.server.api.model.definition.ProcessDefinitionList;
import org.kie.server.api.model.instance.DocumentInstance;
import org.kie.server.api.model.instance.NodeInstanceList;
import org.kie.server.api.model.instance.RequestInfoInstanceList;
import org.kie.server.api.model.instance.SolverInstanceList;
import org.kie.server.api.model.instance.TaskSummaryList;

public class KieClientServicesIntegrationTest
extends BaseKieComponentTest {
    @Test
    public void testCaseServiceCamelProducer() throws Exception {
        MockEndpoint mockEndpoint = this.getMockEndpoint("mock:result");
        mockEndpoint.expectedMessageCount(1);
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("CamelKieClient", "case");
        headers.put("CamelKieOperation", "findProcesses");
        headers.put(KieCamelUtils.asCamelKieName((String)"page"), 1);
        headers.put(KieCamelUtils.asCamelKieName((String)"pageSize"), 1);
        this.template.sendBodyAndHeaders("direct:start", null, headers);
        this.assertMockEndpointsSatisfied();
        List result = (List)KieCamelUtils.getResultMessage((Exchange)((Exchange)mockEndpoint.getExchanges().get(0))).getBody(List.class);
        KieClientServicesIntegrationTest.assertCollectionSize((Collection)result, (int)1);
    }

    @Test
    public void testDocumentServiceCamelProducer() throws Exception {
        MockEndpoint mockEndpoint = this.getMockEndpoint("mock:result");
        mockEndpoint.expectedMessageCount(1);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CamelKieClient", "document");
        headers.put("CamelKieOperation", "getDocument");
        headers.put(KieCamelUtils.asCamelKieName((String)"identifier"), "1234");
        this.template.sendBodyAndHeaders("direct:start", null, headers);
        this.assertMockEndpointsSatisfied();
        DocumentInstance documentInstance = (DocumentInstance)KieCamelUtils.getResultMessage((Exchange)((Exchange)mockEndpoint.getExchanges().get(0))).getBody(DocumentInstance.class);
        KieClientServicesIntegrationTest.assertEquals((Object)documentInstance.getIdentifier(), (Object)"1234");
    }

    @Test
    public void testJobServiceCamelProducer() throws Exception {
        MockEndpoint mockEndpoint = this.getMockEndpoint("mock:result");
        mockEndpoint.expectedMessageCount(1);
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("CamelKieClient", "job");
        headers.put("CamelKieOperation", "getRequestsByStatus");
        headers.put(KieCamelUtils.asCamelKieName((String)"statuses"), Arrays.asList(STATUS.values()));
        headers.put(KieCamelUtils.asCamelKieName((String)"page"), 1);
        headers.put(KieCamelUtils.asCamelKieName((String)"pageSize"), 10);
        this.template.sendBodyAndHeaders("direct:start", null, headers);
        this.assertMockEndpointsSatisfied();
        List requestInfoInstanceList = (List)KieCamelUtils.getResultMessage((Exchange)((Exchange)mockEndpoint.getExchanges().get(0))).getBody(List.class);
        KieClientServicesIntegrationTest.assertCollectionSize((Collection)requestInfoInstanceList, (int)0);
    }

    @Test
    public void testQueryServiceCamelProducer() throws Exception {
        MockEndpoint mockEndpoint = this.getMockEndpoint("mock:result");
        mockEndpoint.expectedMessageCount(1);
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("CamelKieClient", "query");
        headers.put("CamelKieOperation", "findCompletedNodeInstances");
        headers.put(KieCamelUtils.asCamelKieName((String)"processInstanceId"), 100L);
        headers.put(KieCamelUtils.asCamelKieName((String)"page"), 1);
        headers.put(KieCamelUtils.asCamelKieName((String)"pageSize"), 10);
        this.template.sendBodyAndHeaders("direct:start", null, headers);
        this.assertMockEndpointsSatisfied();
        List nodeInstanceList = (List)KieCamelUtils.getResultMessage((Exchange)((Exchange)mockEndpoint.getExchanges().get(0))).getBody(List.class);
        KieClientServicesIntegrationTest.assertCollectionSize((Collection)nodeInstanceList, (int)0);
    }

    @Test
    public void testSolverServiceCamelProducer() throws Exception {
        MockEndpoint mockEndpoint = this.getMockEndpoint("mock:result");
        mockEndpoint.expectedMessageCount(1);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CamelKieClient", "solver");
        headers.put("CamelKieOperation", "getSolvers");
        headers.put(KieCamelUtils.asCamelKieName((String)"containerId"), "my-container");
        this.template.sendBodyAndHeaders("direct:start", null, headers);
        this.assertMockEndpointsSatisfied();
        List nodeInstanceList = (List)KieCamelUtils.getResultMessage((Exchange)((Exchange)mockEndpoint.getExchanges().get(0))).getBody(List.class);
        KieClientServicesIntegrationTest.assertCollectionSize((Collection)nodeInstanceList, (int)0);
    }

    @Test
    public void testUiServiceCamelProducer() throws Exception {
        MockEndpoint mockEndpoint = this.getMockEndpoint("mock:result");
        mockEndpoint.expectedMessageCount(1);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CamelKieClient", "ui");
        headers.put("CamelKieOperation", "getProcessForm");
        headers.put(KieCamelUtils.asCamelKieName((String)"containerId"), "my-container");
        headers.put(KieCamelUtils.asCamelKieName((String)"processId"), "my-process");
        this.template.sendBodyAndHeaders("direct:start", null, headers);
        this.assertMockEndpointsSatisfied();
        String form = (String)KieCamelUtils.getResultMessage((Exchange)((Exchange)mockEndpoint.getExchanges().get(0))).getBody(String.class);
        KieClientServicesIntegrationTest.assertEquals((Object)form, (Object)"my form");
    }

    @Test
    public void testUserTaskServiceCamelProducer() throws Exception {
        MockEndpoint mockEndpoint = this.getMockEndpoint("mock:result");
        mockEndpoint.expectedMessageCount(1);
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("CamelKieClient", "userTask");
        headers.put("CamelKieOperation", "findTasks");
        headers.put(KieCamelUtils.asCamelKieName((String)"userId"), "rhpamAdmin");
        headers.put(KieCamelUtils.asCamelKieName((String)"page"), 1);
        headers.put(KieCamelUtils.asCamelKieName((String)"pageSize"), 10);
        this.template.sendBodyAndHeaders("direct:start", null, headers);
        this.assertMockEndpointsSatisfied();
        List taskSummary = (List)KieCamelUtils.getResultMessage((Exchange)((Exchange)mockEndpoint.getExchanges().get(0))).getBody(List.class);
        KieClientServicesIntegrationTest.assertCollectionSize((Collection)taskSummary, (int)0);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        KieServerInfo info = new KieServerInfo("mock", "1.2.3");
        List<String> capabilities = Arrays.asList("BPM", "BPM-UI", "BRM", "BRP", "CaseMgmt", "DMN");
        info.setCapabilities(capabilities);
        ServiceResponse response = new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "Kie Server info");
        response.setResult((Object)info);
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody(this.toXML(response, KieServerInfo.class, ServiceResponse.class))));
        ProcessDefinitionList caseResponse = new ProcessDefinitionList();
        caseResponse.setProcesses(new ProcessDefinition[]{new ProcessDefinition()});
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlMatching((String)"/queries/cases/processes.*")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody(this.toXML(caseResponse, ProcessDefinitionList.class, ProcessDefinition.class))));
        DocumentInstance documentResponse = new DocumentInstance();
        documentResponse.setIdentifier("1234");
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlMatching((String)"/documents/1234")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody(this.toXML(documentResponse, DocumentInstance.class))));
        RequestInfoInstanceList jobResponse = new RequestInfoInstanceList();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlMatching((String)"/jobs.*")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody(this.toXML(jobResponse, RequestInfoInstanceList.class))));
        NodeInstanceList queryResponse = new NodeInstanceList();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlMatching((String)"/queries/processes/instances/100/nodes/instances.*")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody(this.toXML(queryResponse, NodeInstanceList.class))));
        SolverInstanceList solverResponse = new SolverInstanceList();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlMatching((String)"/containers/my-container/solvers")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody(this.toXML(solverResponse, SolverInstanceList.class))));
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlMatching((String)"/containers/my-container/forms/processes/my-process.*")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("my form")));
        TaskSummaryList userTaskResponse = new TaskSummaryList();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlMatching((String)"/queries/tasks/instances.*")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody(this.toXML(userTaskResponse, TaskSummaryList.class))));
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("kie:" + KieClientServicesIntegrationTest.this.getAuthenticadUrl("admin", "admin"))).to("mock:result");
            }
        };
    }

    private String toXML(Object pojo, Class<?> ... classes) throws Exception {
        Marshaller marshaller = MarshallerFactory.getMarshaller(new HashSet(Arrays.asList(classes)), (MarshallingFormat)MarshallingFormat.JAXB, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        return marshaller.marshall(pojo);
    }

    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        KieComponent kieComponent = new KieComponent();
        kieComponent.getConfiguration().clearBodyParams().setBodyParam("case", "findProcesses", "page").setBodyParam("case", "findProcesses", "pageSize");
        context.addComponent("kie", (Component)kieComponent);
        return context;
    }
}

