/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel.embedded.camel.component;

import com.sun.tools.xjc.Language;
import com.sun.tools.xjc.Options;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.dataformat.JaxbDataFormat;
import org.apache.camel.spi.Policy;
import org.assertj.core.api.Assertions;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.drools.core.command.runtime.GetGlobalCommand;
import org.drools.core.command.runtime.SetGlobalCommand;
import org.drools.core.command.runtime.rule.FireAllRulesCommand;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.command.Command;
import org.kie.api.io.KieResources;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.camel.embedded.camel.component.KieCamelTestSupport;
import org.kie.camel.embedded.component.KiePolicy;
import org.kie.internal.builder.JaxbConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.pipeline.camel.Person;
import org.kie.pipeline.camel.WrappedList;

public class CamelEndpointWithJaxWrapperCollectionTest
extends KieCamelTestSupport {
    private String handle;

    @Test
    public void testWorkingSetGlobalTestSessionSetAndGetGlobal() throws Exception {
        BatchExecutionCommandImpl cmd = new BatchExecutionCommandImpl();
        cmd.setLookup("ksession1");
        SetGlobalCommand setGlobal = new SetGlobalCommand("list", (Object)new WrappedList());
        setGlobal.setOutIdentifier("list");
        cmd.addCommand((Command)setGlobal);
        cmd.addCommand((Command)new InsertObjectCommand((Object)new Person("baunax")));
        cmd.addCommand((Command)new FireAllRulesCommand());
        cmd.addCommand((Command)new GetGlobalCommand("list"));
        Marshaller marshaller = this.getJaxbContext().createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        StringWriter xml = new StringWriter();
        marshaller.marshal((Object)cmd, (Writer)xml);
        logger.debug(xml.toString());
        byte[] response = (byte[])this.template.requestBody("direct:test-with-session", (Object)xml.toString());
        CamelEndpointWithJaxWrapperCollectionTest.assertNotNull((Object)response);
        logger.debug("response:\n" + new String(response));
        Unmarshaller unmarshaller = this.getJaxbContext().createUnmarshaller();
        ExecutionResults res = (ExecutionResults)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(response));
        WrappedList resp = (WrappedList)res.getValue("list");
        CamelEndpointWithJaxWrapperCollectionTest.assertNotNull((Object)resp);
        CamelEndpointWithJaxWrapperCollectionTest.assertEquals((long)resp.size(), (long)2L);
        ArrayList<String> expectedNames = new ArrayList<String>();
        expectedNames.add(resp.get(0).getName());
        expectedNames.add(resp.get(1).getName());
        Assertions.assertThat(expectedNames).contains((Object[])new String[]{"baunax", "Hadrian"});
    }

    @Override
    protected void configureDroolsContext(Context jndiContext) {
        Person me = new Person();
        me.setName("Hadrian");
        String rule = "";
        rule = rule + "import " + Person.class.getCanonicalName() + ";\n";
        rule = rule + "import org.kie.pipeline.camel.Person\n";
        rule = rule + "import org.kie.pipeline.camel.WrappedList\n";
        rule = rule + "global WrappedList list\n";
        rule = rule + "rule rule1 \n";
        rule = rule + "  when \n";
        rule = rule + "    $p : Person() \n";
        rule = rule + " \n";
        rule = rule + "  then \n";
        rule = rule + "    System.out.println(\"executed\"); \n";
        rule = rule + "    list.add($p); \n";
        rule = rule + "end\n";
        KieSession ksession = this.registerKnowledgeRuntime("ksession1", rule);
        InsertObjectCommand cmd = new InsertObjectCommand((Object)me);
        cmd.setOutIdentifier("camel-rider");
        cmd.setReturnObject(false);
        BatchExecutionCommandImpl script = new BatchExecutionCommandImpl(Arrays.asList(cmd));
        ExecutionResults results = (ExecutionResults)ksession.execute((Command)script);
        this.handle = ((FactHandle)results.getFactHandle("camel-rider")).toExternalForm();
    }

    @Override
    protected KieSession registerKnowledgeRuntime(String identifier, String rule) {
        KieBuilder kieBuilder;
        List errors;
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        KieResources kieResources = ks.getResources();
        Options xjcOpts = new Options();
        xjcOpts.setSchemaLanguage(Language.XMLSCHEMA);
        JaxbConfiguration jaxbConfiguration = KnowledgeBuilderFactory.newJaxbConfiguration((Options)xjcOpts, (String)"xsd");
        kfs.write(kieResources.newClassPathResource("person.xsd", ((Object)((Object)this)).getClass()).setResourceType(ResourceType.XSD).setConfiguration((ResourceConfiguration)jaxbConfiguration));
        if (rule != null && rule.length() > 0) {
            kfs.write("src/main/resources/rule.drl", rule);
        }
        if (!(errors = (kieBuilder = ks.newKieBuilder(kfs).buildAll()).getResults().getMessages(new Message.Level[]{Message.Level.ERROR})).isEmpty()) {
            CamelEndpointWithJaxWrapperCollectionTest.fail((String)("" + errors));
        }
        KieSession ksession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
        try {
            this.jndiContext.bind(identifier, (Object)ksession);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        return ksession;
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        this.routeBuilder = new RouteBuilder(){

            public void configure() throws Exception {
                JaxbDataFormat def = new JaxbDataFormat();
                def.setPrettyPrint(Boolean.valueOf(true));
                def.setContextPath("org.kie.pipeline.camel");
                ((PolicyDefinition)((PolicyDefinition)this.from("direct:test-with-session").policy((Policy)new KiePolicy()).unmarshal((DataFormatDefinition)def)).to("kie-local:ksession1")).marshal((DataFormatDefinition)def);
            }
        };
        return this.routeBuilder;
    }
}

