/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel.embedded.camel.component;

import com.sun.tools.xjc.Language;
import com.sun.tools.xjc.Options;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.xml.bind.Marshaller;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.dataformat.JaxbDataFormat;
import org.apache.camel.spi.Policy;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.drools.core.command.runtime.rule.FireAllRulesCommand;
import org.drools.core.command.runtime.rule.GetObjectCommand;
import org.drools.core.command.runtime.rule.InsertElementsCommand;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.drools.core.command.runtime.rule.QueryCommand;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.runtime.rule.impl.FlatQueryResults;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.command.Command;
import org.kie.api.io.KieResources;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.QueryResultsRow;
import org.kie.camel.embedded.camel.component.KieCamelTestSupport;
import org.kie.camel.embedded.component.KiePolicy;
import org.kie.internal.builder.JaxbConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.pipeline.camel.Person;

public class CamelEndpointWithJaxbTest
extends KieCamelTestSupport {
    private String handle;

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Test
    public void testSessionInsert() throws Exception {
        BatchExecutionCommandImpl cmd = new BatchExecutionCommandImpl();
        cmd.setLookup("ksession1");
        cmd.addCommand((Command)new InsertObjectCommand((Object)new Person("lucaz", 25), "person1"));
        cmd.addCommand((Command)new InsertObjectCommand((Object)new Person("hadrian", 25), "person2"));
        cmd.addCommand((Command)new InsertObjectCommand((Object)new Person("baunax", 21), "person3"));
        cmd.addCommand((Command)new FireAllRulesCommand());
        StringWriter xmlReq = new StringWriter();
        Marshaller marshaller = this.getJaxbContext().createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)cmd, (Writer)xmlReq);
        logger.debug(xmlReq.toString());
        byte[] xmlResp = (byte[])this.template.requestBody("direct:test-with-session", (Object)xmlReq.toString());
        CamelEndpointWithJaxbTest.assertNotNull((Object)xmlResp);
        logger.debug(new String(xmlResp));
        ExecutionResults resp = (ExecutionResults)this.getJaxbContext().createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xmlResp));
        CamelEndpointWithJaxbTest.assertNotNull((Object)resp);
        CamelEndpointWithJaxbTest.assertEquals((long)3L, (long)resp.getIdentifiers().size());
        CamelEndpointWithJaxbTest.assertNotNull((Object)resp.getValue("person1"));
        CamelEndpointWithJaxbTest.assertNotNull((Object)resp.getValue("person2"));
        CamelEndpointWithJaxbTest.assertNotNull((Object)resp.getValue("person3"));
        CamelEndpointWithJaxbTest.assertNotNull((Object)resp.getFactHandle("person1"));
        CamelEndpointWithJaxbTest.assertNotNull((Object)resp.getFactHandle("person2"));
        CamelEndpointWithJaxbTest.assertNotNull((Object)resp.getFactHandle("person3"));
    }

    @Test
    public void testSessionGetObject() throws Exception {
        BatchExecutionCommandImpl cmd = new BatchExecutionCommandImpl();
        cmd.setLookup("ksession1");
        cmd.addCommand((Command)new GetObjectCommand((FactHandle)DefaultFactHandle.createFromExternalFormat((String)this.handle), "hadrian"));
        StringWriter xmlReq = new StringWriter();
        Marshaller marshaller = this.getJaxbContext().createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)cmd, (Writer)xmlReq);
        logger.debug(xmlReq.toString());
        byte[] xmlResp = (byte[])this.template.requestBody("direct:test-with-session", (Object)xmlReq.toString());
        ExecutionResults resp = (ExecutionResults)this.getJaxbContext().createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xmlResp));
        CamelEndpointWithJaxbTest.assertNotNull((Object)resp);
        CamelEndpointWithJaxbTest.assertEquals((long)1L, (long)resp.getIdentifiers().size());
        CamelEndpointWithJaxbTest.assertNotNull((Object)resp.getValue("hadrian"));
    }

    @Test
    @Ignore(value="error in drools session")
    public void testSessionModify() throws Exception {
        String cmd = "";
        cmd = cmd + "<batch-execution lookup='ksession1'>\n";
        cmd = cmd + "   <modify>\n";
        cmd = cmd + "      <fact-handle>" + this.handle + "</fact-handle>\n";
        cmd = cmd + "      <setters accessor='name' value='salaboy' />\n";
        cmd = cmd + "   </modify>\n";
        cmd = cmd + "</batch-execution>\n";
        String outXml = new String((byte[])this.template.requestBody("direct:test-with-session", (Object)cmd));
        String expectedXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n";
        expectedXml = expectedXml + "<execution-results xmlns:ns2=\"http://drools.org/model\">\n";
        expectedXml = expectedXml + "    <results/>\n";
        expectedXml = expectedXml + "    <facts/>\n";
        expectedXml = expectedXml + "</execution-results>\n";
        this.assertXMLEqual(expectedXml, outXml);
        cmd = "<batch-execution lookup='ksession1'>\n";
        cmd = cmd + "   <get-object out-identifier='rider'>\n";
        cmd = cmd + "     <fact-handle>" + this.handle + "</fact-handle>\n";
        cmd = cmd + "   </get-object>\n";
        cmd = cmd + "</batch-execution>\n";
        byte[] xmlResp = (byte[])this.template.requestBody("direct:test-with-session", (Object)cmd.toString());
        CamelEndpointWithJaxbTest.assertNotNull((Object)xmlResp);
        ExecutionResults resp = (ExecutionResults)this.getJaxbContext().createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xmlResp));
        CamelEndpointWithJaxbTest.assertNotNull((Object)resp);
        Person person = (Person)resp.getValue("rider");
        CamelEndpointWithJaxbTest.assertEquals((Object)"salaboy", (Object)person.getName());
    }

    @Test
    public void testSessionRetractObject() throws Exception {
        String cmd = "";
        cmd = cmd + "<batch-execution lookup='ksession1'>\n";
        cmd = cmd + "   <retract>\n";
        cmd = cmd + "     <fact-handle>" + this.handle + "</fact-handle>\n";
        cmd = cmd + "   </retract>\n";
        cmd = cmd + "</batch-execution>";
        String outXml = new String((byte[])this.template.requestBody("direct:test-with-session", (Object)cmd));
        logger.debug(outXml);
        CamelEndpointWithJaxbTest.assertNotNull((Object)outXml);
    }

    @Test
    public void testInsertElements() throws Exception {
        BatchExecutionCommandImpl cmd = new BatchExecutionCommandImpl();
        cmd.setLookup("ksession1");
        InsertElementsCommand elems = new InsertElementsCommand("elems");
        elems.getObjects().add(new Person("lucaz", 25));
        elems.getObjects().add(new Person("hadrian", 25));
        elems.getObjects().add(new Person("baunax", 21));
        elems.getObjects().add("xxx");
        cmd.addCommand((Command)elems);
        cmd.addCommand((Command)new FireAllRulesCommand());
        StringWriter xmlReq = new StringWriter();
        Marshaller marshaller = this.getJaxbContext().createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)cmd, (Writer)xmlReq);
        byte[] xmlResp = (byte[])this.template.requestBody("direct:test-with-session", (Object)xmlReq.toString());
        CamelEndpointWithJaxbTest.assertNotNull((Object)xmlResp);
        ExecutionResults resp = (ExecutionResults)this.getJaxbContext().createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xmlResp));
        CamelEndpointWithJaxbTest.assertNotNull((Object)resp);
        CamelEndpointWithJaxbTest.assertEquals((long)1L, (long)resp.getIdentifiers().size());
        List list = (List)resp.getValue("elems");
        CamelEndpointWithJaxbTest.assertEquals((Object)"lucaz", (Object)((Person)list.get(0)).getName());
        CamelEndpointWithJaxbTest.assertEquals((Object)"hadrian", (Object)((Person)list.get(1)).getName());
        CamelEndpointWithJaxbTest.assertEquals((Object)"baunax", (Object)((Person)list.get(2)).getName());
    }

    @Test
    public void testQuery() throws Exception {
        BatchExecutionCommandImpl cmd = new BatchExecutionCommandImpl();
        cmd.setLookup("ksession1");
        cmd.addCommand((Command)new InsertObjectCommand((Object)new Person("lucaz")));
        cmd.addCommand((Command)new InsertObjectCommand((Object)new Person("hadrian")));
        cmd.addCommand((Command)new InsertObjectCommand((Object)new Person("baunax", 43)));
        cmd.addCommand((Command)new InsertObjectCommand((Object)new Person("baunax", 21)));
        cmd.addCommand((Command)new QueryCommand("persons", "persons", null));
        cmd.addCommand((Command)new QueryCommand("person", "personWithName", (Object[])new String[]{"baunax"}));
        StringWriter xmlReq = new StringWriter();
        Marshaller marshaller = this.getJaxbContext().createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)cmd, (Writer)xmlReq);
        logger.debug(xmlReq.toString());
        byte[] xmlResp = (byte[])this.template.requestBody("direct:test-with-session", (Object)xmlReq.toString());
        CamelEndpointWithJaxbTest.assertNotNull((Object)xmlResp);
        logger.debug(new String(xmlResp));
        ExecutionResults resp = (ExecutionResults)this.getJaxbContext().createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xmlResp));
        CamelEndpointWithJaxbTest.assertNotNull((Object)resp);
        FlatQueryResults personQuery = (FlatQueryResults)resp.getValue("person");
        CamelEndpointWithJaxbTest.assertEquals((long)2L, (long)personQuery.size());
        FlatQueryResults personsQuery = (FlatQueryResults)resp.getValue("persons");
        CamelEndpointWithJaxbTest.assertEquals((long)5L, (long)personsQuery.size());
        Iterator iterator = personQuery.iterator();
        QueryResultsRow row = (QueryResultsRow)iterator.next();
        Person person = (Person)row.get("$p");
        CamelEndpointWithJaxbTest.assertEquals((Object)"baunax", (Object)person.getName());
    }

    @Test
    public void testProcess() throws Exception {
        BatchExecutionCommandImpl cmd = new BatchExecutionCommandImpl();
        cmd.setLookup("ksession1");
        StartProcessCommand start = new StartProcessCommand("org.drools.actions", "process-instance-id");
        start.putParameter("person", (Object)new Person("lucaz", 25));
        start.putParameter("person2", (Object)new Person("hadrian", 25));
        start.putParameter("person3", (Object)new Person("baunax", 21));
        cmd.addCommand((Command)start);
        StringWriter xmlReq = new StringWriter();
        Marshaller marshaller = this.getJaxbContext().createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)cmd, (Writer)xmlReq);
        logger.debug(xmlReq.toString());
        byte[] xmlResp = (byte[])this.template.requestBody("direct:test-with-session", (Object)xmlReq.toString());
        CamelEndpointWithJaxbTest.assertNotNull((Object)xmlResp);
        logger.debug(new String(xmlResp));
        ExecutionResults resp = (ExecutionResults)this.getJaxbContext().createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xmlResp));
        CamelEndpointWithJaxbTest.assertNotNull((Object)resp);
        CamelEndpointWithJaxbTest.assertNotNull((Object)resp.getValue("process-instance-id"));
    }

    @Test
    public void testProcessInstanceSignalEvent() throws Exception {
        String processId = "org.drools.core.event";
        String cmd = "";
        cmd = cmd + "<batch-execution lookup='ksession1'>\n";
        cmd = cmd + "  <start-process processId='" + processId + "'>\n";
        cmd = cmd + "  </start-process>\n";
        cmd = cmd + "</batch-execution>\n";
        logger.debug(cmd);
        String outXml = new String((byte[])this.template.requestBody("direct:test-with-session", (Object)cmd));
        CamelEndpointWithJaxbTest.assertNotNull((Object)outXml);
        int processInstanceId = 1;
        cmd = "";
        cmd = cmd + "<batch-execution lookup='ksession1'>\n";
        cmd = cmd + "   <signal-event process-instance-id= '" + processInstanceId + "' event-type='MyEvent'>";
        cmd = cmd + "      <string>MyValue</string>";
        cmd = cmd + "   </signal-event>";
        cmd = cmd + "</batch-execution>\n";
        outXml = new String((byte[])this.template.requestBody("direct:test-with-session", (Object)cmd));
        logger.debug(outXml);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        this.routeBuilder = new RouteBuilder(){

            public void configure() throws Exception {
                JaxbDataFormat def = new JaxbDataFormat();
                def.setPrettyPrint(Boolean.valueOf(true));
                def.setContextPath("org.kie.pipeline.camel");
                ((PolicyDefinition)((PolicyDefinition)this.from("direct:test-with-session").policy((Policy)new KiePolicy()).unmarshal((DataFormatDefinition)def)).to("kie-local:ksession1")).marshal((DataFormatDefinition)def);
                ((PolicyDefinition)((PolicyDefinition)this.from("direct:test-no-session").policy((Policy)new KiePolicy()).unmarshal((DataFormatDefinition)def)).to("kie-local:dynamic")).marshal((DataFormatDefinition)def);
            }
        };
        return this.routeBuilder;
    }

    @Override
    protected void configureDroolsContext(Context jndiContext) {
        Person me = new Person();
        me.setName("Hadrian");
        String rule = "";
        rule = rule + "package org.kie.pipeline.camel \n";
        rule = rule + "import org.kie.pipeline.camel.Person \n";
        rule = rule + "global java.util.List list \n";
        rule = rule + "query persons \n";
        rule = rule + "   $p : Person(name != null) \n";
        rule = rule + "end \n";
        rule = rule + "query personWithName(String param)\n";
        rule = rule + "   $p : Person(name == param) \n";
        rule = rule + "end \n";
        rule = rule + "rule rule1 \n";
        rule = rule + "  when \n";
        rule = rule + "    $p : Person() \n";
        rule = rule + " \n";
        rule = rule + "  then \n";
        rule = rule + "    System.out.println(\"executed\"); \n";
        rule = rule + "end\n";
        KieSession ksession = this.registerKnowledgeRuntime("ksession1", rule);
        InsertObjectCommand cmd = new InsertObjectCommand((Object)me);
        cmd.setOutIdentifier("camel-rider");
        cmd.setReturnObject(false);
        BatchExecutionCommandImpl script = new BatchExecutionCommandImpl(Arrays.asList(cmd));
        ExecutionResults results = (ExecutionResults)ksession.execute((Command)script);
        this.handle = ((FactHandle)results.getFactHandle("camel-rider")).toExternalForm();
    }

    @Override
    protected KieSession registerKnowledgeRuntime(String identifier, String rule) {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        KieResources kieResources = ks.getResources();
        Options xjcOpts = new Options();
        xjcOpts.setSchemaLanguage(Language.XMLSCHEMA);
        JaxbConfiguration jaxbConfiguration = KnowledgeBuilderFactory.newJaxbConfiguration((Options)xjcOpts, (String)"xsd");
        kfs.write(kieResources.newClassPathResource("person.xsd", ((Object)((Object)this)).getClass()).setResourceType(ResourceType.XSD).setConfiguration((ResourceConfiguration)jaxbConfiguration));
        if (rule != null && rule.length() > 0) {
            kfs.write("src/main/resources/rule.drl", rule);
        }
        String process1 = "";
        process1 = process1 + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        process1 = process1 + "<process xmlns=\"http://drools.org/drools-5.0/process\"\n";
        process1 = process1 + "         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n";
        process1 = process1 + "         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n";
        process1 = process1 + "         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions\" package-name=\"org.drools\" version=\"1\" >\n";
        process1 = process1 + "\n";
        process1 = process1 + "  <header>\n";
        process1 = process1 + "    <imports>\n";
        process1 = process1 + "      <import name=\"org.kie.camel.embedded.camel.testdomain.Person\" />\n";
        process1 = process1 + "    </imports>\n";
        process1 = process1 + "    <globals>\n";
        process1 = process1 + "      <global identifier=\"list\" type=\"java.util.List\" />\n";
        process1 = process1 + "    </globals>\n";
        process1 = process1 + "    <variables>\n";
        process1 = process1 + "      <variable name=\"person\" >\n";
        process1 = process1 + "        <type name=\"org.drools.core.process.core.datatype.impl.type.ObjectDataType\" className=\"Person\" />\n";
        process1 = process1 + "      </variable>\n";
        process1 = process1 + "    </variables>\n";
        process1 = process1 + "  </header>\n";
        process1 = process1 + "\n";
        process1 = process1 + "  <nodes>\n";
        process1 = process1 + "    <start id=\"1\" name=\"Start\" />\n";
        process1 = process1 + "    <actionNode id=\"2\" name=\"MyActionNode\" >\n";
        process1 = process1 + "      <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Triggered\");\n";
        process1 = process1 + "</action>\n";
        process1 = process1 + "    </actionNode>\n";
        process1 = process1 + "    <end id=\"3\" name=\"End\" />\n";
        process1 = process1 + "  </nodes>\n";
        process1 = process1 + "\n";
        process1 = process1 + "  <connections>\n";
        process1 = process1 + "    <connection from=\"1\" to=\"2\" />\n";
        process1 = process1 + "    <connection from=\"2\" to=\"3\" />\n";
        process1 = process1 + "  </connections>\n\n";
        process1 = process1 + "</process>";
        kfs.write("src/main/resources/process1.rf", process1);
        String process2 = "";
        process2 = process2 + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        process2 = process2 + "<process xmlns=\"http://drools.org/drools-5.0/process\"\n";
        process2 = process2 + "         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n";
        process2 = process2 + "         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n";
        process2 = process2 + "         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.core.event\" package-name=\"org.drools\" version=\"1\" >\n";
        process2 = process2 + "\n";
        process2 = process2 + "  <header>\n";
        process2 = process2 + "    <variables>\n";
        process2 = process2 + "      <variable name=\"MyVar\" >\n";
        process2 = process2 + "        <type name=\"org.drools.core.process.core.datatype.impl.type.StringDataType\" />\n";
        process2 = process2 + "        <value>SomeText</value>\n";
        process2 = process2 + "      </variable>\n";
        process2 = process2 + "    </variables>\n";
        process2 = process2 + "  </header>\n";
        process2 = process2 + "\n";
        process2 = process2 + "  <nodes>\n";
        process2 = process2 + "    <start id=\"1\" name=\"Start\" />\n";
        process2 = process2 + "    <eventNode id=\"2\" name=\"Event\" variableName=\"MyVar\" >\n";
        process2 = process2 + "      <eventFilters>\n";
        process2 = process2 + "        <eventFilter type=\"eventType\" eventType=\"MyEvent\" />\n";
        process2 = process2 + "      </eventFilters>\n";
        process2 = process2 + "    </eventNode>\n";
        process2 = process2 + "    <join id=\"3\" name=\"Join\" type=\"1\" />\n";
        process2 = process2 + "    <end id=\"4\" name=\"End\" />\n";
        process2 = process2 + "  </nodes>\n";
        process2 = process2 + "\n";
        process2 = process2 + "  <connections>\n";
        process2 = process2 + "    <connection from=\"1\" to=\"3\" />\n";
        process2 = process2 + "    <connection from=\"2\" to=\"3\" />\n";
        process2 = process2 + "    <connection from=\"3\" to=\"4\" />\n";
        process2 = process2 + "  </connections>\n";
        process2 = process2 + "\n";
        process2 = process2 + "</process>";
        kfs.write("src/main/resources/process2.rf", process2);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        if (!errors.isEmpty()) {
            CamelEndpointWithJaxbTest.fail((String)("" + errors));
        }
        KieSession ksession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
        try {
            this.jndiContext.bind(identifier, (Object)ksession);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        return ksession;
    }
}

