/*
 * Decompiled with CFR 0.152.
 */
package org.kie.config.cli;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Named;
import org.kie.config.cli.CliIdentity;
import org.uberfire.io.IOService;
import org.uberfire.io.impl.IOServiceDotFileImpl;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.rpc.impl.SessionInfoImpl;
import org.uberfire.security.Identity;
import org.uberfire.security.Resource;
import org.uberfire.security.Role;
import org.uberfire.security.Subject;
import org.uberfire.security.authz.AuthorizationException;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.security.authz.RuntimeResource;
import org.uberfire.security.impl.authz.RuntimeAuthorizationManager;
import org.uberfire.security.server.cdi.SecurityFactory;

@ApplicationScoped
public class EnvironmentProvider {
    private final IOService ioService = new IOServiceDotFileImpl();
    public static final Role ADMIN_ROLE = new Role(){

        public String getName() {
            return "admin";
        }
    };

    @PostConstruct
    public void setup() {
        SecurityFactory.setAuthzManager((AuthorizationManager)new RuntimeAuthorizationManager(){

            public boolean supports(Resource resource) {
                return resource instanceof RuntimeResource;
            }

            public boolean authorize(Resource resource, Subject subject) throws AuthorizationException {
                return subject.getRoles().contains(ADMIN_ROLE);
            }
        });
    }

    @Produces
    @Named(value="ioStrategy")
    public IOService ioService() {
        return this.ioService;
    }

    @Produces
    public SessionInfo getSessionInfo() {
        CliIdentity identity = new CliIdentity();
        return new SessionInfoImpl(identity.getName(), (Identity)identity);
    }
}

