/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.explorer.backend.server;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.repositories.Repository;
import org.kie.workbench.common.screens.explorer.model.FolderItem;
import org.uberfire.commons.data.Pair;
import org.uberfire.commons.data.Triple;

public class UserExplorerData {
    private OrganizationalUnit organizationalUnit = null;
    private Map<String, Object> content = new HashMap<String, Object>();
    private Map<String, Set<String>> organizationalUnitKeys = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> repositoryKeys = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> projectKeys = new HashMap<String, Set<String>>();

    public OrganizationalUnit getOrganizationalUnit() {
        return this.organizationalUnit;
    }

    public Repository get(OrganizationalUnit organizationalUnit) {
        if (organizationalUnit == null) {
            return null;
        }
        Object obj = this.content.get(organizationalUnit.getName());
        if (obj != null && obj instanceof Repository) {
            return (Repository)obj;
        }
        return null;
    }

    public Project get(OrganizationalUnit organizationalUnit, Repository repository) {
        if (organizationalUnit == null || repository == null) {
            return null;
        }
        Object obj = this.content.get(Pair.newPair((Object)organizationalUnit.getName(), (Object)repository.getAlias()).toString());
        if (obj != null && obj instanceof Project) {
            return (Project)obj;
        }
        return null;
    }

    public FolderItem getFolderItem(OrganizationalUnit organizationalUnit, Repository repository, Project project) {
        if (organizationalUnit == null || repository == null || project == null) {
            return null;
        }
        Object obj = this.content.get(new FolderItemKey(organizationalUnit.getName(), repository.getAlias(), project.getPomXMLPath().toURI()).toString());
        if (obj != null && obj instanceof FolderItem) {
            return (FolderItem)obj;
        }
        return null;
    }

    public Package getPackage(OrganizationalUnit organizationalUnit, Repository repository, Project project) {
        if (organizationalUnit == null || repository == null || project == null) {
            return null;
        }
        Object obj = this.content.get(new PackageKey(organizationalUnit.getName(), repository.getAlias(), project.getPomXMLPath().toURI()).toString());
        if (obj != null && obj instanceof Package) {
            return (Package)obj;
        }
        return null;
    }

    public void setOrganizationalUnit(OrganizationalUnit organizationalUnit) {
        this.organizationalUnit = organizationalUnit;
    }

    public void addRepository(OrganizationalUnit organizationalUnit, Repository repository) {
        this.content.put(organizationalUnit.getName(), repository);
        this.indexOrganizationalUnit(organizationalUnit);
    }

    public void addProject(OrganizationalUnit organizationalUnit, Repository repository, Project project) {
        String key = Pair.newPair((Object)organizationalUnit.getName(), (Object)repository.getAlias()).toString();
        this.content.put(key, project);
        this.indexOrganizationalUnit(organizationalUnit, key);
        this.indexRepository(repository, key);
    }

    public void addFolderItem(OrganizationalUnit organizationalUnit, Repository repository, Project project, FolderItem item) {
        String key = new FolderItemKey(organizationalUnit.getName(), repository.getAlias(), project.getPomXMLPath().toURI()).toString();
        this.content.put(key, item);
        this.indexOrganizationalUnit(organizationalUnit, key);
        this.indexRepository(repository, key);
        this.indexProject(project, key);
    }

    public void addPackage(OrganizationalUnit organizationalUnit, Repository repository, Project project, Package pkg) {
        String key = new PackageKey(organizationalUnit.getName(), repository.getAlias(), project.getPomXMLPath().toURI()).toString();
        this.content.put(key, pkg);
        this.indexOrganizationalUnit(organizationalUnit, key);
        this.indexRepository(repository, key);
        this.indexProject(project, key);
    }

    private void indexOrganizationalUnit(OrganizationalUnit organizationalUnit) {
        if (!this.organizationalUnitKeys.containsKey(organizationalUnit.getName())) {
            this.organizationalUnitKeys.put(organizationalUnit.getName(), new HashSet());
        }
        this.organizationalUnitKeys.get(organizationalUnit.getName()).add(organizationalUnit.getName());
    }

    private void indexOrganizationalUnit(OrganizationalUnit organizationalUnit, String key) {
        if (!this.organizationalUnitKeys.containsKey(organizationalUnit.getName())) {
            this.organizationalUnitKeys.put(organizationalUnit.getName(), new HashSet());
        }
        this.organizationalUnitKeys.get(organizationalUnit.getName()).add(key);
    }

    private void indexRepository(Repository repository, String key) {
        if (!this.repositoryKeys.containsKey(repository.getUri())) {
            this.repositoryKeys.put(repository.getUri(), new HashSet());
        }
        this.repositoryKeys.get(repository.getUri()).add(key);
    }

    private void indexProject(Project project, String key) {
        String projectRef = project.getPomXMLPath().toURI();
        if (!this.projectKeys.containsKey(projectRef)) {
            this.projectKeys.put(projectRef, new HashSet());
        }
        this.projectKeys.get(projectRef).add(key);
    }

    public boolean isEmpty() {
        return this.organizationalUnit == null && this.content.isEmpty();
    }

    public void deleteOrganizationalUnit(OrganizationalUnit organizationalUnit) {
        if (this.organizationalUnit.equals(organizationalUnit)) {
            this.organizationalUnit = null;
        }
        if (this.organizationalUnitKeys.containsKey(organizationalUnit.getName())) {
            for (String key2Delete : this.organizationalUnitKeys.get(organizationalUnit.getName())) {
                this.content.remove(key2Delete);
            }
        }
    }

    public void deleteRepository(Repository repository) {
        if (this.repositoryKeys.containsKey(repository.getUri())) {
            for (String key2Delete : this.repositoryKeys.get(repository.getUri())) {
                this.content.remove(key2Delete);
            }
        }
    }

    public boolean deleteProject(Project project) {
        boolean changed = false;
        String projectRef = project.getPomXMLPath().toURI();
        if (this.projectKeys.containsKey(projectRef)) {
            changed = true;
            for (String key2Delete : this.projectKeys.get(projectRef)) {
                this.content.remove(key2Delete);
            }
        }
        return changed;
    }

    private static class PackageKey
    extends Triple<String, String, String> {
        public PackageKey(String s, String s2, String s3) {
            super((Object)s, (Object)s2, (Object)s3);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (!(o instanceof PackageKey)) {
                return false;
            }
            return super.equals(o);
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + PackageKey.class.hashCode();
            return result;
        }
    }

    private static class FolderItemKey
    extends Triple<String, String, String> {
        public FolderItemKey(String s, String s2, String s3) {
            super((Object)s, (Object)s2, (Object)s3);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (!(o instanceof FolderItemKey)) {
                return false;
            }
            return super.equals(o);
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + FolderItemKey.class.hashCode();
            return result;
        }
    }
}

