/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import javax.activation.MimeType;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.i18n.text.CharUtils;
import org.apache.abdera.i18n.text.Filter;
import org.apache.abdera.i18n.text.UrlEncoding;
import org.apache.abdera.model.AtomDate;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Person;
import org.apache.abdera.model.Text;
import org.apache.abdera.parser.ParseException;
import org.apache.abdera.protocol.server.ProviderHelper;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.context.EmptyResponseContext;
import org.apache.abdera.protocol.server.context.MediaResponseContext;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.apache.abdera.protocol.server.impl.AbstractCollectionAdapter;
import org.apache.abdera.util.EntityTag;
import org.apache.abdera.util.MimeTypeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEntityCollectionAdapter<T>
extends AbstractCollectionAdapter {
    private static final Log log = LogFactory.getLog(AbstractEntityCollectionAdapter.class);

    public abstract T postEntry(String var1, IRI var2, String var3, Date var4, List<Person> var5, Content var6, RequestContext var7) throws ResponseContextException;

    @Override
    public ResponseContext postMedia(RequestContext request) {
        return this.createMediaEntry(request);
    }

    @Override
    public ResponseContext putMedia(RequestContext request) {
        try {
            String id = this.getResourceName(request);
            T entryObj = this.getEntry(id, request);
            this.putMedia(entryObj, request.getContentType(), request.getSlug(), request.getInputStream(), request);
            return new EmptyResponseContext(200);
        }
        catch (IOException e) {
            return new EmptyResponseContext(500);
        }
        catch (ResponseContextException e) {
            return this.createErrorResponse(e);
        }
    }

    public void putMedia(T entryObj, MimeType contentType, String slug, InputStream inputStream, RequestContext request) throws ResponseContextException {
        throw new ResponseContextException(ProviderHelper.notallowed(request));
    }

    @Override
    public ResponseContext postEntry(RequestContext request) {
        return this.createNonMediaEntry(request);
    }

    protected String getLink(T entryObj, IRI feedIri, RequestContext request) throws ResponseContextException {
        return this.getLink(entryObj, feedIri, request, false);
    }

    protected String getLink(T entryObj, IRI feedIri, RequestContext request, boolean absolute) throws ResponseContextException {
        return this.getLink(this.getName(entryObj), entryObj, feedIri, request, absolute);
    }

    protected String getLink(String name, T entryObj, IRI feedIri, RequestContext request) {
        return this.getLink(name, entryObj, feedIri, request, false);
    }

    protected String getLink(String name, T entryObj, IRI feedIri, RequestContext request, boolean absolute) {
        feedIri = feedIri.trailingSlash();
        IRI entryIri = feedIri.resolve(UrlEncoding.encode((CharSequence)name, (Filter)CharUtils.Profile.PATH.filter()));
        if (absolute) {
            entryIri = request.getResolvedUri().resolve(entryIri);
        }
        String link = entryIri.toString();
        String qp = this.getQueryParameters(entryObj, request);
        if (qp != null && !"".equals(qp)) {
            StringBuilder sb = new StringBuilder();
            sb.append(link).append("?").append(qp);
            link = sb.toString();
        }
        return link;
    }

    protected String getQueryParameters(T entryObj, RequestContext request) {
        return null;
    }

    public T postMedia(MimeType mimeType, String slug, InputStream inputStream, RequestContext request) throws ResponseContextException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResponseContext deleteEntry(RequestContext request) {
        String id = this.getResourceName(request);
        if (id != null) {
            try {
                this.deleteEntry(id, request);
            }
            catch (ResponseContextException e) {
                return this.createErrorResponse(e);
            }
            return new EmptyResponseContext(204);
        }
        return new EmptyResponseContext(404);
    }

    public abstract void deleteEntry(String var1, RequestContext var2) throws ResponseContextException;

    @Override
    public ResponseContext deleteMedia(RequestContext request) {
        String resourceName = this.getResourceName(request);
        if (resourceName != null) {
            try {
                this.deleteMedia(resourceName, request);
            }
            catch (ResponseContextException e) {
                return this.createErrorResponse(e);
            }
            return new EmptyResponseContext(204);
        }
        return new EmptyResponseContext(404);
    }

    public void deleteMedia(String resourceName, RequestContext request) throws ResponseContextException {
        throw new ResponseContextException(ProviderHelper.notsupported(request));
    }

    public List<Person> getAuthors(T entry, RequestContext request) throws ResponseContextException {
        return null;
    }

    public abstract Object getContent(T var1, RequestContext var2) throws ResponseContextException;

    public String getContentType(T entry) {
        throw new UnsupportedOperationException();
    }

    public abstract Iterable<T> getEntries(RequestContext var1) throws ResponseContextException;

    @Override
    public ResponseContext getEntry(RequestContext request) {
        try {
            Entry entry = this.getEntryFromCollectionProvider(request);
            if (entry != null) {
                return this.buildGetEntryResponse(request, entry);
            }
            return new EmptyResponseContext(404);
        }
        catch (ResponseContextException e) {
            return this.createErrorResponse(e);
        }
    }

    public abstract T getEntry(String var1, RequestContext var2) throws ResponseContextException;

    @Override
    public ResponseContext headEntry(RequestContext request) {
        try {
            String resourceName = this.getResourceName(request);
            T entryObj = this.getEntry(resourceName, request);
            if (entryObj != null) {
                return this.buildHeadEntryResponse(request, resourceName, this.getUpdated(entryObj));
            }
            return new EmptyResponseContext(404);
        }
        catch (ResponseContextException e) {
            return this.createErrorResponse(e);
        }
    }

    @Override
    public ResponseContext headMedia(RequestContext request) {
        try {
            String resourceName = this.getResourceName(request);
            T entryObj = this.getEntry(resourceName, request);
            if (entryObj != null) {
                return this.buildHeadEntryResponse(request, resourceName, this.getUpdated(entryObj));
            }
            return new EmptyResponseContext(404);
        }
        catch (ResponseContextException e) {
            return this.createErrorResponse(e);
        }
    }

    @Override
    public ResponseContext getFeed(RequestContext request) {
        try {
            Feed feed = this.createFeedBase(request);
            this.addFeedDetails(feed, request);
            return this.buildGetFeedResponse(feed);
        }
        catch (ResponseContextException e) {
            return this.createErrorResponse(e);
        }
    }

    protected void addFeedDetails(Feed feed, RequestContext request) throws ResponseContextException {
        feed.setUpdated(new Date());
        Iterable<T> entries = this.getEntries(request);
        if (entries != null) {
            for (T entryObj : entries) {
                Entry e = feed.addEntry();
                IRI feedIri = new IRI(this.getFeedIriForEntry(entryObj, request));
                this.addEntryDetails(request, e, feedIri, entryObj);
                if (this.isMediaEntry(entryObj)) {
                    this.addMediaContent(feedIri, e, entryObj, request);
                    continue;
                }
                this.addContent(e, entryObj, request);
            }
        }
    }

    private IRI getFeedIRI(T entryObj, RequestContext request) {
        String feedIri = this.getFeedIriForEntry(entryObj, request);
        return new IRI(feedIri).trailingSlash();
    }

    public abstract String getId(T var1) throws ResponseContextException;

    @Override
    public ResponseContext getMedia(RequestContext request) {
        try {
            String resource = this.getResourceName(request);
            T entryObj = this.getEntry(resource, request);
            if (entryObj == null) {
                return new EmptyResponseContext(404);
            }
            return this.buildGetMediaResponse(resource, entryObj);
        }
        catch (ParseException pe) {
            return new EmptyResponseContext(415);
        }
        catch (ClassCastException cce) {
            return new EmptyResponseContext(415);
        }
        catch (ResponseContextException e) {
            return e.getResponseContext();
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            return new EmptyResponseContext(400);
        }
    }

    protected ResponseContext buildGetMediaResponse(String id, T entryObj) throws ResponseContextException {
        Date updated = this.getUpdated(entryObj);
        MediaResponseContext ctx = new MediaResponseContext(this.getMediaStream(entryObj), updated, 200);
        ctx.setContentType(this.getContentType(entryObj));
        ctx.setEntityTag(EntityTag.generate((String[])new String[]{id, AtomDate.format((Date)updated)}));
        return ctx;
    }

    public String getMediaName(T entry) throws ResponseContextException {
        throw new UnsupportedOperationException();
    }

    public InputStream getMediaStream(T entry) throws ResponseContextException {
        throw new UnsupportedOperationException();
    }

    public abstract String getName(T var1) throws ResponseContextException;

    public abstract String getTitle(T var1) throws ResponseContextException;

    public abstract Date getUpdated(T var1) throws ResponseContextException;

    public boolean isMediaEntry(T entry) throws ResponseContextException {
        return false;
    }

    @Override
    public ResponseContext putEntry(RequestContext request) {
        try {
            String id = this.getResourceName(request);
            T entryObj = this.getEntry(id, request);
            if (entryObj == null) {
                return new EmptyResponseContext(404);
            }
            Entry orig_entry = this.getEntryFromCollectionProvider(entryObj, new IRI(this.getFeedIriForEntry(entryObj, request)), request);
            if (orig_entry != null) {
                MimeType contentType = request.getContentType();
                if (contentType != null && !MimeTypeHelper.isAtom((String)contentType.toString())) {
                    return new EmptyResponseContext(415);
                }
                Entry entry = this.getEntryFromRequest(request);
                if (entry != null) {
                    if (!entry.getId().equals((Object)orig_entry.getId())) {
                        return new EmptyResponseContext(409);
                    }
                    if (!ProviderHelper.isValidEntry(entry)) {
                        return new EmptyResponseContext(400);
                    }
                    this.putEntry(entryObj, entry.getTitle(), new Date(), entry.getAuthors(), entry.getSummary(), entry.getContentElement(), request);
                    return new EmptyResponseContext(204);
                }
                return new EmptyResponseContext(400);
            }
            return new EmptyResponseContext(404);
        }
        catch (ResponseContextException e) {
            return this.createErrorResponse(e);
        }
        catch (ParseException pe) {
            return new EmptyResponseContext(415);
        }
        catch (ClassCastException cce) {
            return new EmptyResponseContext(415);
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            return new EmptyResponseContext(400);
        }
    }

    protected String getFeedIriForEntry(T entryObj, RequestContext request) {
        return this.getHref(request);
    }

    public abstract void putEntry(T var1, String var2, Date var3, List<Person> var4, String var5, Content var6, RequestContext var7) throws ResponseContextException;

    protected void addContent(Entry e, T doc, RequestContext request) throws ResponseContextException {
        Object content = this.getContent(doc, request);
        if (content instanceof Content) {
            e.setContentElement((Content)content);
        } else if (content instanceof String) {
            e.setContent((String)content);
        }
    }

    protected String addEntryDetails(RequestContext request, Entry e, IRI feedIri, T entryObj) throws ResponseContextException {
        Text t;
        String link = this.getLink(entryObj, feedIri, request);
        e.addLink(link, "edit");
        e.setId(this.getId(entryObj));
        e.setTitle(this.getTitle(entryObj));
        e.setUpdated(this.getUpdated(entryObj));
        List<Person> authors = this.getAuthors(entryObj, request);
        if (authors != null) {
            for (Person a : authors) {
                e.addAuthor(a);
            }
        }
        if ((t = this.getSummary(entryObj, request)) != null) {
            e.setSummaryElement(t);
        }
        return link;
    }

    public Text getSummary(T entry, RequestContext request) throws ResponseContextException {
        return null;
    }

    protected String addMediaContent(IRI feedIri, Entry entry, T entryObj, RequestContext request) throws ResponseContextException {
        String name = this.getMediaName(entryObj);
        IRI mediaIri = new IRI(this.getLink(name, entryObj, feedIri, request));
        String mediaLink = mediaIri.toString();
        entry.setContent(mediaIri, this.getContentType(entryObj));
        entry.addLink(mediaLink, "edit-media");
        return mediaLink;
    }

    protected ResponseContext createMediaEntry(RequestContext request) {
        try {
            T entryObj = this.postMedia(request.getContentType(), request.getSlug(), request.getInputStream(), request);
            IRI feedUri = this.getFeedIRI(entryObj, request);
            Entry entry = request.getAbdera().getFactory().newEntry();
            String link = this.addEntryDetails(request, entry, feedUri, entryObj);
            this.addMediaContent(feedUri, entry, entryObj, request);
            String location = this.getLink(entryObj, feedUri, request, true);
            return this.buildPostMediaEntryResponse(location, entry);
        }
        catch (IOException e) {
            return new EmptyResponseContext(500);
        }
        catch (ResponseContextException e) {
            return this.createErrorResponse(e);
        }
    }

    protected ResponseContext createNonMediaEntry(RequestContext request) {
        try {
            Entry entry = this.getEntryFromRequest(request);
            if (entry != null) {
                if (!ProviderHelper.isValidEntry(entry)) {
                    return new EmptyResponseContext(400);
                }
                entry.setUpdated(new Date());
                T entryObj = this.postEntry(entry.getTitle(), entry.getId(), entry.getSummary(), entry.getUpdated(), entry.getAuthors(), entry.getContentElement(), request);
                entry.getIdElement().setValue(this.getId(entryObj));
                IRI feedUri = this.getFeedIRI(entryObj, request);
                String link = this.getLink(entryObj, feedUri, request);
                entry.addLink(link, "edit");
                String location = this.getLink(entryObj, feedUri, request, true);
                return this.buildCreateEntryResponse(location, entry);
            }
            return new EmptyResponseContext(400);
        }
        catch (ResponseContextException e) {
            return this.createErrorResponse(e);
        }
    }

    protected Entry getEntryFromCollectionProvider(RequestContext request) throws ResponseContextException {
        String id = this.getResourceName(request);
        T entryObj = this.getEntry(id, request);
        if (entryObj == null) {
            return null;
        }
        IRI feedIri = new IRI(this.getFeedIriForEntry(entryObj, request));
        return this.getEntryFromCollectionProvider(entryObj, feedIri, request);
    }

    Entry getEntryFromCollectionProvider(T entryObj, IRI feedIri, RequestContext request) throws ResponseContextException {
        Abdera abdera = request.getAbdera();
        Factory factory = abdera.getFactory();
        Entry entry = factory.newEntry();
        return this.buildEntry(entryObj, entry, feedIri, request);
    }

    private Entry buildEntry(T entryObj, Entry entry, IRI feedIri, RequestContext request) throws ResponseContextException {
        this.addEntryDetails(request, entry, feedIri, entryObj);
        if (this.isMediaEntry(entryObj)) {
            this.addMediaContent(feedIri, entry, entryObj, request);
        } else {
            this.addContent(entry, entryObj, request);
        }
        return entry;
    }
}

