/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.deploy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorIO;
import org.kie.internal.runtime.conf.AuditMode;
import org.kie.internal.runtime.conf.BuilderHandler;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.DeploymentDescriptorBuilder;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.conf.PersistenceMode;
import org.kie.internal.runtime.conf.RuntimeStrategy;

@XmlRootElement(name="deployment-descriptor")
@XmlAccessorType(value=XmlAccessType.NONE)
public class DeploymentDescriptorImpl
implements DeploymentDescriptor,
Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="persistence-unit")
    @XmlSchemaType(name="string")
    private String persistenceUnit;
    @XmlElement(name="audit-persistence-unit")
    @XmlSchemaType(name="string")
    private String auditPersistenceUnit;
    @XmlElement(name="audit-mode")
    private AuditMode auditMode = AuditMode.JPA;
    @XmlElement(name="persistence-mode")
    private PersistenceMode persistenceMode = PersistenceMode.JPA;
    @XmlElement(name="runtime-strategy")
    private RuntimeStrategy runtimeStrategy = RuntimeStrategy.SINGLETON;
    @XmlElement(name="marshalling-strategy")
    @XmlElementWrapper(name="marshalling-strategies")
    private Set<ObjectModel> marshallingStrategies = new HashSet<ObjectModel>();
    @XmlElement(name="event-listener")
    @XmlElementWrapper(name="event-listeners")
    private Set<ObjectModel> eventListeners = new HashSet<ObjectModel>();
    @XmlElement(name="task-event-listener")
    @XmlElementWrapper(name="task-event-listeners")
    private Set<ObjectModel> taskEventListeners = new HashSet<ObjectModel>();
    @XmlElement(name="global")
    @XmlElementWrapper(name="globals")
    private Set<NamedObjectModel> globals = new HashSet<NamedObjectModel>();
    @XmlElement(name="work-item-handler")
    @XmlElementWrapper(name="work-item-handlers")
    private Set<NamedObjectModel> workItemHandlers = new HashSet<NamedObjectModel>();
    @XmlElement(name="environment-entry")
    @XmlElementWrapper(name="environment-entries")
    private Set<NamedObjectModel> environmentEntries = new HashSet<NamedObjectModel>();
    @XmlElement(name="configuration")
    @XmlElementWrapper(name="configurations")
    private Set<NamedObjectModel> configuration = new HashSet<NamedObjectModel>();
    @XmlElement(name="required-role")
    @XmlElementWrapper(name="required-roles")
    private Set<String> requiredRoles = new HashSet<String>();
    @XmlElement(name="remoteable-class")
    @XmlElementWrapper(name="remoteable-classes")
    private List<String> classes = new ArrayList<String>();

    public DeploymentDescriptorImpl() {
    }

    public DeploymentDescriptorImpl(String defaultPU) {
        this.persistenceUnit = defaultPU;
        this.auditPersistenceUnit = defaultPU;
    }

    public String getPersistenceUnit() {
        return this.persistenceUnit;
    }

    public String getAuditPersistenceUnit() {
        return this.auditPersistenceUnit;
    }

    public AuditMode getAuditMode() {
        return this.auditMode;
    }

    public PersistenceMode getPersistenceMode() {
        return this.persistenceMode;
    }

    public RuntimeStrategy getRuntimeStrategy() {
        return this.runtimeStrategy;
    }

    public List<ObjectModel> getMarshallingStrategies() {
        return new ArrayList<ObjectModel>(this.marshallingStrategies);
    }

    public List<ObjectModel> getEventListeners() {
        return new ArrayList<ObjectModel>(this.eventListeners);
    }

    public List<NamedObjectModel> getGlobals() {
        return new ArrayList<NamedObjectModel>(this.globals);
    }

    public List<NamedObjectModel> getWorkItemHandlers() {
        return new ArrayList<NamedObjectModel>(this.workItemHandlers);
    }

    public List<ObjectModel> getTaskEventListeners() {
        return new ArrayList<ObjectModel>(this.taskEventListeners);
    }

    public List<NamedObjectModel> getEnvironmentEntries() {
        return new ArrayList<NamedObjectModel>(this.environmentEntries);
    }

    public List<NamedObjectModel> getConfiguration() {
        return new ArrayList<NamedObjectModel>(this.configuration);
    }

    public List<String> getRequiredRoles() {
        return new ArrayList<String>(this.requiredRoles);
    }

    public List<String> getClasses() {
        if (this.classes == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(this.classes);
    }

    public void setPersistenceUnit(String persistenceUnit) {
        this.persistenceUnit = persistenceUnit;
    }

    public void setAuditPersistenceUnit(String auditPersistenceUnit) {
        this.auditPersistenceUnit = auditPersistenceUnit;
    }

    public void setAuditMode(AuditMode auditMode) {
        this.auditMode = auditMode;
    }

    public void setPersistenceMode(PersistenceMode persistenceMode) {
        this.persistenceMode = persistenceMode;
    }

    public void setRuntimeStrategy(RuntimeStrategy runtimeStrategy) {
        this.runtimeStrategy = runtimeStrategy;
    }

    public void setMarshallingStrategies(List<ObjectModel> marshallingStrategies) {
        if (marshallingStrategies != null) {
            this.marshallingStrategies = new HashSet<ObjectModel>(marshallingStrategies);
        }
    }

    public void setEventListeners(List<ObjectModel> eventListeners) {
        if (eventListeners != null) {
            this.eventListeners = new HashSet<ObjectModel>(eventListeners);
        }
    }

    public void setTaskEventListeners(List<ObjectModel> taskEventListeners) {
        if (taskEventListeners != null) {
            this.taskEventListeners = new HashSet<ObjectModel>(taskEventListeners);
        }
    }

    public void setGlobals(List<NamedObjectModel> globals) {
        if (globals != null) {
            this.globals = new HashSet<NamedObjectModel>(globals);
        }
    }

    public void setWorkItemHandlers(List<NamedObjectModel> workItemHandlers) {
        if (workItemHandlers != null) {
            this.workItemHandlers = new HashSet<NamedObjectModel>(workItemHandlers);
        }
    }

    public void setEnvironmentEntries(List<NamedObjectModel> environmentEntires) {
        if (environmentEntires != null) {
            this.environmentEntries = new HashSet<NamedObjectModel>(environmentEntires);
        }
    }

    public void setConfiguration(List<NamedObjectModel> configuration) {
        if (configuration != null) {
            this.configuration = new HashSet<NamedObjectModel>(configuration);
        }
    }

    public void setRequiredRoles(List<String> requiredRoles) {
        if (requiredRoles != null) {
            this.requiredRoles = new HashSet<String>(requiredRoles);
        }
    }

    public void setClasses(List<String> classes) {
        if (classes != null) {
            this.classes = new ArrayList<String>(classes);
        }
    }

    public DeploymentDescriptorBuilder getBuilder() {
        return new DeploymentDescriptorBuilder(){
            private BuilderHandler handler = new BuilderHandler(){

                public boolean accepted(Object value) {
                    return true;
                }
            };
            private DeploymentDescriptorImpl descriptor = DeploymentDescriptorImpl.this;

            public DeploymentDescriptorBuilder runtimeStrategy(RuntimeStrategy strategy) {
                if (this.handler.accepted((Object)strategy)) {
                    this.descriptor.setRuntimeStrategy(strategy);
                }
                return this;
            }

            public DeploymentDescriptorBuilder persistenceUnit(String pu) {
                if (this.handler.accepted((Object)pu)) {
                    this.descriptor.setPersistenceUnit(pu);
                }
                return this;
            }

            public DeploymentDescriptorBuilder persistenceMode(PersistenceMode mode) {
                if (this.handler.accepted((Object)mode)) {
                    this.descriptor.setPersistenceMode(mode);
                }
                return this;
            }

            public DeploymentDescriptorBuilder auditPersistenceUnit(String pu) {
                if (this.handler.accepted((Object)pu)) {
                    this.descriptor.setAuditPersistenceUnit(pu);
                }
                return this;
            }

            public DeploymentDescriptorBuilder auditMode(AuditMode mode) {
                if (this.handler.accepted((Object)mode)) {
                    this.descriptor.setAuditMode(mode);
                }
                return this;
            }

            public DeploymentDescriptorBuilder addWorkItemHandler(NamedObjectModel model) {
                if (this.handler.accepted((Object)model)) {
                    this.descriptor.workItemHandlers.add(model);
                }
                return this;
            }

            public DeploymentDescriptorBuilder addTaskEventListener(ObjectModel model) {
                if (this.handler.accepted((Object)model)) {
                    this.descriptor.taskEventListeners.add(model);
                }
                return this;
            }

            public DeploymentDescriptorBuilder addMarshalingStrategy(ObjectModel model) {
                if (this.handler.accepted((Object)model)) {
                    this.descriptor.marshallingStrategies.add(model);
                }
                return this;
            }

            public DeploymentDescriptorBuilder addGlobal(NamedObjectModel model) {
                if (this.handler.accepted((Object)model)) {
                    this.descriptor.globals.add(model);
                }
                return this;
            }

            public DeploymentDescriptorBuilder addEventListener(ObjectModel model) {
                if (this.handler.accepted((Object)model)) {
                    this.descriptor.eventListeners.add(model);
                }
                return this;
            }

            public DeploymentDescriptorBuilder addEnvironmentEntry(NamedObjectModel model) {
                if (this.handler.accepted((Object)model)) {
                    this.descriptor.environmentEntries.add(model);
                }
                return this;
            }

            public DeploymentDescriptorBuilder addConfiguration(NamedObjectModel model) {
                if (this.handler.accepted((Object)model)) {
                    this.descriptor.configuration.add(model);
                }
                return this;
            }

            public DeploymentDescriptorBuilder addRequiredRole(String role) {
                if (this.handler.accepted((Object)role)) {
                    this.descriptor.requiredRoles.add(role);
                }
                return this;
            }

            public DeploymentDescriptorBuilder addClass(String clazz) {
                if (this.handler.accepted((Object)clazz)) {
                    this.descriptor.classes.add(clazz);
                }
                return this;
            }

            public DeploymentDescriptorBuilder setConfiguration(List<NamedObjectModel> models) {
                if (this.handler.accepted(models)) {
                    this.descriptor.setConfiguration(models);
                }
                return this;
            }

            public DeploymentDescriptorBuilder setEnvironmentEntries(List<NamedObjectModel> models) {
                if (this.handler.accepted(models)) {
                    this.descriptor.setEnvironmentEntries(models);
                }
                return this;
            }

            public DeploymentDescriptorBuilder setWorkItemHandlers(List<NamedObjectModel> models) {
                if (this.handler.accepted(models)) {
                    this.descriptor.setWorkItemHandlers(models);
                }
                return this;
            }

            public DeploymentDescriptorBuilder setGlobals(List<NamedObjectModel> models) {
                if (this.handler.accepted(models)) {
                    this.descriptor.setGlobals(models);
                }
                return this;
            }

            public DeploymentDescriptorBuilder setEventListeners(List<ObjectModel> models) {
                if (this.handler.accepted(models)) {
                    this.descriptor.setEventListeners(models);
                }
                return this;
            }

            public DeploymentDescriptorBuilder setTaskEventListeners(List<ObjectModel> models) {
                if (this.handler.accepted(models)) {
                    this.descriptor.setTaskEventListeners(models);
                }
                return this;
            }

            public DeploymentDescriptorBuilder setMarshalingStrategies(List<ObjectModel> models) {
                if (this.handler.accepted(models)) {
                    this.descriptor.setMarshallingStrategies(models);
                }
                return this;
            }

            public DeploymentDescriptorBuilder setRequiredRoles(List<String> roles) {
                if (this.handler.accepted(roles)) {
                    this.descriptor.setRequiredRoles(roles);
                }
                return this;
            }

            public DeploymentDescriptorBuilder setClasses(List<String> classes) {
                if (this.handler.accepted(classes)) {
                    this.descriptor.setClasses(classes);
                }
                return this;
            }

            public void setBuildHandler(BuilderHandler handler) {
                this.handler = handler;
            }

            public DeploymentDescriptor get() {
                return this.descriptor;
            }
        };
    }

    public String toXml() {
        return DeploymentDescriptorIO.toXml(this);
    }
}

