/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server.auth;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.Alternative;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.commons.validation.Preconditions;
import org.uberfire.security.ResourceManager;
import org.uberfire.security.SecurityContext;
import org.uberfire.security.Subject;
import org.uberfire.security.auth.AuthenticatedStorageProvider;
import org.uberfire.security.auth.AuthenticationException;
import org.uberfire.security.auth.AuthenticationManager;
import org.uberfire.security.auth.AuthenticationProvider;
import org.uberfire.security.auth.AuthenticationResult;
import org.uberfire.security.auth.AuthenticationScheme;
import org.uberfire.security.auth.AuthenticationStatus;
import org.uberfire.security.auth.Credential;
import org.uberfire.security.auth.Principal;
import org.uberfire.security.auth.RoleProvider;
import org.uberfire.security.auth.SubjectPropertiesProvider;
import org.uberfire.security.impl.IdentityImpl;
import org.uberfire.security.impl.RoleImpl;
import org.uberfire.security.server.HttpSecurityContext;
import org.uberfire.security.server.cdi.SecurityFactory;

@Alternative
public class HttpAuthenticationManager
implements AuthenticationManager {
    private final List<AuthenticationScheme> authSchemes;
    private final List<AuthenticationProvider> authProviders;
    private final List<RoleProvider> roleProviders;
    private final List<SubjectPropertiesProvider> subjectPropertiesProviders;
    private final List<AuthenticatedStorageProvider> authStorageProviders;
    private final ResourceManager resourceManager;
    private final Map<String, String> requestCache = new HashMap<String, String>();
    private final String forceURL;

    public HttpAuthenticationManager(List<AuthenticationScheme> authScheme, String forceURL, List<AuthenticationProvider> authProviders, List<RoleProvider> roleProviders, List<SubjectPropertiesProvider> subjectPropertiesProviders, List<AuthenticatedStorageProvider> authStorageProviders, ResourceManager resourceManager) {
        this.forceURL = forceURL;
        this.authSchemes = (List)PortablePreconditions.checkNotEmpty((String)"authScheme", authScheme);
        this.authProviders = (List)PortablePreconditions.checkNotEmpty((String)"authProviders", authProviders);
        this.roleProviders = (List)PortablePreconditions.checkNotEmpty((String)"roleProviders", roleProviders);
        this.subjectPropertiesProviders = (List)PortablePreconditions.checkNotNull((String)"subjectPropertiesProviders", subjectPropertiesProviders);
        this.authStorageProviders = (List)PortablePreconditions.checkNotEmpty((String)"authStorageProviders", authStorageProviders);
        this.resourceManager = (ResourceManager)PortablePreconditions.checkNotNull((String)"resourceManager", (Object)resourceManager);
    }

    public Subject authenticate(SecurityContext context) throws AuthenticationException {
        AuthenticatedStorageProvider storeProvider;
        HttpSecurityContext httpContext = (HttpSecurityContext)Preconditions.checkInstanceOf((String)"context", (Object)context, HttpSecurityContext.class);
        Principal principal = null;
        Iterator<AuthenticatedStorageProvider> i$ = this.authStorageProviders.iterator();
        while (i$.hasNext() && (principal = (storeProvider = i$.next()).load((SecurityContext)httpContext)) == null) {
        }
        if (principal != null && principal instanceof Subject) {
            return (Subject)principal;
        }
        boolean isRememberOp = principal != null;
        boolean requiresAuthentication = this.resourceManager.requiresAuthentication(httpContext.getResource());
        if (principal == null) {
            for (AuthenticationScheme authScheme : this.authSchemes) {
                if (authScheme.isAuthenticationRequest((SecurityContext)httpContext)) break;
                if (!requiresAuthentication) continue;
                if (!this.requestCache.containsKey(httpContext.getRequest().getSession().getId())) {
                    String preservedQueryStr = httpContext.getRequest().getQueryString();
                    preservedQueryStr = preservedQueryStr == null ? "" : "?" + preservedQueryStr;
                    String referer = httpContext.getRequest().getHeader("Referer");
                    if (preservedQueryStr.equals("") && referer != null && referer.indexOf(63) >= 0) {
                        preservedQueryStr = referer.substring(referer.indexOf(63));
                    }
                    if (this.forceURL != null) {
                        String contextPrefix = "";
                        if (this.forceURL.startsWith("/")) {
                            contextPrefix = httpContext.getRequest().getContextPath();
                        }
                        this.requestCache.put(httpContext.getRequest().getSession().getId(), contextPrefix + this.forceURL + preservedQueryStr);
                    } else {
                        this.requestCache.put(httpContext.getRequest().getSession().getId(), httpContext.getRequest().getRequestURI() + preservedQueryStr);
                    }
                }
                authScheme.challengeClient((SecurityContext)httpContext);
            }
            if (!requiresAuthentication) {
                return null;
            }
            block4: for (AuthenticationScheme authScheme : this.authSchemes) {
                Credential credential = authScheme.buildCredential((SecurityContext)httpContext);
                if (credential == null) continue;
                for (AuthenticationProvider authProvider : this.authProviders) {
                    AuthenticationResult result = authProvider.authenticate(credential, context);
                    if (result.getStatus().equals((Object)AuthenticationStatus.FAILED)) {
                        authScheme.challengeClient((SecurityContext)httpContext);
                        throw new AuthenticationException("Invalid credentials.");
                    }
                    if (!result.getStatus().equals((Object)AuthenticationStatus.SUCCESS)) continue;
                    principal = result.getPrincipal();
                    break block4;
                }
            }
        }
        if (principal == null) {
            throw new AuthenticationException("Invalid credentials.");
        }
        ArrayList<RoleImpl> roles = new ArrayList<RoleImpl>();
        if (isRememberOp) {
            roles.add(new RoleImpl("IS_REMEMBER_ME"));
        }
        for (RoleProvider roleProvider : this.roleProviders) {
            roles.addAll(roleProvider.loadRoles(principal, context));
        }
        HashMap properties = new HashMap();
        for (SubjectPropertiesProvider propertiesProvider : this.subjectPropertiesProviders) {
            properties.putAll(propertiesProvider.loadProperties(principal));
        }
        String name = principal.getName();
        IdentityImpl result = new IdentityImpl(name, roles, properties);
        for (AuthenticatedStorageProvider storeProvider2 : this.authStorageProviders) {
            storeProvider2.store((SecurityContext)httpContext, (Subject)result);
        }
        String originalRequest = this.requestCache.remove(httpContext.getRequest().getSession().getId());
        if (originalRequest != null && !originalRequest.isEmpty() && !httpContext.getResponse().isCommitted()) {
            try {
                if (this.useRedirect(originalRequest)) {
                    httpContext.getResponse().sendRedirect(originalRequest);
                } else {
                    SecurityFactory.setSubject((Subject)result);
                    RequestDispatcher rd = httpContext.getRequest().getRequestDispatcher(originalRequest.replaceFirst(httpContext.getRequest().getContextPath(), ""));
                    rd.forward((ServletRequest)httpContext.getRequest(), (ServletResponse)httpContext.getResponse());
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to redirect.", e);
            }
        }
        return result;
    }

    public void logout(SecurityContext context) throws AuthenticationException {
        for (AuthenticatedStorageProvider storeProvider : this.authStorageProviders) {
            storeProvider.cleanup(context);
        }
        HttpSecurityContext httpContext = (HttpSecurityContext)Preconditions.checkInstanceOf((String)"context", (Object)context, HttpSecurityContext.class);
        httpContext.getRequest().getSession().invalidate();
        try {
            httpContext.getRequest().logout();
        }
        catch (ServletException e) {
            e.printStackTrace();
        }
    }

    private boolean useRedirect(String originalRequest) {
        return originalRequest.contains("gwt.codesvr") || originalRequest.contains("/uf_security_check");
    }

    public String toString() {
        return "HttpAuthenticationManager [authSchemes=" + this.authSchemes + ", authProviders=" + this.authProviders + ", roleProviders=" + this.roleProviders + ", subjectPropertiesProviders=" + this.subjectPropertiesProviders + ", authStorageProviders=" + this.authStorageProviders + ", resourceManager=" + this.resourceManager + ", requestCache=" + this.requestCache + ", forceURL=" + this.forceURL + "]";
    }
}

