/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server.auth.source;

import java.io.IOException;
import java.lang.reflect.Method;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import org.uberfire.commons.validation.Preconditions;
import org.uberfire.security.Role;
import org.uberfire.security.SecurityContext;
import org.uberfire.security.auth.AuthenticationSource;
import org.uberfire.security.auth.Credential;
import org.uberfire.security.auth.Principal;
import org.uberfire.security.auth.RoleProvider;
import org.uberfire.security.auth.RolesMode;
import org.uberfire.security.impl.RoleImpl;
import org.uberfire.security.impl.auth.UsernamePasswordCredential;
import org.uberfire.security.server.auth.source.adapter.RolesAdapter;

public class JAASAuthenticationSource
implements AuthenticationSource,
RoleProvider {
    public static final String DEFAULT_ROLE_PRINCIPLE_NAME = "Roles";
    private String rolePrincipleName = "Roles";
    private final ThreadLocal<Subject> subjects = new ThreadLocal();
    private String domain = "ApplicationRealm";
    private RolesMode mode = RolesMode.ROLE;
    private ServiceLoader<RolesAdapter> rolesAdapterServiceLoader = ServiceLoader.load(RolesAdapter.class);

    public void initialize(Map<String, ?> options) {
        if (options.containsKey("org.uberfire.domain")) {
            this.domain = (String)options.get("org.uberfire.domain");
        }
        if (options.containsKey("org.uf.context.roles")) {
            this.rolePrincipleName = (String)options.get("org.uf.context.roles");
        }
        try {
            if (options.containsKey("org.uberfire.roles.mode")) {
                this.mode = RolesMode.valueOf((String)((String)options.get("org.uberfire.roles.mode")));
            }
        }
        catch (Exception ignore) {
            this.mode = RolesMode.GROUP;
        }
    }

    public boolean supportsCredential(Credential credential) {
        return credential != null && credential instanceof UsernamePasswordCredential;
    }

    public boolean authenticate(Credential credential, SecurityContext securityContext) {
        UsernamePasswordCredential usernamePasswd = (UsernamePasswordCredential)Preconditions.checkInstanceOf((String)"credential", (Object)credential, UsernamePasswordCredential.class);
        try {
            LoginContext loginContext = new LoginContext(this.domain, new UsernamePasswordCallbackHandler(usernamePasswd));
            loginContext.login();
            this.subjects.set(loginContext.getSubject());
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public List<Role> loadRoles(Principal principal, SecurityContext securityContext) {
        ArrayList<Role> roles = new ArrayList<Role>();
        try {
            Subject subject = this.subjects.get();
            if (subject != null) {
                Set<java.security.Principal> principals = subject.getPrincipals();
                if (principals != null) {
                    for (java.security.Principal p : principals) {
                        if (!(p instanceof Group) || !this.rolePrincipleName.equalsIgnoreCase(p.getName())) continue;
                        Enumeration groups = ((Group)p).members();
                        while (groups.hasMoreElements()) {
                            java.security.Principal groupPrincipal = (java.security.Principal)groups.nextElement();
                            roles.add((Role)new RoleImpl(groupPrincipal.getName()));
                        }
                        break block2;
                    }
                }
                if (this.rolesAdapterServiceLoader != null && this.rolesAdapterServiceLoader.iterator().hasNext()) {
                    for (RolesAdapter rolesAdapter : this.rolesAdapterServiceLoader) {
                        rolesAdapter.getRoles(principal, securityContext, this.mode);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return roles;
    }

    class UsernamePasswordCallbackHandler
    implements CallbackHandler {
        private final UsernamePasswordCredential credential;

        public UsernamePasswordCallbackHandler(UsernamePasswordCredential credential) {
            this.credential = credential;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nameCB = (NameCallback)callback;
                    nameCB.setName(this.credential.getUserName());
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback passwordCB = (PasswordCallback)callback;
                    passwordCB.setPassword(this.credential.getPassword().toString().toCharArray());
                    continue;
                }
                try {
                    Method method = callback.getClass().getMethod("setObject", Object.class);
                    method.invoke((Object)callback, this.credential.getPassword().toString());
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
        }
    }
}

