/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server.authz.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import org.uberfire.security.Resource;
import org.uberfire.security.Subject;
import org.uberfire.security.annotations.RolesType;
import org.uberfire.security.annotations.SecurityTrait;
import org.uberfire.security.authz.AuthorizationException;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.security.authz.RuntimeResource;
import org.uberfire.security.server.cdi.AppResourcesAuthz;

public abstract class AbstractSecurityInterceptor {
    @Inject
    @AppResourcesAuthz
    private AuthorizationManager authzManager;
    @Inject
    @SessionScoped
    private Subject subject;

    @AroundInvoke
    public Object interceptInvoke(InvocationContext ctx) throws Exception {
        final Method method = ctx.getMethod();
        RuntimeResource resource = new RuntimeResource(){
            List<String> roles = null;
            List<String> traits = null;

            public String getSignatureId() {
                return method.toString();
            }

            public Collection<String> getRoles() {
                if (this.roles == null) {
                    this.build();
                }
                return this.roles;
            }

            public Collection<String> getTraits() {
                if (this.traits == null) {
                    this.build();
                }
                return this.traits;
            }

            private synchronized void build() {
                this.roles = new ArrayList<String>();
                this.traits = new ArrayList<String>();
                ArrayList<Annotation[]> availableAnnotations = new ArrayList<Annotation[]>(2);
                availableAnnotations.add(method.getAnnotations());
                availableAnnotations.add(method.getDeclaringClass().getAnnotations());
                Iterator i$ = availableAnnotations.iterator();
                while (i$.hasNext()) {
                    Annotation[] annotations;
                    block3: for (Annotation annotation : annotations = (Annotation[])i$.next()) {
                        if (annotation.annotationType().getAnnotation(RolesType.class) != null) {
                            for (Method annotationMethod : annotation.getClass().getDeclaredMethods()) {
                                String paramName = annotationMethod.getName().intern();
                                if (!paramName.equals("value")) continue;
                                try {
                                    if (annotationMethod.getReturnType().isArray()) {
                                        Object[] params;
                                        for (Object param : params = (Object[])annotationMethod.invoke((Object)annotation, new Object[0])) {
                                            this.roles.add(param.toString());
                                        }
                                        continue block3;
                                    }
                                    Object param = annotationMethod.invoke((Object)annotation, new Object[0]);
                                    this.roles.add(param.toString());
                                }
                                catch (Exception e) {}
                                continue block3;
                            }
                            continue;
                        }
                        if (annotation.annotationType().getAnnotation(SecurityTrait.class) == null) continue;
                        this.traits.add(annotation.annotationType().getName());
                    }
                }
            }
        };
        if (!this.authzManager.authorize((Resource)resource, this.subject)) {
            throw new AuthorizationException("Invalid credentials.");
        }
        return ctx.proceed();
    }
}

