/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl;

import java.lang.reflect.Field;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.jbpm.process.audit.command.AuditCommand;
import org.kie.api.command.Command;
import org.kie.internal.command.ProcessInstanceIdCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    private static final Logger logger = LoggerFactory.getLogger(CommonUtils.class);

    public static Long getProcessInstanceId(Command<?> command) {
        if (command instanceof ProcessInstanceIdCommand) {
            return ((ProcessInstanceIdCommand)command).getProcessInstanceId();
        }
        if (command instanceof AuditCommand) {
            return null;
        }
        try {
            Field[] fields;
            for (Field field : fields = command.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                if (field.isAnnotationPresent(XmlAttribute.class)) {
                    String attributeName = field.getAnnotation(XmlAttribute.class).name();
                    if ("process-instance-id".equalsIgnoreCase(attributeName)) {
                        return (Long)field.get(command);
                    }
                    if (!"processInstanceId".equals(field.getName())) continue;
                    return (Long)field.get(command);
                }
                if (field.isAnnotationPresent(XmlElement.class)) {
                    String elementName = field.getAnnotation(XmlElement.class).name();
                    if ("process-instance-id".equalsIgnoreCase(elementName)) {
                        return (Long)field.get(command);
                    }
                    if (!"processInstanceId".equals(field.getName())) continue;
                    return (Long)field.get(command);
                }
                if (!"processInstanceId".equals(field.getName())) continue;
                return (Long)field.get(command);
            }
        }
        catch (Exception e) {
            logger.debug("Unable to find process instance id on command {} due to {}", command, (Object)e.getMessage());
        }
        return null;
    }
}

