/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.store;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@NamedQueries(value={@NamedQuery(name="getDeploymentUnit", query="select d from DeploymentStoreEntry d where d.deploymentId=:deploymentId"), @NamedQuery(name="getDeploymentUnitsByDate", query="select d from DeploymentStoreEntry d where d.updateDate >= :ludate"), @NamedQuery(name="getDeploymentUnitsByState", query="select d from DeploymentStoreEntry d where d.state=:state")})
@Entity
@Table(name="DeploymentStore", uniqueConstraints={@UniqueConstraint(columnNames={"DEPLOYMENT_ID"})})
@SequenceGenerator(name="deploymentStoreIdSeq", sequenceName="DEPLOY_STORE_ID_SEQ", allocationSize=1)
public class DeploymentStoreEntry
implements Serializable {
    private static final long serialVersionUID = 6669858787722894023L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="deploymentStoreIdSeq")
    @Column(name="id")
    private Long id;
    @Column(name="DEPLOYMENT_ID")
    private String deploymentId;
    @Lob
    @Column(length=65535)
    private String deploymentUnit;
    private Integer state;
    private Date updateDate;
    private String attributes;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public String getDeploymentUnit() {
        return this.deploymentUnit;
    }

    public void setDeploymentUnit(String deploymentUnit) {
        this.deploymentUnit = deploymentUnit;
    }

    public Integer getState() {
        return this.state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public void setAttributes(String attributes) {
        this.attributes = attributes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.deploymentId == null ? 0 : this.deploymentId.hashCode());
        result = 31 * result + (this.deploymentUnit == null ? 0 : this.deploymentUnit.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.updateDate == null ? 0 : this.updateDate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeploymentStoreEntry other = (DeploymentStoreEntry)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.deploymentId == null ? other.deploymentId != null : !this.deploymentId.equals(other.deploymentId)) {
            return false;
        }
        if (this.deploymentUnit == null ? other.deploymentUnit != null : !this.deploymentUnit.equals(other.deploymentUnit)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.state == null ? other.state != null : !this.state.equals(other.state)) {
            return false;
        }
        return !(this.updateDate == null ? other.updateDate != null : !this.updateDate.equals(other.updateDate));
    }

    public String toString() {
        return "DeploymentStoreEntry [id=" + this.id + ", deploymentId=" + this.deploymentId + ", state=" + this.state + ", updateDate=" + this.updateDate + "]";
    }
}

