/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.backend.server.helpers;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.Arrays;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.plexus.util.IOUtil;
import org.guvnor.m2repo.backend.server.GuvnorM2Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpPutHelper {
    private static final Logger log = LoggerFactory.getLogger(HttpPutHelper.class);
    @Inject
    private GuvnorM2Repository m2RepoService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletInputStream inputStream = request.getInputStream();
        OutputStream outputStream = null;
        int status = 200;
        try {
            String pathInfo = URLDecoder.decode(request.getPathInfo(), "UTF-8");
            File mavenRootDir = new File(this.m2RepoService.getM2RepositoryRootDir());
            File file = new File(mavenRootDir, pathInfo);
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
                status = 201;
            }
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            IOUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
            response.setStatus(status);
        }
        catch (FileNotFoundException e) {
            log.error(e.toString(), (Throwable)e);
        }
        catch (IOException e) {
            log.error(e.toString(), (Throwable)e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException e) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static boolean matches(String matchHeader, String toMatch) {
        Object[] matchValues = matchHeader.split("\\s*,\\s*");
        Arrays.sort(matchValues);
        return Arrays.binarySearch(matchValues, toMatch) > -1 || Arrays.binarySearch(matchValues, "*") > -1;
    }
}

