/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.builder;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.datamodel.imports.Imports;
import org.drools.workbench.models.datamodel.oracle.TypeSource;
import org.guvnor.common.services.backend.file.DotFileFilter;
import org.guvnor.common.services.backend.file.JavaFileFilter;
import org.guvnor.common.services.project.builder.model.BuildMessage;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.model.IncrementalBuildResults;
import org.guvnor.common.services.project.builder.service.BuildValidationHelper;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.ProjectImports;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.runtime.KieContainer;
import org.kie.internal.builder.IncrementalResults;
import org.kie.internal.builder.InternalKieBuilder;
import org.kie.scanner.KieModuleMetaData;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.kie.workbench.common.services.shared.project.ProjectImportsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.workbench.events.ResourceChange;
import org.uberfire.workbench.events.ResourceChangeType;

public class Builder {
    private static final String RESOURCE_PATH = "src/main/resources";
    private static final Logger logger = LoggerFactory.getLogger(Builder.class);
    private static final String ERROR_EXTERNAL_CLASS_VERIFICATON = "Verification of class {0} failed and will not be available for authoring.\nPlease check the necessary external dependencies for this project are configured correctly.";
    private static final String ERROR_CLASS_NOT_FOUND = "Definition of class \"{0}\" was not found.\nPlease check the necessary external dependencies for this project are configured correctly.";
    private KieBuilder kieBuilder;
    private final KieServices kieServices;
    private final KieFileSystem kieFileSystem;
    private final Path moduleDirectory;
    private final GAV gav;
    private final IOService ioService;
    private final KieProjectService projectService;
    private final String projectPrefix;
    private Map<String, org.uberfire.backend.vfs.Path> handles = new HashMap<String, org.uberfire.backend.vfs.Path>();
    private ProjectImportsService importsService;
    private final List<BuildValidationHelper> buildValidationHelpers;
    private final Map<Path, BuildValidationHelper> nonKieResourceValidationHelpers = new HashMap<Path, BuildValidationHelper>();
    private final Map<Path, List<ValidationMessage>> nonKieResourceValidationHelperMessages = new HashMap<Path, List<ValidationMessage>>();
    private final DirectoryStream.Filter<Path> javaResourceFilter = new JavaFileFilter();
    private final DirectoryStream.Filter<Path> dotFileFilter = new DotFileFilter();
    private Set<String> javaResources = new HashSet<String>();
    private KieContainer kieContainer;

    public Builder(Path moduleDirectory, GAV gav, IOService ioService, KieProjectService projectService, ProjectImportsService importsService, List<BuildValidationHelper> buildValidationHelpers) {
        this.moduleDirectory = moduleDirectory;
        this.gav = gav;
        this.ioService = ioService;
        this.projectService = projectService;
        this.importsService = importsService;
        this.buildValidationHelpers = buildValidationHelpers;
        this.projectPrefix = moduleDirectory.toUri().toString();
        this.kieServices = KieServices.Factory.get();
        this.kieFileSystem = this.kieServices.newKieFileSystem();
        DirectoryStream directoryStream = Files.newDirectoryStream((Path)moduleDirectory);
        this.visitPaths((DirectoryStream<Path>)directoryStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildResults build() {
        KieFileSystem kieFileSystem = this.kieFileSystem;
        synchronized (kieFileSystem) {
            String msg;
            Class clazz;
            String fullyQualifiedClassName;
            String msg2;
            this.kieBuilder = this.kieServices.newKieBuilder(this.kieFileSystem);
            BuildResults results = new BuildResults(this.gav);
            try {
                Results kieResults = this.kieBuilder.buildAll().getResults();
                for (Message message : kieResults.getMessages()) {
                    results.addBuildMessage(this.convertMessage(message));
                }
                this.kieContainer = results.getErrorMessages().isEmpty() ? this.kieServices.newKieContainer(this.kieBuilder.getKieModule().getReleaseId()) : null;
            }
            catch (LinkageError e) {
                msg2 = MessageFormat.format(ERROR_CLASS_NOT_FOUND, e.getLocalizedMessage());
                logger.warn(msg2, (Throwable)e);
                results.addBuildMessage(this.makeWarningMessage(msg2));
            }
            catch (Throwable e) {
                msg2 = e.getLocalizedMessage();
                logger.error(msg2, e);
                results.addBuildMessage(this.makeErrorMessage(msg2));
            }
            for (Map.Entry<Path, BuildValidationHelper> e : this.nonKieResourceValidationHelpers.entrySet()) {
                org.uberfire.backend.vfs.Path vfsPath = Paths.convert((Path)e.getKey());
                List validationMessages = e.getValue().validate(vfsPath);
                this.nonKieResourceValidationHelperMessages.put(e.getKey(), validationMessages);
                if (validationMessages == null || validationMessages.isEmpty()) continue;
                for (ValidationMessage validationMessage : validationMessages) {
                    results.addBuildMessage(this.convertValidationMessage(validationMessage));
                }
            }
            Path nioExternalImportsPath = this.moduleDirectory.resolve("project.imports");
            if (Files.exists((Path)nioExternalImportsPath, (LinkOption[])new LinkOption[0])) {
                org.uberfire.backend.vfs.Path externalImportsPath = Paths.convert((Path)nioExternalImportsPath);
                ProjectImports projectImports = (ProjectImports)this.importsService.load(externalImportsPath);
                Imports imports = projectImports.getImports();
                for (Import item : imports.getImports()) {
                    fullyQualifiedClassName = item.getType();
                    try {
                        clazz = this.getClass().getClassLoader().loadClass(item.getType());
                    }
                    catch (ClassNotFoundException cnfe) {
                        logger.error(cnfe.getMessage(), (Throwable)cnfe);
                        msg = MessageFormat.format(ERROR_CLASS_NOT_FOUND, fullyQualifiedClassName);
                        results.addBuildMessage(this.makeWarningMessage(msg));
                    }
                }
            }
            KieModuleMetaData kieModuleMetaData = this.getKieModuleMetaData();
            for (String packageName : kieModuleMetaData.getPackages()) {
                for (String className : kieModuleMetaData.getClasses(packageName)) {
                    fullyQualifiedClassName = packageName + "." + className;
                    try {
                        clazz = kieModuleMetaData.getClass(packageName, className);
                        if (clazz != null) {
                            TypeSource typeSource = this.getClassSource(kieModuleMetaData, clazz);
                            if (TypeSource.JAVA_DEPENDENCY != typeSource) continue;
                            this.verifyExternalClass(clazz);
                            continue;
                        }
                        msg = MessageFormat.format(ERROR_EXTERNAL_CLASS_VERIFICATON, fullyQualifiedClassName);
                        logger.warn(msg);
                    }
                    catch (Throwable e) {
                        msg = MessageFormat.format(ERROR_EXTERNAL_CLASS_VERIFICATON, fullyQualifiedClassName);
                        logger.warn(msg, e);
                        results.addBuildMessage(this.makeWarningMessage(msg));
                    }
                }
            }
            return results;
        }
    }

    private KieModuleMetaData getKieModuleMetaData() {
        return KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)((InternalKieBuilder)this.kieBuilder).getKieModuleIgnoringErrors());
    }

    private void verifyExternalClass(Class clazz) {
        clazz.getDeclaredConstructors();
        clazz.getDeclaredFields();
        clazz.getDeclaredMethods();
        clazz.getDeclaredClasses();
        clazz.getDeclaredAnnotations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncrementalBuildResults addResource(Path resource) {
        KieFileSystem kieFileSystem = this.kieFileSystem;
        synchronized (kieFileSystem) {
            PortablePreconditions.checkNotNull((String)"resource", (Object)resource);
            if (!Files.isRegularFile((Path)resource, (LinkOption[])new LinkOption[0])) {
                return new IncrementalBuildResults(this.gav);
            }
            if (!this.isBuilt()) {
                throw new IllegalStateException("A full build needs to be performed before any incremental operations.");
            }
            IncrementalBuildResults results = new IncrementalBuildResults(this.gav);
            BuildValidationHelper validator = this.getBuildValidationHelper(resource);
            if (validator != null) {
                List<ValidationMessage> removedValidationMessages;
                List addedValidationMessages = validator.validate(Paths.convert((Path)resource));
                if (addedValidationMessages != null && !addedValidationMessages.isEmpty()) {
                    for (ValidationMessage validationMessage : addedValidationMessages) {
                        results.addAddedMessage(this.convertValidationMessage(validationMessage));
                    }
                }
                if ((removedValidationMessages = this.nonKieResourceValidationHelperMessages.remove(resource)) != null && !removedValidationMessages.isEmpty()) {
                    for (ValidationMessage validationMessage : removedValidationMessages) {
                        results.addRemovedMessage(this.convertValidationMessage(validationMessage));
                    }
                }
                this.nonKieResourceValidationHelpers.put(resource, validator);
                this.nonKieResourceValidationHelperMessages.put(resource, addedValidationMessages);
            }
            String destinationPath = resource.toUri().toString().substring(this.projectPrefix.length() + 1);
            InputStream is = this.ioService.newInputStream(resource, new OpenOption[0]);
            BufferedInputStream bis = new BufferedInputStream(is);
            this.kieFileSystem.write(destinationPath, KieServices.Factory.get().getResources().newInputStreamResource((InputStream)bis));
            this.addJavaClass(resource);
            this.handles.put(this.getBaseFileName(destinationPath), Paths.convert((Path)resource));
            try {
                IncrementalResults incrementalResults = ((InternalKieBuilder)this.kieBuilder).createFileSet(new String[]{destinationPath}).build();
                for (Message message : incrementalResults.getAddedMessages()) {
                    results.addAddedMessage(this.convertMessage(message));
                }
                for (Message message : incrementalResults.getRemovedMessages()) {
                    results.addRemovedMessage(this.convertMessage(message));
                }
                for (Message message : incrementalResults.getRemovedMessages()) {
                    this.handles.remove("src/main/resources/" + this.getBaseFileName(message.getPath()));
                }
            }
            catch (LinkageError e) {
                String msg = MessageFormat.format(ERROR_CLASS_NOT_FOUND, e.getLocalizedMessage());
                logger.warn(msg, (Throwable)e);
                results.addAddedMessage(this.makeWarningMessage(msg));
            }
            catch (Throwable e) {
                String msg = e.getLocalizedMessage();
                logger.error(msg, e);
                results.addAddedMessage(this.makeErrorMessage(msg));
            }
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncrementalBuildResults deleteResource(Path resource) {
        KieFileSystem kieFileSystem = this.kieFileSystem;
        synchronized (kieFileSystem) {
            String msg;
            PortablePreconditions.checkNotNull((String)"resource", (Object)resource);
            if (!this.isBuilt()) {
                throw new IllegalStateException("A full build needs to be performed before any incremental operations.");
            }
            IncrementalBuildResults results = new IncrementalBuildResults(this.gav);
            BuildValidationHelper validator = this.getBuildValidationHelper(resource);
            if (validator != null) {
                this.nonKieResourceValidationHelpers.remove(resource);
                List<ValidationMessage> removedValidationMessages = this.nonKieResourceValidationHelperMessages.remove(resource);
                if (removedValidationMessages != null && !removedValidationMessages.isEmpty()) {
                    for (ValidationMessage validationMessage : removedValidationMessages) {
                        results.addRemovedMessage(this.convertValidationMessage(validationMessage));
                    }
                }
            }
            String destinationPath = resource.toUri().toString().substring(this.projectPrefix.length() + 1);
            this.kieFileSystem.delete(new String[]{destinationPath});
            this.removeJavaClass(resource);
            try {
                IncrementalResults incrementalResults = ((InternalKieBuilder)this.kieBuilder).createFileSet(new String[]{destinationPath}).build();
                for (Message message : incrementalResults.getAddedMessages()) {
                    results.addAddedMessage(this.convertMessage(message));
                }
                for (Message message : incrementalResults.getRemovedMessages()) {
                    results.addRemovedMessage(this.convertMessage(message));
                }
                for (Message message : incrementalResults.getRemovedMessages()) {
                    this.handles.remove("src/main/resources/" + this.getBaseFileName(message.getPath()));
                }
            }
            catch (LinkageError e) {
                msg = MessageFormat.format(ERROR_CLASS_NOT_FOUND, e.getLocalizedMessage());
                logger.warn(msg, (Throwable)e);
                results.addAddedMessage(this.makeWarningMessage(msg));
            }
            catch (Throwable e) {
                msg = e.getLocalizedMessage();
                logger.error(msg, e);
                results.addAddedMessage(this.makeErrorMessage(msg));
            }
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncrementalBuildResults updateResource(Path resource) {
        KieFileSystem kieFileSystem = this.kieFileSystem;
        synchronized (kieFileSystem) {
            return this.addResource(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncrementalBuildResults applyBatchResourceChanges(Map<org.uberfire.backend.vfs.Path, Collection<ResourceChange>> changes) {
        KieFileSystem kieFileSystem = this.kieFileSystem;
        synchronized (kieFileSystem) {
            String msg;
            PortablePreconditions.checkNotNull((String)"changes", changes);
            if (!this.isBuilt()) {
                throw new IllegalStateException("A full build needs to be performed before any incremental operations.");
            }
            ArrayList<String> changedFilesKieBuilderPaths = new ArrayList<String>();
            ArrayList<ValidationMessage> nonKieResourceValidatorAddedMessages = new ArrayList<ValidationMessage>();
            ArrayList<ValidationMessage> nonKieResourceValidatorRemovedMessages = new ArrayList<ValidationMessage>();
            for (Map.Entry<org.uberfire.backend.vfs.Path, Collection<ResourceChange>> pathCollectionEntry : changes.entrySet()) {
                for (ResourceChange change : pathCollectionEntry.getValue()) {
                    ResourceChangeType type = change.getType();
                    Path resource = Paths.convert((org.uberfire.backend.vfs.Path)pathCollectionEntry.getKey());
                    PortablePreconditions.checkNotNull((String)"type", (Object)type);
                    PortablePreconditions.checkNotNull((String)"resource", (Object)resource);
                    String destinationPath = resource.toUri().toString().substring(this.projectPrefix.length() + 1);
                    changedFilesKieBuilderPaths.add(destinationPath);
                    switch (type) {
                        case ADD: 
                        case UPDATE: {
                            if (!Files.isRegularFile((Path)resource, (LinkOption[])new LinkOption[0])) break;
                            BuildValidationHelper validator = this.getBuildValidationHelper(resource);
                            if (validator != null) {
                                List<ValidationMessage> removedValidationMessages;
                                List addedValidationMessages = validator.validate(Paths.convert((Path)resource));
                                if (addedValidationMessages != null && !addedValidationMessages.isEmpty()) {
                                    for (ValidationMessage validationMessage : addedValidationMessages) {
                                        nonKieResourceValidatorAddedMessages.add(validationMessage);
                                    }
                                }
                                if ((removedValidationMessages = this.nonKieResourceValidationHelperMessages.remove(resource)) != null && !removedValidationMessages.isEmpty()) {
                                    for (ValidationMessage validationMessage : removedValidationMessages) {
                                        nonKieResourceValidatorRemovedMessages.add(validationMessage);
                                    }
                                }
                                this.nonKieResourceValidationHelpers.put(resource, validator);
                                this.nonKieResourceValidationHelperMessages.put(resource, addedValidationMessages);
                            }
                            InputStream is = this.ioService.newInputStream(resource, new OpenOption[0]);
                            BufferedInputStream bis = new BufferedInputStream(is);
                            this.kieFileSystem.write(destinationPath, KieServices.Factory.get().getResources().newInputStreamResource((InputStream)bis));
                            this.addJavaClass(resource);
                            this.handles.put(this.getBaseFileName(destinationPath), Paths.convert((Path)resource));
                            break;
                        }
                        case DELETE: {
                            this.nonKieResourceValidationHelpers.remove(resource);
                            List<ValidationMessage> removedValidationMessages = this.nonKieResourceValidationHelperMessages.remove(resource);
                            if (removedValidationMessages != null && !removedValidationMessages.isEmpty()) {
                                for (ValidationMessage validationMessage : removedValidationMessages) {
                                    nonKieResourceValidatorRemovedMessages.add(validationMessage);
                                }
                            }
                            this.kieFileSystem.delete(new String[]{destinationPath});
                            this.removeJavaClass(resource);
                        }
                    }
                }
            }
            String[] kieBuilderPaths = new String[changedFilesKieBuilderPaths.size()];
            changedFilesKieBuilderPaths.toArray(kieBuilderPaths);
            IncrementalBuildResults results = new IncrementalBuildResults(this.gav);
            try {
                IncrementalResults incrementalResults = ((InternalKieBuilder)this.kieBuilder).createFileSet(kieBuilderPaths).build();
                for (Message message : incrementalResults.getAddedMessages()) {
                    results.addAddedMessage(this.convertMessage(message));
                }
                for (Message message : incrementalResults.getRemovedMessages()) {
                    results.addRemovedMessage(this.convertMessage(message));
                }
                for (Message message : incrementalResults.getRemovedMessages()) {
                    this.handles.remove("src/main/resources/" + this.getBaseFileName(message.getPath()));
                }
            }
            catch (LinkageError e) {
                msg = MessageFormat.format(ERROR_CLASS_NOT_FOUND, e.getLocalizedMessage());
                logger.warn(msg, (Throwable)e);
                results.addAddedMessage(this.makeWarningMessage(msg));
            }
            catch (Throwable e) {
                msg = e.getLocalizedMessage();
                logger.error(msg, e);
                results.addAddedMessage(this.makeErrorMessage(msg));
            }
            for (ValidationMessage addedValidationMessage : nonKieResourceValidatorAddedMessages) {
                results.addAddedMessage(this.convertValidationMessage(addedValidationMessage));
            }
            for (ValidationMessage removedValidationMessage : nonKieResourceValidatorRemovedMessages) {
                results.addRemovedMessage(this.convertValidationMessage(removedValidationMessage));
            }
            return results;
        }
    }

    public KieModule getKieModule() {
        if (!this.isBuilt()) {
            this.build();
        }
        return this.kieBuilder.getKieModule();
    }

    public KieModule getKieModuleIgnoringErrors() {
        if (!this.isBuilt()) {
            this.build();
        }
        return ((InternalKieBuilder)this.kieBuilder).getKieModuleIgnoringErrors();
    }

    public KieContainer getKieContainer() {
        if (!this.isBuilt()) {
            this.build();
        }
        return this.kieContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBuilt() {
        KieFileSystem kieFileSystem = this.kieFileSystem;
        synchronized (kieFileSystem) {
            return this.kieBuilder != null;
        }
    }

    private void visitPaths(DirectoryStream<Path> directoryStream) {
        for (Path path : directoryStream) {
            if (Files.isDirectory((Path)path, (LinkOption[])new LinkOption[0])) {
                this.visitPaths((DirectoryStream<Path>)Files.newDirectoryStream((Path)path));
                continue;
            }
            if (this.dotFileFilter.accept((Object)path)) continue;
            BuildValidationHelper validator = this.getBuildValidationHelper(path);
            if (validator != null) {
                this.nonKieResourceValidationHelpers.put(path, validator);
            }
            String destinationPath = path.toUri().toString().substring(this.projectPrefix.length() + 1);
            InputStream is = this.ioService.newInputStream(path, new OpenOption[0]);
            BufferedInputStream bis = new BufferedInputStream(is);
            this.kieFileSystem.write(destinationPath, KieServices.Factory.get().getResources().newInputStreamResource((InputStream)bis));
            this.handles.put(this.getBaseFileName(destinationPath), Paths.convert((Path)path));
            this.addJavaClass(path);
        }
    }

    private BuildMessage convertMessage(Message message) {
        BuildMessage m = new BuildMessage();
        switch (message.getLevel()) {
            case ERROR: {
                m.setLevel(BuildMessage.Level.ERROR);
                break;
            }
            case WARNING: {
                m.setLevel(BuildMessage.Level.WARNING);
                break;
            }
            case INFO: {
                m.setLevel(BuildMessage.Level.INFO);
            }
        }
        m.setId(message.getId());
        m.setLine(message.getLine());
        if (message.getPath() != null && !message.getPath().isEmpty()) {
            m.setPath(this.handles.get("src/main/resources/" + this.getBaseFileName(message.getPath())));
        }
        m.setColumn(message.getColumn());
        m.setText(message.getText());
        return m;
    }

    private BuildMessage convertValidationMessage(ValidationMessage message) {
        BuildMessage m = new BuildMessage();
        switch (message.getLevel()) {
            case ERROR: {
                m.setLevel(BuildMessage.Level.ERROR);
                break;
            }
            case WARNING: {
                m.setLevel(BuildMessage.Level.WARNING);
                break;
            }
            case INFO: {
                m.setLevel(BuildMessage.Level.INFO);
            }
        }
        m.setId(message.getId());
        m.setLine(message.getLine());
        m.setColumn(message.getColumn());
        m.setText(message.getText());
        m.setPath(message.getPath());
        return m;
    }

    private BuildMessage makeErrorMessage(String prefix) {
        BuildMessage buildMessage = new BuildMessage();
        buildMessage.setLevel(BuildMessage.Level.ERROR);
        buildMessage.setText(prefix);
        return buildMessage;
    }

    private BuildMessage makeWarningMessage(String prefix) {
        BuildMessage buildMessage = new BuildMessage();
        buildMessage.setLevel(BuildMessage.Level.WARNING);
        buildMessage.setText(prefix);
        return buildMessage;
    }

    private void addJavaClass(Path path) {
        if (!this.javaResourceFilter.accept((Object)path)) {
            return;
        }
        String fullyQualifiedClassName = this.getFullyQualifiedClassName(path);
        if (fullyQualifiedClassName != null) {
            this.javaResources.add(fullyQualifiedClassName);
        }
    }

    private void removeJavaClass(Path path) {
        if (!this.javaResourceFilter.accept((Object)path)) {
            return;
        }
        String fullyQualifiedClassName = this.getFullyQualifiedClassName(path);
        if (fullyQualifiedClassName != null) {
            this.javaResources.remove(fullyQualifiedClassName);
        }
    }

    private String getFullyQualifiedClassName(Path path) {
        Package pkg = this.projectService.resolvePackage(Paths.convert((Path)path));
        String packageName = pkg.getPackageName();
        if (packageName == null) {
            return null;
        }
        String className = path.getFileName().toString().replace(".java", "");
        return packageName.equals("") ? className : packageName + "." + className;
    }

    public TypeSource getClassSource(KieModuleMetaData metaData, Class<?> clazz) {
        if (metaData.getTypeMetaInfo(clazz).isDeclaredType()) {
            return TypeSource.DECLARED;
        }
        String fullyQualifiedClassName = clazz.getName();
        int innerClassIdentifierIndex = fullyQualifiedClassName.indexOf("$");
        if (innerClassIdentifierIndex > 0) {
            fullyQualifiedClassName = fullyQualifiedClassName.substring(0, innerClassIdentifierIndex);
        }
        if (this.javaResources.contains(fullyQualifiedClassName)) {
            return TypeSource.JAVA_PROJECT;
        }
        return TypeSource.JAVA_DEPENDENCY;
    }

    private BuildValidationHelper getBuildValidationHelper(Path nioResource) {
        for (BuildValidationHelper validator : this.buildValidationHelpers) {
            org.uberfire.backend.vfs.Path resource;
            if (!validator.accepts(resource = Paths.convert((Path)nioResource))) continue;
            return validator;
        }
        return null;
    }

    private String getBaseFileName(String path) {
        return path.substring(0, path.lastIndexOf("."));
    }
}

