/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.cache.LRUCache;
import org.guvnor.common.services.project.builder.events.InvalidateDMOProjectCacheEvent;
import org.guvnor.common.services.project.builder.service.BuildValidationHelper;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.POMService;
import org.kie.workbench.common.services.backend.builder.Builder;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.kie.workbench.common.services.shared.project.ProjectImportsService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.io.IOService;

@ApplicationScoped
public class LRUBuilderCache
extends LRUCache<Project, Builder> {
    @Inject
    private POMService pomService;
    @Inject
    private KieProjectService projectService;
    @Inject
    private ProjectImportsService importsService;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    @Any
    private Instance<BuildValidationHelper> anyValidators;
    private final List<BuildValidationHelper> validators = new ArrayList<BuildValidationHelper>();

    @PostConstruct
    public void setupValidators() {
        Iterator itr = this.anyValidators.iterator();
        while (itr.hasNext()) {
            this.validators.add((BuildValidationHelper)itr.next());
        }
    }

    public synchronized void invalidateProjectCache(@Observes InvalidateDMOProjectCacheEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        Project project = event.getProject();
        if (project != null) {
            this.invalidateCache(project);
        }
    }

    public synchronized Builder assertBuilder(Project project) {
        Builder builder = (Builder)this.getEntry(project);
        if (builder == null) {
            Path pathToPom = project.getPomXMLPath();
            POM pom = (POM)this.pomService.load(pathToPom);
            builder = new Builder(Paths.convert((Path)project.getRootPath()), pom.getGav(), this.ioService, this.projectService, this.importsService, this.validators);
            this.setEntry(project, builder);
        }
        return builder;
    }
}

