/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.project;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.drools.workbench.models.datamodel.imports.Import;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.project.backend.server.AbstractProjectService;
import org.guvnor.common.services.project.backend.server.ProjectConfigurationContentHandler;
import org.guvnor.common.services.project.backend.server.utils.IdentifierUtils;
import org.guvnor.common.services.project.builder.events.InvalidateDMOProjectCacheEvent;
import org.guvnor.common.services.project.events.DeleteProjectEvent;
import org.guvnor.common.services.project.events.NewPackageEvent;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.events.RenameProjectEvent;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.model.ProjectImports;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.ConfigurationService;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.shared.kmodule.KModuleService;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Identity;

@Service
@ApplicationScoped
public class ProjectServiceImpl
extends AbstractProjectService<KieProject>
implements KieProjectService {
    private static final String PROJECT_IMPORTS_PATH = "project.imports";
    private static final String KMODULE_PATH = "src/main/resources/META-INF/kmodule.xml";
    @Inject
    private KModuleService kModuleService;

    public ProjectServiceImpl() {
    }

    @Inject
    public ProjectServiceImpl(@Named(value="ioStrategy") IOService ioService, POMService pomService, ProjectConfigurationContentHandler projectConfigurationContentHandler, ConfigurationService configurationService, ConfigurationFactory configurationFactory, Event<NewProjectEvent> newProjectEvent, Event<NewPackageEvent> newPackageEvent, Event<RenameProjectEvent> renameProjectEvent, Event<DeleteProjectEvent> deleteProjectEvent, Event<InvalidateDMOProjectCacheEvent> invalidateDMOCache, Identity identity, SessionInfo sessionInfo) {
        super(ioService, pomService, projectConfigurationContentHandler, configurationService, configurationFactory, newProjectEvent, newPackageEvent, renameProjectEvent, deleteProjectEvent, invalidateDMOCache, identity, sessionInfo);
    }

    public KieProject newProject(Repository repository, String projectName, POM pom, String baseUrl) {
        FileSystem fs = Paths.convert((org.uberfire.backend.vfs.Path)repository.getRoot()).getFileSystem();
        try {
            org.uberfire.backend.vfs.Path projectConfigPath;
            org.uberfire.backend.vfs.Path fsRoot = repository.getRoot();
            org.uberfire.backend.vfs.Path projectRootPath = Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)fsRoot).resolve(projectName));
            this.ioService.startBatch(new FileSystem[]{fs}, new Option[]{this.makeCommentedOption("New project [" + projectName + "]")});
            this.kModuleService.setUpKModuleStructure(projectRootPath);
            org.uberfire.backend.vfs.Path parentPom = Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)fsRoot).resolve("pom.xml"));
            boolean parentExists = this.ioService.exists(Paths.convert((org.uberfire.backend.vfs.Path)parentPom));
            POM parent = null;
            if (parentExists && (parent = (POM)this.pomService.load(parentPom)) != null) {
                pom.setParent(parent);
            }
            this.pomService.create(projectRootPath, baseUrl, pom);
            if (parentExists && parent != null) {
                parent.setMultiModule(true);
                parent.getModules().add(pom.getGav().getArtifactId());
                this.pomService.save(parentPom, (Object)parent, null, "Adding child module " + pom.getName());
            }
            if (this.ioService.exists(Paths.convert((org.uberfire.backend.vfs.Path)(projectConfigPath = Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)projectRootPath).resolve(PROJECT_IMPORTS_PATH)))))) {
                throw new FileAlreadyExistsException(projectConfigPath.toString());
            }
            this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)projectConfigPath), this.projectConfigurationContentHandler.toString(this.createProjectImports()), new OpenOption[0]);
            KieProject project = this.resolveProject(projectRootPath);
            this.newProjectEvent.fire((Object)new NewProjectEvent((Project)project, this.sessionInfo));
            Object[] legalJavaGroupId = IdentifierUtils.convertMavenIdentifierToJavaIdentifier((String[])pom.getGav().getGroupId().split("\\.", -1));
            Object[] legalJavaArtifactId = IdentifierUtils.convertMavenIdentifierToJavaIdentifier((String[])pom.getGav().getArtifactId().split("\\.", -1));
            String defaultWorkspacePath = StringUtils.join((Object[])legalJavaGroupId, (String)"/") + "/" + StringUtils.join((Object[])legalJavaArtifactId, (String)"/");
            org.uberfire.backend.vfs.Path defaultPackagePath = Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)projectRootPath).resolve("src/main/resources"));
            Package defaultPackage = this.resolvePackage(defaultPackagePath);
            Package defaultWorkspacePackage = this.doNewPackage(defaultPackage, defaultWorkspacePath, false);
            this.newPackageEvent.fire((Object)new NewPackageEvent(defaultWorkspacePackage));
            KieProject kieProject = project;
            return kieProject;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        finally {
            this.ioService.endBatch();
        }
    }

    public KieProject simpleProjectInstance(Path nioProjectRootPath) {
        org.uberfire.backend.vfs.Path projectRootPath = Paths.convert((Path)nioProjectRootPath);
        return new KieProject(projectRootPath, Paths.convert((Path)nioProjectRootPath.resolve("pom.xml")), Paths.convert((Path)nioProjectRootPath.resolve(KMODULE_PATH)), Paths.convert((Path)nioProjectRootPath.resolve(PROJECT_IMPORTS_PATH)), projectRootPath.getFileName());
    }

    public Project resolveToParentProject(org.uberfire.backend.vfs.Path resource) {
        try {
            if (resource == null) {
                return null;
            }
            Path path = Paths.convert((org.uberfire.backend.vfs.Path)resource).normalize();
            Path parentPomPath = path.resolve("pom.xml");
            if (this.hasPom(path)) {
                POM parent = (POM)this.pomService.load(Paths.convert((Path)parentPomPath));
                org.uberfire.backend.vfs.Path projectRootPath = Paths.convert((Path)path);
                Project project = new Project(projectRootPath, Paths.convert((Path)parentPomPath), projectRootPath.getFileName());
                project.getModules().addAll(parent.getModules());
                return project;
            }
            return null;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public Project resolveParentProject(org.uberfire.backend.vfs.Path resource) {
        try {
            if (resource == null) {
                return null;
            }
            Path path = Paths.convert((org.uberfire.backend.vfs.Path)resource).normalize();
            if (this.hasPom(path)) {
                org.uberfire.backend.vfs.Path projectRootPath = Paths.convert((Path)path);
                return new Project(projectRootPath, Paths.convert((Path)path.resolve("pom.xml")), projectRootPath.getFileName());
            }
            return null;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public KieProject resolveProject(org.uberfire.backend.vfs.Path resource) {
        try {
            if (resource == null) {
                return null;
            }
            Path path = Paths.convert((org.uberfire.backend.vfs.Path)resource).normalize();
            if (Files.isRegularFile((Path)path, (LinkOption[])new LinkOption[0])) {
                path = path.getParent();
            }
            if (this.hasPom(path) && this.hasKModule(path)) {
                return this.makeProject(path);
            }
            while (path.getNameCount() > 0 && !path.getFileName().toString().equals("src")) {
                path = path.getParent();
            }
            if (path.getNameCount() == 0) {
                return null;
            }
            if ((path = path.getParent()).getNameCount() == 0 || path == null) {
                return null;
            }
            if (!this.hasPom(path)) {
                return null;
            }
            if (!this.hasKModule(path)) {
                return null;
            }
            return this.makeProject(path);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    protected KieProject makeProject(Path nioProjectRootPath) {
        KieProject project = this.simpleProjectInstance(nioProjectRootPath);
        this.addSecurityRoles((Project)project);
        return project;
    }

    public Package resolvePackage(org.uberfire.backend.vfs.Path resource) {
        try {
            if (resource == null) {
                return null;
            }
            KieProject project = this.resolveProject(resource);
            if (project == null) {
                return null;
            }
            if (this.isPom(resource) || this.kModuleService.isKModule(resource)) {
                return null;
            }
            return this.makePackage((Project)project, resource);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private boolean hasKModule(Path path) {
        Path kmodulePath = path.resolve(KMODULE_PATH);
        return Files.exists((Path)kmodulePath, (LinkOption[])new LinkOption[0]);
    }

    private ProjectImports createProjectImports() {
        ProjectImports imports = new ProjectImports();
        imports.getImports().addImport(new Import("java.lang.Number"));
        return imports;
    }
}

