/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.validation;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Package;
import org.kie.workbench.common.services.backend.validation.FileNameValidator;
import org.kie.workbench.common.services.backend.validation.ValidationUtils;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
public class JavaFileNameValidator
implements FileNameValidator {
    @Inject
    KieProjectService projectService;

    public int getPriority() {
        return 1;
    }

    public boolean accept(String fileName) {
        return fileName != null && fileName.endsWith(".java");
    }

    public boolean accept(Path path) {
        Package currentPackage = this.projectService.resolvePackage(path);
        return currentPackage != null && !"".equals(currentPackage.getPackageName());
    }

    public boolean isValid(String value) {
        return value.endsWith(".java") && ValidationUtils.isJavaIdentifier(value.substring(0, value.indexOf(".java"))) && ValidationUtils.isFileName(value);
    }
}

