/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.drools.core.base.evaluators.TimeIntervalParser;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.backend.validation.FileNameValidator;
import org.kie.workbench.common.services.backend.validation.JavaFileNameValidator;
import org.kie.workbench.common.services.backend.validation.PackageNameValidator;
import org.kie.workbench.common.services.backend.validation.ProjectNameValidator;
import org.kie.workbench.common.services.backend.validation.ValidationUtils;
import org.kie.workbench.common.services.shared.validation.ValidationService;
import org.uberfire.backend.vfs.Path;

@Service
@ApplicationScoped
public class ValidationServiceImpl
implements ValidationService {
    @Any
    @Inject
    private Instance<FileNameValidator> fileNameValidatorBeans;
    private List<FileNameValidator> fileNameValidators = new ArrayList<FileNameValidator>();
    @Inject
    private PackageNameValidator packageNameValidator;
    @Inject
    private ProjectNameValidator projectNameValidator;
    @Inject
    private JavaFileNameValidator javaFileNameValidator;

    @PostConstruct
    public void configureValidators() {
        for (FileNameValidator fileNameValidator : this.fileNameValidatorBeans) {
            this.fileNameValidators.add(fileNameValidator);
        }
        Collections.sort(this.fileNameValidators, new Comparator<FileNameValidator>(){

            @Override
            public int compare(FileNameValidator o1, FileNameValidator o2) {
                return o2.getPriority() - o1.getPriority();
            }
        });
    }

    public boolean isProjectNameValid(String projectName) {
        return this.projectNameValidator.isValid(projectName);
    }

    public boolean isPackageNameValid(String packageName) {
        return this.packageNameValidator.isValid(packageName);
    }

    public boolean isFileNameValid(String fileName) {
        for (FileNameValidator fileNameValidator : this.fileNameValidators) {
            if (!fileNameValidator.accept(fileName)) continue;
            return fileNameValidator.isValid(fileName);
        }
        return false;
    }

    public boolean isFileNameValid(Path path, String fileName) {
        for (FileNameValidator fileNameValidator : this.fileNameValidators) {
            if (!fileNameValidator.accept(path)) continue;
            return fileNameValidator.isValid(fileName);
        }
        return false;
    }

    public boolean isJavaFileNameValid(String fileName) {
        return this.javaFileNameValidator.isValid(fileName);
    }

    public Map<String, Boolean> evaluateIdentifiers(String[] identifiers) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(identifiers.length);
        if (identifiers != null && identifiers.length > 0) {
            for (String s : identifiers) {
                result.put(s, ValidationUtils.isJavaIdentifier(s));
            }
        }
        return result;
    }

    public Map<String, Boolean> evaluateArtifactIdentifiers(String[] identifiers) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(identifiers.length);
        if (identifiers != null && identifiers.length > 0) {
            for (String s : identifiers) {
                result.put(s, ValidationUtils.isArtifactIdentifier(s));
            }
        }
        return result;
    }

    public boolean isTimerIntervalValid(String timerInterval) {
        try {
            new TimeIntervalParser().parse(timerInterval);
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }
}

