/*
 * Decompiled with CFR 0.152.
 */
package org.kie.uberfire.social.activities.persistence;

import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.kie.uberfire.social.activities.model.SocialActivitiesEvent;
import org.kie.uberfire.social.activities.model.SocialEventType;
import org.kie.uberfire.social.activities.model.SocialUser;
import org.kie.uberfire.social.activities.persistence.SocialTimelineCachePersistence;
import org.kie.uberfire.social.activities.server.SocialUserServicesExtendedBackEndImpl;
import org.kie.uberfire.social.activities.service.SocialEventTypeRepositoryAPI;
import org.kie.uberfire.social.activities.service.SocialUserPersistenceAPI;
import org.uberfire.io.IOService;

public class SocialTimelineCacheInstancePersistence
extends SocialTimelineCachePersistence {
    public SocialTimelineCacheInstancePersistence(Gson gson, Type gsonCollectionType, IOService ioService, SocialEventTypeRepositoryAPI socialEventTypeRepository, SocialUserPersistenceAPI socialUserService, SocialUserServicesExtendedBackEndImpl userServicesBackend) {
        this.gson = gson;
        this.gsonCollectionType = gsonCollectionType;
        this.ioService = ioService;
        this.socialEventTypeRepository = socialEventTypeRepository;
        this.socialUserPersistenceAPI = socialUserService;
        this.userServicesBackend = userServicesBackend;
    }

    public void persist(SocialActivitiesEvent event) {
        SocialEventType type = this.findType(event);
        ArrayList<SocialActivitiesEvent> typeEvents = (ArrayList<SocialActivitiesEvent>)this.typeEventsFreshEvents.get(type);
        if (typeEvents == null) {
            typeEvents = new ArrayList<SocialActivitiesEvent>();
        }
        typeEvents.add(event);
        this.typeEventsFreshEvents.put(type, typeEvents);
        this.cacheControl(event);
    }

    SocialEventType findType(SocialActivitiesEvent event) {
        return this.socialEventTypeRepository.findType(event.getType());
    }

    public void persist(SocialUser user, SocialActivitiesEvent event) {
        ArrayList<SocialActivitiesEvent> userEvents = (ArrayList<SocialActivitiesEvent>)this.userEventsTimelineFreshEvents.get(user.getUserName());
        if (userEvents == null) {
            userEvents = new ArrayList<SocialActivitiesEvent>();
        }
        userEvents.add(event);
        this.userEventsTimelineFreshEvents.put(user.getUserName(), userEvents);
        this.cacheControl(user);
    }

    public void saveAllEvents() {
        this.saveAllTypeEvents();
        this.saveAllUserTimelines();
    }

    void cacheControl(SocialUser user) {
        SocialTimelineCachePersistence.SocialCacheControl socialCacheControl = (SocialTimelineCachePersistence.SocialCacheControl)this.userEventsCacheControl.get(user.getUserName());
        if (socialCacheControl == null) {
            socialCacheControl = new SocialTimelineCachePersistence.SocialCacheControl(this);
            this.userEventsCacheControl.put(user.getUserName(), socialCacheControl);
        }
        socialCacheControl.registerNewEvent();
        if (socialCacheControl.needToPersist()) {
            this.storeTimeLineInFile(user);
            socialCacheControl.reset();
        }
    }

    void cacheControl(SocialActivitiesEvent event) {
        SocialEventType type = this.findType(event);
        SocialTimelineCachePersistence.SocialCacheControl socialCacheControl = (SocialTimelineCachePersistence.SocialCacheControl)this.typeEventsCacheControl.get(type);
        socialCacheControl.registerNewEvent();
        if (socialCacheControl.needToPersist()) {
            this.storeTimeLineInFile(type);
            socialCacheControl.reset();
        }
    }
}

