/*
 * Decompiled with CFR 0.152.
 */
package org.kie.uberfire.social.activities.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.uberfire.social.activities.model.PagedSocialQuery;
import org.kie.uberfire.social.activities.model.SocialActivitiesEvent;
import org.kie.uberfire.social.activities.model.SocialEventType;
import org.kie.uberfire.social.activities.model.SocialPaged;
import org.kie.uberfire.social.activities.repository.SocialPageRepository;
import org.kie.uberfire.social.activities.service.SocialAdapter;
import org.kie.uberfire.social.activities.service.SocialRouterAPI;
import org.kie.uberfire.social.activities.service.SocialTypeTimelinePagedRepositoryAPI;

@Service
@ApplicationScoped
public class SocialTypeTimelinePagedRepository
extends SocialPageRepository
implements SocialTypeTimelinePagedRepositoryAPI {
    @Inject
    SocialRouterAPI socialRouterAPI;

    public PagedSocialQuery getEventTimeline(String adapterName, SocialPaged socialPage) {
        return this.getEventTimeline(adapterName, socialPage, new HashMap());
    }

    public PagedSocialQuery getEventTimeline(String adapterName, SocialPaged socialPaged, Map commandsMap) {
        SocialAdapter socialAdapter = this.getSocialAdapter(adapterName);
        return this.getEventTimeline(socialAdapter, socialPaged, commandsMap);
    }

    SocialAdapter getSocialAdapter(String adapterName) {
        return this.socialRouterAPI.getSocialAdapter(adapterName);
    }

    public PagedSocialQuery getEventTimeline(SocialAdapter adapter, SocialPaged socialPaged) {
        return this.getEventTimeline(adapter, socialPaged, new HashMap());
    }

    public PagedSocialQuery getEventTimeline(SocialAdapter adapter, SocialPaged socialPaged, Map commandsMap) {
        socialPaged = this.setupQueryDirection(socialPaged);
        List<SocialActivitiesEvent> typeEvents = new ArrayList<SocialActivitiesEvent>();
        if (socialPaged.isANewQuery()) {
            socialPaged = this.searchForRecentEvents(adapter.socialEventType(), socialPaged, typeEvents);
        }
        if (!this.foundEnoughtEvents(socialPaged, typeEvents)) {
            socialPaged = this.searchForStoredEvents(adapter.socialEventType(), socialPaged, typeEvents);
        }
        typeEvents = this.filterTimelineWithAdapters(commandsMap, typeEvents);
        this.checkIfICanGoForward(socialPaged, typeEvents);
        PagedSocialQuery query = new PagedSocialQuery(typeEvents, socialPaged);
        return query;
    }

    private SocialPaged searchForStoredEvents(SocialEventType type, SocialPaged socialPaged, List<SocialActivitiesEvent> events) {
        if (socialPaged.firstFileRead()) {
            this.readMostRecentFile(type, socialPaged, events);
        } else {
            this.readCurrentFile(type, socialPaged, events);
        }
        if (!this.foundEnoughtEvents(socialPaged, events) && this.shouldIReadMoreFiles(socialPaged)) {
            this.readMoreFiles(socialPaged, type, events);
        }
        return socialPaged;
    }

    private boolean shouldIReadMoreFiles(SocialPaged socialPaged) {
        return socialPaged.lastFileReaded() != null && !socialPaged.lastFileReaded().isEmpty() && this.thereIsMoreFilesToRead(socialPaged.lastFileReaded());
    }

    private void readMoreFiles(SocialPaged socialPaged, SocialEventType type, List<SocialActivitiesEvent> events) {
        String nextFileToRead = socialPaged.getNextFileToRead();
        if (this.thereIsMoreFilesToRead(nextFileToRead)) {
            this.addEventsToTimeline(type, socialPaged, events, nextFileToRead);
            if (!this.foundEnoughtEvents(socialPaged, events)) {
                this.readMoreFiles(socialPaged, type, events);
            }
        }
        this.checkIfICanGoForward(socialPaged, events);
    }

    private void readCurrentFile(SocialEventType type, SocialPaged socialPaged, List<SocialActivitiesEvent> events) {
        String lastFileReaded = socialPaged.lastFileReaded();
        this.addEventsToTimeline(type, socialPaged, events, lastFileReaded);
    }

    private void addEventsToTimeline(SocialEventType type, SocialPaged socialPaged, List<SocialActivitiesEvent> events, String lastFileReaded) {
        List timeline = this.getSocialTimelinePersistenceAPI().getTimeline(type, lastFileReaded);
        this.setNumberOfEventsOnFile(socialPaged, type, lastFileReaded);
        this.addEvents(socialPaged, events, timeline);
    }

    private void setNumberOfEventsOnFile(SocialPaged socialPaged, SocialEventType type, String lastFileReaded) {
        socialPaged.setNumberOfEventsOnFile(this.getSocialTimelinePersistenceAPI().getNumberOfEventsOnFile(type, lastFileReaded));
    }

    private void readMostRecentFile(SocialEventType type, SocialPaged socialPaged, List<SocialActivitiesEvent> events) {
        Integer userMostRecentFileIndex = this.getSocialTimelinePersistenceAPI().getTypeMostRecentFileIndex(type);
        List timeline = this.getSocialTimelinePersistenceAPI().getTimeline(type, userMostRecentFileIndex.toString());
        socialPaged.setLastFileReaded(userMostRecentFileIndex.toString());
        this.readEvents(socialPaged, events, timeline);
    }

    private SocialPaged searchForRecentEvents(SocialEventType type, SocialPaged socialPaged, List<SocialActivitiesEvent> events) {
        List freshEvents = this.getSocialTimelinePersistenceAPI().getRecentEvents(type);
        Collections.reverse(freshEvents);
        this.searchEvents(socialPaged, events, freshEvents);
        return socialPaged;
    }
}

