/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.annotations.processors;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.enterprise.context.ApplicationScoped;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.annotations.processors.AbstractGenerator;
import org.uberfire.annotations.processors.GeneratorUtils;
import org.uberfire.annotations.processors.exceptions.GenerationException;
import org.uberfire.annotations.processors.facades.ClientAPIModule;

public class EditorActivityGenerator
extends AbstractGenerator {
    private static final Logger logger = LoggerFactory.getLogger(EditorActivityGenerator.class);

    @Override
    public StringBuffer generate(String packageName, PackageElement packageElement, String className, Element element, ProcessingEnvironment processingEnvironment) throws GenerationException {
        String msg;
        logger.debug("Starting code generation for [" + className + "]");
        TypeElement classElement = (TypeElement)element;
        String annotationName = ClientAPIModule.getWorkbenchEditorClass().getName();
        Object action = null;
        String identifier = null;
        Integer priority = 0;
        List<String> associatedResources = null;
        Integer preferredHeight = null;
        Integer preferredWidth = null;
        for (AnnotationMirror annotationMirror : classElement.getAnnotationMirrors()) {
            if (!annotationName.equals(annotationMirror.getAnnotationType().toString())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                int _preferredWidth;
                if ("identifier".equals(entry.getKey().getSimpleName().toString())) {
                    identifier = entry.getValue().toString();
                    continue;
                }
                if ("priority".equals(entry.getKey().getSimpleName().toString())) {
                    priority = (Integer)entry.getValue().getValue();
                    continue;
                }
                if ("supportedTypes".equals(entry.getKey().getSimpleName().toString())) {
                    associatedResources = GeneratorUtils.extractValue(entry.getValue());
                    continue;
                }
                if ("preferredHeight".equals(entry.getKey().getSimpleName().toString())) {
                    int _preferredHeight = (Integer)entry.getValue().getValue();
                    if (_preferredHeight <= 0) continue;
                    preferredHeight = _preferredHeight;
                    continue;
                }
                if (!"preferredWidth".equals(entry.getKey().getSimpleName().toString()) || (_preferredWidth = ((Integer)entry.getValue().getValue()).intValue()) <= 0) continue;
                preferredWidth = _preferredWidth;
            }
        }
        if (associatedResources != null && associatedResources.size() > 0) {
            for (String string : associatedResources) {
                TypeElement type = processingEnvironment.getElementUtils().getTypeElement(string);
                if (type.getAnnotation(ApplicationScoped.class) != null) continue;
                throw new GenerationException("The '" + string + "' must be ApplicationScope`d .");
            }
        }
        String onStartup1ParameterMethodName = GeneratorUtils.getOnStartupPathParameterMethodName(classElement, processingEnvironment);
        String string = GeneratorUtils.getOnStartupPathPlaceRequestParametersMethodName(classElement, processingEnvironment);
        String onMayCloseMethodName = GeneratorUtils.getOnMayCloseMethodName(classElement, processingEnvironment);
        String onCloseMethodName = GeneratorUtils.getOnCloseMethodName(classElement, processingEnvironment);
        String onShutdownMethodName = GeneratorUtils.getOnShutdownMethodName(classElement, processingEnvironment);
        String onOpenMethodName = GeneratorUtils.getOnOpenMethodName(classElement, processingEnvironment);
        String onLostFocusMethodName = GeneratorUtils.getOnLostFocusMethodName(classElement, processingEnvironment);
        String onFocusMethodName = GeneratorUtils.getOnFocusMethodName(classElement, processingEnvironment);
        String getDefaultPositionMethodName = GeneratorUtils.getDefaultPositionMethodName(classElement, processingEnvironment);
        String getTitleMethodName = GeneratorUtils.getTitleMethodName(classElement, processingEnvironment);
        String getContextIdMethodName = GeneratorUtils.getContextIdMethodName(classElement, processingEnvironment);
        ExecutableElement getTitleWidgetMethod = GeneratorUtils.getTitleWidgetMethodName(classElement, processingEnvironment);
        String getTitleWidgetMethodName = getTitleWidgetMethod == null ? null : getTitleWidgetMethod.getSimpleName().toString();
        ExecutableElement getWidgetMethod = GeneratorUtils.getWidgetMethodName(classElement, processingEnvironment);
        String getWidgetMethodName = getWidgetMethod == null ? null : getWidgetMethod.getSimpleName().toString();
        boolean hasUberView = GeneratorUtils.hasUberViewReference(classElement, processingEnvironment, getWidgetMethod);
        boolean isWidget = GeneratorUtils.getIsWidget(classElement, processingEnvironment);
        String isDirtyMethodName = GeneratorUtils.getIsDirtyMethodName(classElement, processingEnvironment);
        String onSaveMethodName = GeneratorUtils.getOnSaveMethodName(classElement, processingEnvironment);
        String getMenuBarMethodName = GeneratorUtils.getMenuBarMethodName(classElement, processingEnvironment);
        String getToolBarMethodName = GeneratorUtils.getToolBarMethodName(classElement, processingEnvironment);
        String securityTraitList = GeneratorUtils.getSecurityTraitList(classElement);
        String rolesList = GeneratorUtils.getRoleList(classElement);
        logger.debug("Package name: " + packageName);
        logger.debug("Class name: " + className);
        logger.debug("Identifier: " + identifier);
        logger.debug("getContextIdMethodName: " + getContextIdMethodName);
        logger.debug("Priority: " + priority);
        logger.debug("Resource types: " + associatedResources);
        logger.debug("Preferred Height: " + preferredHeight);
        logger.debug("Preferred Width: " + preferredWidth);
        logger.debug("onStartup1ParameterMethodName: " + onStartup1ParameterMethodName);
        logger.debug("onStartup2ParametersMethodName: " + string);
        logger.debug("onMayCloseMethodName: " + onMayCloseMethodName);
        logger.debug("onCloseMethodName: " + onCloseMethodName);
        logger.debug("onShutdownMethodName: " + onShutdownMethodName);
        logger.debug("onOpenMethodName: " + onOpenMethodName);
        logger.debug("onLostFocusMethodName: " + onLostFocusMethodName);
        logger.debug("onFocusMethodName: " + onFocusMethodName);
        logger.debug("getDefaultPositionMethodName: " + getDefaultPositionMethodName);
        logger.debug("getTitleMethodName: " + getTitleMethodName);
        logger.debug("getTitleWidgetMethodName: " + getTitleWidgetMethodName);
        logger.debug("getWidgetMethodName: " + getWidgetMethodName);
        logger.debug("isWidget: " + Boolean.toString(isWidget));
        logger.debug("hasUberView: " + Boolean.toString(hasUberView));
        logger.debug("isDirtyMethodName: " + isDirtyMethodName);
        logger.debug("onSaveMethodName: " + onSaveMethodName);
        logger.debug("getMenuBarMethodName: " + getMenuBarMethodName);
        logger.debug("getToolBarMethodName: " + getToolBarMethodName);
        logger.debug("securityTraitList: " + securityTraitList);
        logger.debug("rolesList: " + rolesList);
        if (!isWidget && getWidgetMethodName == null) {
            throw new GenerationException("The WorkbenchEditor must either extend IsWidget or provide a @WorkbenchPartView annotated method to return a com.google.gwt.user.client.ui.IsWidget.", packageName + "." + className);
        }
        if (isWidget && getWidgetMethodName != null) {
            msg = "The WorkbenchEditor both extends com.google.gwt.user.client.ui.IsWidget and provides a @WorkbenchPartView annotated method. The annotated method will take precedence.";
            processingEnvironment.getMessager().printMessage(Diagnostic.Kind.WARNING, "The WorkbenchEditor both extends com.google.gwt.user.client.ui.IsWidget and provides a @WorkbenchPartView annotated method. The annotated method will take precedence.");
            logger.warn("The WorkbenchEditor both extends com.google.gwt.user.client.ui.IsWidget and provides a @WorkbenchPartView annotated method. The annotated method will take precedence.");
        }
        if (onStartup1ParameterMethodName != null && string != null) {
            msg = "The WorkbenchEditor has methods for both @OnStartup(Path) and @OnStartup(Path, Place). Method @OnStartup(Path, Place) will take precedence.";
            processingEnvironment.getMessager().printMessage(Diagnostic.Kind.WARNING, "The WorkbenchEditor has methods for both @OnStartup(Path) and @OnStartup(Path, Place). Method @OnStartup(Path, Place) will take precedence.");
            logger.warn("The WorkbenchEditor has methods for both @OnStartup(Path) and @OnStartup(Path, Place). Method @OnStartup(Path, Place) will take precedence.");
        }
        if (getTitleMethodName == null) {
            throw new GenerationException("The WorkbenchEditor must provide a @WorkbenchPartTitle annotated method to return a java.lang.String.", packageName + "." + className);
        }
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("packageName", packageName);
        root.put("className", className);
        root.put("identifier", identifier);
        root.put("getContextIdMethodName", getContextIdMethodName);
        root.put("priority", priority.toString().replace(",", ""));
        root.put("associatedResources", GeneratorUtils.formatAssociatedResources(associatedResources));
        root.put("preferredHeight", preferredHeight);
        root.put("preferredWidth", preferredWidth);
        root.put("realClassName", classElement.getSimpleName().toString());
        root.put("onStartup1ParameterMethodName", onStartup1ParameterMethodName);
        root.put("onStartup2ParametersMethodName", string);
        root.put("onMayCloseMethodName", onMayCloseMethodName);
        root.put("onCloseMethodName", onCloseMethodName);
        root.put("onShutdownMethodName", onShutdownMethodName);
        root.put("onOpenMethodName", onOpenMethodName);
        root.put("onLostFocusMethodName", onLostFocusMethodName);
        root.put("onFocusMethodName", onFocusMethodName);
        root.put("getDefaultPositionMethodName", getDefaultPositionMethodName);
        root.put("getTitleMethodName", getTitleMethodName);
        root.put("getTitleWidgetMethodName", getTitleWidgetMethodName);
        root.put("getWidgetMethodName", getWidgetMethodName);
        root.put("isWidget", isWidget);
        root.put("hasUberView", hasUberView);
        root.put("isDirtyMethodName", isDirtyMethodName);
        root.put("onSaveMethodName", onSaveMethodName);
        root.put("getMenuBarMethodName", getMenuBarMethodName);
        root.put("getToolBarMethodName", getToolBarMethodName);
        root.put("securityTraitList", securityTraitList);
        root.put("rolesList", rolesList);
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        try {
            Template template = config.getTemplate("activityEditor.ftl");
            template.process(root, (Writer)bw);
        }
        catch (IOException ioe) {
            throw new GenerationException(ioe);
        }
        catch (TemplateException te) {
            throw new GenerationException(te);
        }
        finally {
            try {
                bw.close();
                sw.close();
            }
            catch (IOException ioe) {
                throw new GenerationException(ioe);
            }
        }
        logger.debug("Successfully generated code for [" + className + "]");
        return sw.getBuffer();
    }
}

