/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.annotations.processors;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.annotations.processors.AbstractGenerator;
import org.uberfire.annotations.processors.GeneratorUtils;
import org.uberfire.annotations.processors.exceptions.GenerationException;
import org.uberfire.annotations.processors.facades.ClientAPIModule;

public class PopupActivityGenerator
extends AbstractGenerator {
    private static final Logger logger = LoggerFactory.getLogger(PopupActivityGenerator.class);

    @Override
    public StringBuffer generate(String packageName, PackageElement packageElement, String className, Element element, ProcessingEnvironment processingEnvironment) throws GenerationException {
        String msg;
        logger.debug("Starting code generation for [" + className + "]");
        TypeElement classElement = (TypeElement)element;
        String identifier = ClientAPIModule.getWbPopupScreenIdentifierValueOnClass(classElement);
        String onStartup0ParameterMethodName = GeneratorUtils.getOnStartupZeroParameterMethodName(classElement, processingEnvironment);
        String onStartup1ParameterMethodName = GeneratorUtils.getOnStartPlaceRequestParameterMethodName(classElement, processingEnvironment);
        String onMayCloseMethodName = GeneratorUtils.getOnMayCloseMethodName(classElement, processingEnvironment);
        String onCloseMethodName = GeneratorUtils.getOnCloseMethodName(classElement, processingEnvironment);
        String onShutdownMethodName = GeneratorUtils.getOnShutdownMethodName(classElement, processingEnvironment);
        String onOpenMethodName = GeneratorUtils.getOnOpenMethodName(classElement, processingEnvironment);
        String getTitleMethodName = GeneratorUtils.getTitleMethodName(classElement, processingEnvironment);
        ExecutableElement getTitleWidgetMethod = GeneratorUtils.getTitleWidgetMethodName(classElement, processingEnvironment);
        String getTitleWidgetMethodName = getTitleWidgetMethod == null ? null : getTitleWidgetMethod.getSimpleName().toString();
        ExecutableElement getWidgetMethod = GeneratorUtils.getWidgetMethodName(classElement, processingEnvironment);
        String getWidgetMethodName = getWidgetMethod == null ? null : getWidgetMethod.getSimpleName().toString();
        boolean hasUberView = GeneratorUtils.hasUberViewReference(classElement, processingEnvironment, getWidgetMethod);
        boolean isWidget = GeneratorUtils.getIsWidget(classElement, processingEnvironment);
        String securityTraitList = GeneratorUtils.getSecurityTraitList(classElement);
        String rolesList = GeneratorUtils.getRoleList(classElement);
        logger.debug("Package name: " + packageName);
        logger.debug("Class name: " + className);
        logger.debug("Identifier: " + identifier);
        logger.debug("onStartup0ParameterMethodName: " + onStartup0ParameterMethodName);
        logger.debug("onStartup1ParameterMethodName: " + onStartup1ParameterMethodName);
        logger.debug("onMayCloseMethodName: " + onMayCloseMethodName);
        logger.debug("onCloseMethodName: " + onCloseMethodName);
        logger.debug("onShutdownMethodName: " + onShutdownMethodName);
        logger.debug("onOpenMethodName: " + onOpenMethodName);
        logger.debug("getTitleMethodName: " + getTitleMethodName);
        logger.debug("getTitleWidgetMethodName: " + getTitleWidgetMethodName);
        logger.debug("getWidgetMethodName: " + getWidgetMethodName);
        logger.debug("isWidget: " + Boolean.toString(isWidget));
        logger.debug("hasUberView: " + Boolean.toString(hasUberView));
        logger.debug("securityTraitList: " + securityTraitList);
        logger.debug("rolesList: " + rolesList);
        if (!isWidget && getWidgetMethodName == null) {
            throw new GenerationException("The WorkbenchPopup must either extend IsWidget or provide a @WorkbenchPartView annotated method to return a com.google.gwt.user.client.ui.IsWidget.", packageName + "." + className);
        }
        if (isWidget && getWidgetMethodName != null) {
            msg = "The WorkbenchPopup both extends com.google.gwt.user.client.ui.IsWidget and provides a @WorkbenchPartView annotated method. The annotated method will take precedence.";
            processingEnvironment.getMessager().printMessage(Diagnostic.Kind.WARNING, "The WorkbenchPopup both extends com.google.gwt.user.client.ui.IsWidget and provides a @WorkbenchPartView annotated method. The annotated method will take precedence.");
            logger.warn("The WorkbenchPopup both extends com.google.gwt.user.client.ui.IsWidget and provides a @WorkbenchPartView annotated method. The annotated method will take precedence.");
        }
        if (onStartup0ParameterMethodName != null && onStartup1ParameterMethodName != null) {
            msg = "Found multiple @OnStartup methods. Each class can declare at most one.";
            throw new GenerationException("Found multiple @OnStartup methods. Each class can declare at most one.");
        }
        if (getTitleMethodName == null) {
            throw new GenerationException("The WorkbenchPopup must provide a @WorkbenchPartTitle annotated method to return a java.lang.String.", packageName + "." + className);
        }
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("packageName", packageName);
        root.put("className", className);
        root.put("identifier", identifier);
        root.put("realClassName", classElement.getSimpleName().toString());
        root.put("onStartup0ParameterMethodName", onStartup0ParameterMethodName);
        root.put("onStartup1ParameterMethodName", onStartup1ParameterMethodName);
        root.put("onMayCloseMethodName", onMayCloseMethodName);
        root.put("onCloseMethodName", onCloseMethodName);
        root.put("onShutdownMethodName", onShutdownMethodName);
        root.put("onOpenMethodName", onOpenMethodName);
        root.put("getTitleMethodName", getTitleMethodName);
        root.put("getTitleWidgetMethodName", getTitleWidgetMethodName);
        root.put("getWidgetMethodName", getWidgetMethodName);
        root.put("isWidget", isWidget);
        root.put("hasUberView", hasUberView);
        root.put("securityTraitList", securityTraitList);
        root.put("rolesList", rolesList);
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        try {
            Template template = config.getTemplate("popupScreen.ftl");
            template.process(root, (Writer)bw);
        }
        catch (IOException ioe) {
            throw new GenerationException(ioe);
        }
        catch (TemplateException te) {
            throw new GenerationException(te);
        }
        finally {
            try {
                bw.close();
                sw.close();
            }
            catch (IOException ioe) {
                throw new GenerationException(ioe);
            }
        }
        logger.debug("Successfully generated code for [" + className + "]");
        return sw.getBuffer();
    }
}

