/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.annotations.processors;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.uberfire.annotations.processors.PartInformation;
import org.uberfire.annotations.processors.TemplateInformation;
import org.uberfire.annotations.processors.WorkbenchPanelInformation;
import org.uberfire.annotations.processors.exceptions.GenerationException;
import org.uberfire.annotations.processors.facades.ClientAPIModule;

public class TemplateInformationHelper {
    public static final String VALUE = "value";
    public static final String PANEL_TYPE = "panelType";
    public static final String IS_DEFAULT = "isDefault";
    public static final String DEFAULT_PANEL_TYPE = "TEMPLATE";
    public static final String PART = "part";
    public static final String PARAMETERS = "parameters";

    public static TemplateInformation extractWbTemplatePerspectiveInformation(TypeElement classElement) throws GenerationException {
        TemplateInformation template = new TemplateInformation();
        for (Element element : classElement.getEnclosedElements()) {
            if (TemplateInformationHelper.isAWorkbenchPanel(element)) {
                TemplateInformationHelper.extractInformationFromWorkbenchPanel(template, element);
                continue;
            }
            if (!TemplateInformationHelper.onlyWorkbenchPartWithoutPanel(element)) continue;
            TemplateInformationHelper.extractInformationFromGeneratedWorkbenchPanel(template, element);
        }
        if (template.thereIsTemplateFields()) {
            return template;
        }
        throw new GenerationException("The Template WorkbenchPerspective must provide a @WorkbenchPanel or @WorkbenchPart annotated field.");
    }

    private static boolean onlyWorkbenchPartWithoutPanel(Element element) {
        boolean ufPart = element.getAnnotation(ClientAPIModule.getWorkbenchPart()) != null;
        boolean ufParts = element.getAnnotation(ClientAPIModule.getWorkbenchParts()) != null;
        return !TemplateInformationHelper.isAWorkbenchPanel(element) && (ufPart || ufParts);
    }

    private static boolean isAWorkbenchPanel(Element element) {
        return element.getAnnotation(ClientAPIModule.getWorkbenchPanel()) != null;
    }

    private static void extractInformationFromWorkbenchPanel(TemplateInformation template, Element element) throws GenerationException {
        WorkbenchPanelInformation wbPanel = new WorkbenchPanelInformation();
        if (TemplateInformationHelper.workbenchPanelIsDefault(element)) {
            wbPanel.setDefault(true);
        }
        wbPanel.setFieldName(element.getSimpleName().toString());
        wbPanel.setWbParts(TemplateInformationHelper.getWorkbenchPartsFrom(element));
        wbPanel.setPanelType(TemplateInformationHelper.extractPanelType(element));
        if (wbPanel.isDefault()) {
            if (TemplateInformationHelper.shouldHaveOnlyOneDefaultPanel(template)) {
                throw new GenerationException("The Template WorkbenchPerspective must provide only one @WorkbenchPanel annotated field.");
            }
            template.setDefaultPanel(wbPanel);
        } else {
            template.addTemplateField(wbPanel);
        }
    }

    private static void extractInformationFromGeneratedWorkbenchPanel(TemplateInformation template, Element element) throws GenerationException {
        WorkbenchPanelInformation generatedWbPanel = new WorkbenchPanelInformation();
        generatedWbPanel.setFieldName(element.getSimpleName().toString());
        generatedWbPanel.setWbParts(TemplateInformationHelper.getWorkbenchPartsFrom(element));
        generatedWbPanel.setPanelType(DEFAULT_PANEL_TYPE);
        template.addTemplateField(generatedWbPanel);
    }

    private static boolean shouldHaveOnlyOneDefaultPanel(TemplateInformation template) {
        return template.getDefaultPanel() != null;
    }

    private static String extractPanelType(Element element) throws GenerationException {
        Annotation annotation = element.getAnnotation(ClientAPIModule.getWorkbenchPanel());
        return TemplateInformationHelper.extractAnnotationPropertyValue(annotation, PANEL_TYPE);
    }

    private static boolean workbenchPanelIsDefault(Element element) throws GenerationException {
        Annotation annotation = element.getAnnotation(ClientAPIModule.getWorkbenchPanel());
        return Boolean.valueOf(TemplateInformationHelper.extractAnnotationPropertyValue(annotation, IS_DEFAULT));
    }

    private static List<PartInformation> getWorkbenchPartsFrom(Element wbPanel) throws GenerationException {
        ArrayList<PartInformation> parts = new ArrayList<PartInformation>();
        if (TemplateInformationHelper.thereIsWbParts(wbPanel)) {
            TemplateInformationHelper.extractWbPartFromWbParts(wbPanel, parts);
        } else {
            String partName = TemplateInformationHelper.extractMethodValueFromAnnotation(wbPanel, ClientAPIModule.getWorkbenchPart(), PART);
            Map<String, String> parameters = TemplateInformationHelper.extractParametersFromPart(wbPanel);
            parts.add(new PartInformation(partName, parameters));
        }
        return parts;
    }

    private static boolean thereIsWbParts(Element element) {
        return element.getAnnotation(ClientAPIModule.getWorkbenchParts()) != null;
    }

    private static String extractAnnotationPropertyValue(Annotation annotation, String annotationProperty) throws GenerationException {
        String value;
        try {
            Class<? extends Annotation> aClass = annotation.annotationType();
            Method identifier = aClass.getDeclaredMethod(annotationProperty, new Class[0]);
            value = String.valueOf(identifier.invoke((Object)annotation, new Object[0]));
        }
        catch (Exception e) {
            throw new GenerationException(e.getMessage(), e.getCause());
        }
        return value;
    }

    private static void extractWbPartFromWbParts(Element ufPanel, List<PartInformation> parts) throws GenerationException {
        Annotation[] annotations;
        for (Annotation annotation : annotations = TemplateInformationHelper.extractAnnotationsFromAnnotation(ufPanel, ClientAPIModule.getWorkbenchParts(), VALUE)) {
            String partName = TemplateInformationHelper.extractAnnotationPropertyValue(annotation, PART);
            parts.add(new PartInformation(partName));
        }
    }

    private static String extractMethodValueFromAnnotation(Element element, Class<? extends Annotation> annotation, String methodName) throws GenerationException {
        String identifierValue = "";
        if (element.getAnnotation(annotation) != null) {
            identifierValue = TemplateInformationHelper.getElementAnnotationStringValue(annotation, methodName, element);
        }
        return identifierValue;
    }

    private static Map<String, String> extractParametersFromPart(Element element) throws GenerationException {
        TreeMap<String, String> map = new TreeMap<String, String>();
        Class<? extends Annotation> wpPart = ClientAPIModule.getWorkbenchPart();
        Class<? extends Annotation> parameterMapping = ClientAPIModule.getParameterMapping();
        try {
            Object[] parameters;
            Method parametersMethod = wpPart.getDeclaredMethod(PARAMETERS, new Class[0]);
            for (Object parameter : parameters = (Object[])parametersMethod.invoke((Object)element.getAnnotation(wpPart), new Object[0])) {
                Method name = parameterMapping.getDeclaredMethod("name", new Class[0]);
                Method val = parameterMapping.getDeclaredMethod("val", new Class[0]);
                map.put(String.valueOf(name.invoke(parameter, new Object[0])), String.valueOf(val.invoke(parameter, new Object[0])));
            }
        }
        catch (Exception e) {
            throw new GenerationException(e.getMessage(), e.getCause());
        }
        return map;
    }

    private static String getElementAnnotationStringValue(Class<? extends Annotation> annotation, String methodName, Element element) throws GenerationException {
        String identifierValue;
        try {
            Method identifier = annotation.getDeclaredMethod(methodName, new Class[0]);
            identifierValue = String.valueOf(identifier.invoke((Object)element.getAnnotation(annotation), new Object[0]));
        }
        catch (Exception e) {
            throw new GenerationException(e.getMessage(), e.getCause());
        }
        return identifierValue;
    }

    private static String extractAnnotationStringValue(Annotation annotation) throws GenerationException {
        return TemplateInformationHelper.extractAnnotationPropertyValue(annotation, VALUE);
    }

    private static Annotation[] extractAnnotationsFromAnnotation(Element element, Class<? extends Annotation> annotation, String methodName) throws GenerationException {
        Annotation[] annotations = new Annotation[]{};
        if (element.getAnnotation(annotation) != null) {
            try {
                Method identifier = annotation.getDeclaredMethod(methodName, new Class[0]);
                annotations = (Annotation[])identifier.invoke((Object)element.getAnnotation(annotation), new Object[0]);
            }
            catch (Exception e) {
                throw new GenerationException(e.getMessage(), e.getCause());
            }
        }
        return annotations;
    }
}

