/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.annotations.processors.facades;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.annotations.processors.exceptions.GenerationException;

public class ClientAPIModule {
    private static final Logger logger = LoggerFactory.getLogger(ClientAPIModule.class);
    public static final String IDENTIFIER = "identifier";
    public static final String IS_DEFAULT = "isDefault";
    public static final String IS_TEMPLATE = "isTemplate";
    public static final String VALUE = "value";
    private static Class<? extends Annotation> workbenchSplashScreen;
    private static Class<? extends Annotation> workbenchPerspective;
    private static Class<? extends Annotation> workbenchPopup;
    private static Class<? extends Annotation> workbenchScreen;
    private static Class<? extends Annotation> workbenchContext;
    private static Class<? extends Annotation> workbenchEditor;
    private static Class<? extends Annotation> defaultPosition;
    private static Class<? extends Annotation> workbenchPartTitle;
    private static Class<? extends Annotation> workbenchContextId;
    private static Class<? extends Annotation> workbenchPartTitleDecoration;
    private static Class<? extends Annotation> workbenchPartView;
    private static Class<? extends Annotation> workbenchMenu;
    private static Class<? extends Annotation> workbenchToolBar;
    private static Class<? extends Annotation> perspective;
    private static Class<? extends Annotation> splashFilter;
    private static Class<? extends Annotation> splashBodyHeight;
    private static Class<? extends Annotation> intercept;
    private static Class<? extends Annotation> workbenchPart;
    private static Class<? extends Annotation> workbenchParts;
    private static Class<? extends Annotation> workbenchPanel;
    private static Class<? extends Annotation> parameterMapping;

    private ClientAPIModule() {
    }

    public static Class<? extends Annotation> getWorkbenchScreenClass() {
        return workbenchScreen;
    }

    public static Class<? extends Annotation> getSplashFilterClass() {
        return splashFilter;
    }

    public static Class<? extends Annotation> getSplashBodyHeightClass() {
        return splashBodyHeight;
    }

    public static Class<? extends Annotation> getInterceptClass() {
        return intercept;
    }

    public static Class<? extends Annotation> getPerspectiveClass() {
        return perspective;
    }

    public static Class<? extends Annotation> getWorkbenchToolBarClass() {
        return workbenchToolBar;
    }

    public static Class<? extends Annotation> getWorkbenchMenuClass() {
        return workbenchMenu;
    }

    public static Class<? extends Annotation> getWorkbenchPartViewClass() {
        return workbenchPartView;
    }

    public static Class<? extends Annotation> getWorkbenchPartTitleDecorationsClass() {
        return workbenchPartTitleDecoration;
    }

    public static Class<? extends Annotation> getWorkbenchContextIdClass() {
        return workbenchContextId;
    }

    public static Class<? extends Annotation> getWorkbenchPartTitleClass() {
        return workbenchPartTitle;
    }

    public static Class<? extends Annotation> getDefaultPositionClass() {
        return defaultPosition;
    }

    public static Class<? extends Annotation> getWorkbenchContextClass() {
        return workbenchContext;
    }

    public static Class<? extends Annotation> getWorkbenchEditorClass() {
        return workbenchEditor;
    }

    public static Class<? extends Annotation> getWorkbenchPopupClass() {
        return workbenchPopup;
    }

    public static Class<? extends Annotation> getWorkbenchSplashScreenClass() {
        return workbenchSplashScreen;
    }

    public static Class<? extends Annotation> getWorkbenchPerspectiveClass() {
        return workbenchPerspective;
    }

    public static Class<? extends Annotation> getWorkbenchPart() {
        return workbenchPart;
    }

    public static Class<? extends Annotation> getWorkbenchParts() {
        return workbenchParts;
    }

    public static Class<? extends Annotation> getParameterMapping() {
        return parameterMapping;
    }

    public static Class<? extends Annotation> getWorkbenchPanel() {
        return workbenchPanel;
    }

    private static String getAnnotationIdentifierValueOnClass(TypeElement o, String className, String annotationName) throws GenerationException {
        try {
            String identifierValue = "";
            for (AnnotationMirror annotationMirror : o.getAnnotationMirrors()) {
                if (!className.equals(annotationMirror.getAnnotationType().toString())) continue;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                    if (!annotationName.equals(entry.getKey().getSimpleName().toString())) continue;
                    AnnotationValue value = entry.getValue();
                    identifierValue = value.getValue().toString();
                }
            }
            return identifierValue;
        }
        catch (Exception e) {
            throw new GenerationException(e.getMessage(), e.getCause());
        }
    }

    public static Boolean getWbPerspectiveScreenIsDefaultValueOnClass(TypeElement classElement) throws GenerationException {
        String bool = ClientAPIModule.getAnnotationIdentifierValueOnClass(classElement, workbenchPerspective.getName(), IS_DEFAULT);
        return Boolean.valueOf(bool);
    }

    public static String getWbPerspectiveScreenIdentifierValueOnClass(TypeElement classElement) throws GenerationException {
        return ClientAPIModule.getAnnotationIdentifierValueOnClass(classElement, workbenchPerspective.getName(), IDENTIFIER);
    }

    public static String getWbPopupScreenIdentifierValueOnClass(TypeElement classElement) throws GenerationException {
        return ClientAPIModule.getAnnotationIdentifierValueOnClass(classElement, workbenchPopup.getName(), IDENTIFIER);
    }

    public static String getWbSplashScreenIdentifierValueOnClass(TypeElement classElement) throws GenerationException {
        return ClientAPIModule.getAnnotationIdentifierValueOnClass(classElement, workbenchSplashScreen.getName(), IDENTIFIER);
    }

    public static String getWbScreenIdentifierValueOnClass(TypeElement classElement) throws GenerationException {
        return ClientAPIModule.getAnnotationIdentifierValueOnClass(classElement, workbenchScreen.getName(), IDENTIFIER);
    }

    public static String getWbContextIdentifierValueOnClass(TypeElement classElement) throws GenerationException {
        return ClientAPIModule.getAnnotationIdentifierValueOnClass(classElement, workbenchContext.getName(), IDENTIFIER);
    }

    public static boolean getWbPerspectiveScreenIsATemplate(TypeElement classElement) throws GenerationException {
        List<? extends Element> enclosedElements = classElement.getEnclosedElements();
        for (Element element : enclosedElements) {
            if (!ClientAPIModule.isATemplate(element)) continue;
            return true;
        }
        return false;
    }

    public static boolean isATemplate(Element element) {
        Annotation parts = element.getAnnotation(workbenchParts);
        Annotation part = element.getAnnotation(workbenchPart);
        Annotation panel = element.getAnnotation(workbenchPanel);
        return parts != null || part != null || panel != null;
    }

    static {
        try {
            workbenchSplashScreen = Class.forName("org.uberfire.client.annotations.WorkbenchSplashScreen");
            workbenchPerspective = Class.forName("org.uberfire.client.annotations.WorkbenchPerspective");
            workbenchPopup = Class.forName("org.uberfire.client.annotations.WorkbenchPopup");
            workbenchScreen = Class.forName("org.uberfire.client.annotations.WorkbenchScreen");
            workbenchContext = Class.forName("org.uberfire.client.annotations.WorkbenchContext");
            workbenchEditor = Class.forName("org.uberfire.client.annotations.WorkbenchEditor");
            defaultPosition = Class.forName("org.uberfire.client.annotations.DefaultPosition");
            workbenchPartTitle = Class.forName("org.uberfire.client.annotations.WorkbenchPartTitle");
            workbenchContextId = Class.forName("org.uberfire.client.annotations.WorkbenchContextId");
            workbenchPartTitleDecoration = Class.forName("org.uberfire.client.annotations.WorkbenchPartTitleDecoration");
            workbenchPartView = Class.forName("org.uberfire.client.annotations.WorkbenchPartView");
            workbenchMenu = Class.forName("org.uberfire.client.annotations.WorkbenchMenu");
            workbenchToolBar = Class.forName("org.uberfire.client.annotations.WorkbenchToolBar");
            perspective = Class.forName("org.uberfire.client.annotations.Perspective");
            splashFilter = Class.forName("org.uberfire.client.annotations.SplashFilter");
            splashBodyHeight = Class.forName("org.uberfire.client.annotations.SplashBodyHeight");
            intercept = Class.forName("org.uberfire.client.annotations.Intercept");
            workbenchPart = Class.forName("org.uberfire.client.annotations.WorkbenchPart");
            workbenchParts = Class.forName("org.uberfire.client.annotations.WorkbenchParts");
            workbenchPanel = Class.forName("org.uberfire.client.annotations.WorkbenchPanel");
            parameterMapping = Class.forName("org.uberfire.client.annotations.ParameterMapping");
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage());
        }
    }
}

