/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.reader.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import org.jboss.weld.interceptor.reader.ClassMetadataInterceptorReference;
import org.jboss.weld.interceptor.reader.InterceptorMetadataUtils;
import org.jboss.weld.interceptor.reader.ReflectiveClassMetadata;
import org.jboss.weld.interceptor.reader.cache.MetadataCachingReader;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorReference;
import org.jboss.weld.util.cache.LoadingCacheUtils;

public class DefaultMetadataCachingReader
implements MetadataCachingReader {
    private final LoadingCache<InterceptorReference<?>, InterceptorMetadata<?>> interceptorMetadataCache = CacheBuilder.newBuilder().build(new CacheLoader<InterceptorReference<?>, InterceptorMetadata<?>>(){

        public InterceptorMetadata<?> load(InterceptorReference<?> from) {
            return InterceptorMetadataUtils.readMetadataForInterceptorClass(from);
        }
    });
    private final LoadingCache<ClassMetadata<?>, InterceptorMetadata<?>> classMetadataInterceptorMetadataCache = CacheBuilder.newBuilder().build(new CacheLoader<ClassMetadata<?>, InterceptorMetadata<?>>(){

        public InterceptorMetadata<?> load(ClassMetadata<?> from) {
            return InterceptorMetadataUtils.readMetadataForTargetClass(from);
        }
    });
    private final LoadingCache<Class<?>, ClassMetadata<?>> reflectiveClassMetadataCache = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, ClassMetadata<?>>(){

        public ClassMetadata<?> load(Class<?> from) {
            return ReflectiveClassMetadata.of(from);
        }
    });
    private boolean unwrapRuntimeExceptions = true;

    public void setUnwrapRuntimeExceptions(boolean unwrapRuntimeExceptions) {
        this.unwrapRuntimeExceptions = unwrapRuntimeExceptions;
    }

    @Override
    public <T> InterceptorMetadata<T> getInterceptorMetadata(InterceptorReference<T> interceptorReference) {
        try {
            return (InterceptorMetadata)LoadingCacheUtils.getCastCacheValue(this.interceptorMetadataCache, interceptorReference);
        }
        catch (UncheckedExecutionException e) {
            if (this.unwrapRuntimeExceptions && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public <T> InterceptorMetadata<T> getTargetClassInterceptorMetadata(ClassMetadata<T> classMetadata) {
        try {
            return (InterceptorMetadata)LoadingCacheUtils.getCastCacheValue(this.classMetadataInterceptorMetadataCache, classMetadata);
        }
        catch (UncheckedExecutionException e) {
            if (this.unwrapRuntimeExceptions && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public <T> InterceptorMetadata<T> getInterceptorMetadata(Class<T> clazz) {
        try {
            return (InterceptorMetadata)LoadingCacheUtils.getCastCacheValue(this.interceptorMetadataCache, ClassMetadataInterceptorReference.of(LoadingCacheUtils.getCacheValue(this.reflectiveClassMetadataCache, clazz)));
        }
        catch (UncheckedExecutionException e) {
            if (this.unwrapRuntimeExceptions && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public <T> ClassMetadata<T> getClassMetadata(Class<T> clazz) {
        try {
            return (ClassMetadata)LoadingCacheUtils.getCastCacheValue(this.reflectiveClassMetadataCache, clazz);
        }
        catch (UncheckedExecutionException e) {
            if (this.unwrapRuntimeExceptions && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
    }
}

