/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=21.0
//  number=$Revision: 6546 Google $
//  type=root
//  date=$Date: 2012-02-07 13:32:35 -0500 (Tue, 07 Feb 2012) $


/**
 * Localized names for the "de" locale.
 */
public class LocalizedNamesImpl_de extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "DE",
        "AT",
        "CH",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "EG",
        "AX",
        "AL",
        "DZ",
        "VI",
        "UM",
        "AS",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "GQ",
        "AR",
        "AM",
        "AW",
        "AC",
        "AZ",
        "ET",
        "QO",
        "AU",
        "BS",
        "BH",
        "BD",
        "BB",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BO",
        "BA",
        "BW",
        "BV",
        "BQ",
        "BR",
        "VG",
        "IO",
        "BN",
        "BG",
        "BF",
        "BI",
        "EA",
        "CL",
        "CN",
        "CP",
        "CK",
        "CR",
        "CI",
        "CW",
        "DK",
        "KP",
        "DE",
        "DG",
        "DM",
        "DO",
        "DJ",
        "EC",
        "SV",
        "ER",
        "EE",
        "EU",
        "FK",
        "FO",
        "FJ",
        "FI",
        "FR",
        "TF",
        "GF",
        "PF",
        "GA",
        "GM",
        "GE",
        "GH",
        "GI",
        "GD",
        "GR",
        "GL",
        "GP",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GY",
        "HT",
        "HM",
        "HN",
        "HK",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IM",
        "IL",
        "IT",
        "JM",
        "JP",
        "YE",
        "JE",
        "JO",
        "KY",
        "KH",
        "CM",
        "CA",
        "IC",
        "CV",
        "KZ",
        "QA",
        "KE",
        "KG",
        "KI",
        "CC",
        "CO",
        "KM",
        "CG",
        "CD",
        "HR",
        "CU",
        "KW",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MO",
        "MG",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "MA",
        "MH",
        "MQ",
        "MR",
        "MU",
        "YT",
        "MK",
        "FX",
        "MX",
        "FM",
        "MC",
        "MN",
        "ME",
        "MS",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NC",
        "NZ",
        "NI",
        "NL",
        "AN",
        "NE",
        "NG",
        "NU",
        "MP",
        "NF",
        "NO",
        "OM",
        "AT",
        "TL",
        "PK",
        "PS",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PH",
        "PN",
        "PL",
        "PT",
        "PR",
        "KR",
        "MD",
        "RE",
        "RW",
        "RO",
        "RU",
        "SB",
        "ZM",
        "WS",
        "SM",
        "ST",
        "SA",
        "SE",
        "CH",
        "SN",
        "RS",
        "CS",
        "SC",
        "SL",
        "ZW",
        "SG",
        "SK",
        "SI",
        "SO",
        "ES",
        "LK",
        "SS",
        "BL",
        "SH",
        "KN",
        "LC",
        "MF",
        "PM",
        "VC",
        "ZA",
        "SD",
        "GS",
        "SR",
        "SJ",
        "SZ",
        "SX",
        "SY",
        "TJ",
        "TW",
        "TZ",
        "TH",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TD",
        "CZ",
        "TN",
        "TR",
        "TM",
        "TC",
        "TV",
        "UG",
        "UA",
        "HU",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VE",
        "AE",
        "GB",
        "US",
        "VN",
        "WF",
        "CX",
        "EH",
        "CF",
        "CY",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Welt");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Nordamerika");
    namesMap.put("005", "Südamerika");
    namesMap.put("009", "Ozeanien");
    namesMap.put("011", "Westafrika");
    namesMap.put("013", "Mittelamerika");
    namesMap.put("014", "Ostafrika");
    namesMap.put("015", "Nordafrika");
    namesMap.put("017", "Zentralafrika");
    namesMap.put("018", "Südliches Afrika");
    namesMap.put("019", "Amerika");
    namesMap.put("021", "Nördliches Amerika");
    namesMap.put("029", "Karibik");
    namesMap.put("030", "Ostasien");
    namesMap.put("034", "Südasien");
    namesMap.put("035", "Südostasien");
    namesMap.put("039", "Südeuropa");
    namesMap.put("053", "Australien und Neuseeland");
    namesMap.put("054", "Melanesien");
    namesMap.put("057", "Mikronesisches Inselgebiet");
    namesMap.put("061", "Polynesien");
    namesMap.put("142", "Asien");
    namesMap.put("143", "Zentralasien");
    namesMap.put("145", "Westasien");
    namesMap.put("150", "Europa");
    namesMap.put("151", "Osteuropa");
    namesMap.put("154", "Nordeuropa");
    namesMap.put("155", "Westeuropa");
    namesMap.put("419", "Lateinamerika");
    namesMap.put("AC", "Ascension");
    namesMap.put("AE", "Vereinigte Arabische Emirate");
    namesMap.put("AG", "Antigua und Barbuda");
    namesMap.put("AL", "Albanien");
    namesMap.put("AM", "Armenien");
    namesMap.put("AN", "Niederländische Antillen");
    namesMap.put("AQ", "Antarktis");
    namesMap.put("AR", "Argentinien");
    namesMap.put("AS", "Amerikanisch-Samoa");
    namesMap.put("AT", "Österreich");
    namesMap.put("AU", "Australien");
    namesMap.put("AX", "Alandinseln");
    namesMap.put("AZ", "Aserbaidschan");
    namesMap.put("BA", "Bosnien und Herzegowina");
    namesMap.put("BD", "Bangladesch");
    namesMap.put("BE", "Belgien");
    namesMap.put("BG", "Bulgarien");
    namesMap.put("BL", "St. Barthélemy");
    namesMap.put("BN", "Brunei Darussalam");
    namesMap.put("BO", "Bolivien");
    namesMap.put("BR", "Brasilien");
    namesMap.put("BV", "Bouvetinsel");
    namesMap.put("BW", "Botsuana");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Kokosinseln");
    namesMap.put("CD", "Kongo-Kinshasa");
    namesMap.put("CF", "Zentralafrikanische Republik");
    namesMap.put("CG", "Kongo-Brazzaville");
    namesMap.put("CH", "Schweiz");
    namesMap.put("CK", "Cookinseln");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CO", "Kolumbien");
    namesMap.put("CP", "Clipperton-Insel");
    namesMap.put("CS", "Serbien und Montenegro");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Kap Verde");
    namesMap.put("CX", "Weihnachtsinsel");
    namesMap.put("CY", "Zypern");
    namesMap.put("CZ", "Tschechische Republik");
    namesMap.put("DE", "Deutschland");
    namesMap.put("DJ", "Dschibuti");
    namesMap.put("DK", "Dänemark");
    namesMap.put("DO", "Dominikanische Republik");
    namesMap.put("DZ", "Algerien");
    namesMap.put("EA", "Ceuta und Melilla");
    namesMap.put("EE", "Estland");
    namesMap.put("EG", "Ägypten");
    namesMap.put("EH", "Westsahara");
    namesMap.put("ES", "Spanien");
    namesMap.put("ET", "Äthiopien");
    namesMap.put("EU", "Europäische Union");
    namesMap.put("FI", "Finnland");
    namesMap.put("FJ", "Fidschi");
    namesMap.put("FK", "Falklandinseln");
    namesMap.put("FM", "Mikronesien");
    namesMap.put("FO", "Färöer");
    namesMap.put("FR", "Frankreich");
    namesMap.put("FX", "Metropolitan-Frankreich");
    namesMap.put("GA", "Gabun");
    namesMap.put("GB", "Vereinigtes Königreich");
    namesMap.put("GE", "Georgien");
    namesMap.put("GF", "Französisch-Guayana");
    namesMap.put("GL", "Grönland");
    namesMap.put("GQ", "Äquatorialguinea");
    namesMap.put("GR", "Griechenland");
    namesMap.put("GS", "Südgeorgien und die Südlichen Sandwichinseln");
    namesMap.put("HK", "Hongkong");
    namesMap.put("HM", "Heard- und McDonald-Inseln");
    namesMap.put("HR", "Kroatien");
    namesMap.put("HU", "Ungarn");
    namesMap.put("IC", "Kanarische Inseln");
    namesMap.put("ID", "Indonesien");
    namesMap.put("IE", "Irland");
    namesMap.put("IN", "Indien");
    namesMap.put("IO", "Britisches Territorium im Indischen Ozean");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Island");
    namesMap.put("IT", "Italien");
    namesMap.put("JM", "Jamaika");
    namesMap.put("JO", "Jordanien");
    namesMap.put("KE", "Kenia");
    namesMap.put("KG", "Kirgisistan");
    namesMap.put("KH", "Kambodscha");
    namesMap.put("KM", "Komoren");
    namesMap.put("KN", "St. Kitts und Nevis");
    namesMap.put("KP", "Demokratische Volksrepublik Korea");
    namesMap.put("KR", "Republik Korea");
    namesMap.put("KY", "Kaimaninseln");
    namesMap.put("KZ", "Kasachstan");
    namesMap.put("LB", "Libanon");
    namesMap.put("LC", "St. Lucia");
    namesMap.put("LT", "Litauen");
    namesMap.put("LU", "Luxemburg");
    namesMap.put("LV", "Lettland");
    namesMap.put("LY", "Libyen");
    namesMap.put("MA", "Marokko");
    namesMap.put("MD", "Republik Moldau");
    namesMap.put("MF", "St. Martin");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Marshallinseln");
    namesMap.put("MK", "Mazedonien");
    namesMap.put("MM", "Myanmar");
    namesMap.put("MN", "Mongolei");
    namesMap.put("MO", "Macao");
    namesMap.put("MP", "Nördliche Marianen");
    namesMap.put("MR", "Mauretanien");
    namesMap.put("MV", "Malediven");
    namesMap.put("MX", "Mexiko");
    namesMap.put("MZ", "Mosambik");
    namesMap.put("NC", "Neukaledonien");
    namesMap.put("NF", "Norfolkinsel");
    namesMap.put("NL", "Niederlande");
    namesMap.put("NO", "Norwegen");
    namesMap.put("NZ", "Neuseeland");
    namesMap.put("PF", "Französisch-Polynesien");
    namesMap.put("PG", "Papua-Neuguinea");
    namesMap.put("PH", "Philippinen");
    namesMap.put("PL", "Polen");
    namesMap.put("PM", "St. Pierre und Miquelon");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("PS", "Palästinensische Autonomiegebiete");
    namesMap.put("QA", "Katar");
    namesMap.put("QO", "Äußeres Ozeanien");
    namesMap.put("RO", "Rumänien");
    namesMap.put("RS", "Serbien");
    namesMap.put("RU", "Russische Föderation");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Saudi-Arabien");
    namesMap.put("SB", "Salomonen");
    namesMap.put("SC", "Seychellen");
    namesMap.put("SE", "Schweden");
    namesMap.put("SG", "Singapur");
    namesMap.put("SH", "St. Helena");
    namesMap.put("SI", "Slowenien");
    namesMap.put("SJ", "Svalbard und Jan Mayen");
    namesMap.put("SK", "Slowakei");
    namesMap.put("ST", "São Tomé und Príncipe");
    namesMap.put("SY", "Syrien");
    namesMap.put("SZ", "Swasiland");
    namesMap.put("TC", "Turks- und Caicosinseln");
    namesMap.put("TD", "Tschad");
    namesMap.put("TF", "Französische Süd- und Antarktisgebiete");
    namesMap.put("TJ", "Tadschikistan");
    namesMap.put("TL", "Osttimor");
    namesMap.put("TN", "Tunesien");
    namesMap.put("TR", "Türkei");
    namesMap.put("TT", "Trinidad und Tobago");
    namesMap.put("TZ", "Tansania");
    namesMap.put("UM", "Amerikanisch-Ozeanien");
    namesMap.put("US", "Vereinigte Staaten");
    namesMap.put("UZ", "Usbekistan");
    namesMap.put("VA", "Vatikanstadt");
    namesMap.put("VC", "St. Vincent und die Grenadinen");
    namesMap.put("VG", "Britische Jungferninseln");
    namesMap.put("VI", "Amerikanische Jungferninseln");
    namesMap.put("WF", "Wallis und Futuna");
    namesMap.put("YE", "Jemen");
    namesMap.put("ZA", "Südafrika");
    namesMap.put("ZM", "Sambia");
    namesMap.put("ZW", "Simbabwe");
    namesMap.put("ZZ", "Unbekannte Region");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Welt",
        "002": "Afrika",
        "003": "Nordamerika",
        "005": "Südamerika",
        "009": "Ozeanien",
        "011": "Westafrika",
        "013": "Mittelamerika",
        "014": "Ostafrika",
        "015": "Nordafrika",
        "017": "Zentralafrika",
        "018": "Südliches Afrika",
        "019": "Amerika",
        "021": "Nördliches Amerika",
        "029": "Karibik",
        "030": "Ostasien",
        "034": "Südasien",
        "035": "Südostasien",
        "039": "Südeuropa",
        "053": "Australien und Neuseeland",
        "054": "Melanesien",
        "057": "Mikronesisches Inselgebiet",
        "061": "Polynesien",
        "142": "Asien",
        "143": "Zentralasien",
        "145": "Westasien",
        "150": "Europa",
        "151": "Osteuropa",
        "154": "Nordeuropa",
        "155": "Westeuropa",
        "419": "Lateinamerika",
        "AC": "Ascension",
        "AE": "Vereinigte Arabische Emirate",
        "AG": "Antigua und Barbuda",
        "AL": "Albanien",
        "AM": "Armenien",
        "AN": "Niederländische Antillen",
        "AQ": "Antarktis",
        "AR": "Argentinien",
        "AS": "Amerikanisch-Samoa",
        "AT": "Österreich",
        "AU": "Australien",
        "AX": "Alandinseln",
        "AZ": "Aserbaidschan",
        "BA": "Bosnien und Herzegowina",
        "BD": "Bangladesch",
        "BE": "Belgien",
        "BG": "Bulgarien",
        "BL": "St. Barthélemy",
        "BN": "Brunei Darussalam",
        "BO": "Bolivien",
        "BR": "Brasilien",
        "BV": "Bouvetinsel",
        "BW": "Botsuana",
        "CA": "Kanada",
        "CC": "Kokosinseln",
        "CD": "Kongo-Kinshasa",
        "CF": "Zentralafrikanische Republik",
        "CG": "Kongo-Brazzaville",
        "CH": "Schweiz",
        "CK": "Cookinseln",
        "CM": "Kamerun",
        "CO": "Kolumbien",
        "CP": "Clipperton-Insel",
        "CS": "Serbien und Montenegro",
        "CU": "Kuba",
        "CV": "Kap Verde",
        "CX": "Weihnachtsinsel",
        "CY": "Zypern",
        "CZ": "Tschechische Republik",
        "DE": "Deutschland",
        "DJ": "Dschibuti",
        "DK": "Dänemark",
        "DO": "Dominikanische Republik",
        "DZ": "Algerien",
        "EA": "Ceuta und Melilla",
        "EE": "Estland",
        "EG": "Ägypten",
        "EH": "Westsahara",
        "ES": "Spanien",
        "ET": "Äthiopien",
        "EU": "Europäische Union",
        "FI": "Finnland",
        "FJ": "Fidschi",
        "FK": "Falklandinseln",
        "FM": "Mikronesien",
        "FO": "Färöer",
        "FR": "Frankreich",
        "FX": "Metropolitan-Frankreich",
        "GA": "Gabun",
        "GB": "Vereinigtes Königreich",
        "GE": "Georgien",
        "GF": "Französisch-Guayana",
        "GL": "Grönland",
        "GQ": "Äquatorialguinea",
        "GR": "Griechenland",
        "GS": "Südgeorgien und die Südlichen Sandwichinseln",
        "HK": "Hongkong",
        "HM": "Heard- und McDonald-Inseln",
        "HR": "Kroatien",
        "HU": "Ungarn",
        "IC": "Kanarische Inseln",
        "ID": "Indonesien",
        "IE": "Irland",
        "IN": "Indien",
        "IO": "Britisches Territorium im Indischen Ozean",
        "IQ": "Irak",
        "IS": "Island",
        "IT": "Italien",
        "JM": "Jamaika",
        "JO": "Jordanien",
        "KE": "Kenia",
        "KG": "Kirgisistan",
        "KH": "Kambodscha",
        "KM": "Komoren",
        "KN": "St. Kitts und Nevis",
        "KP": "Demokratische Volksrepublik Korea",
        "KR": "Republik Korea",
        "KY": "Kaimaninseln",
        "KZ": "Kasachstan",
        "LB": "Libanon",
        "LC": "St. Lucia",
        "LT": "Litauen",
        "LU": "Luxemburg",
        "LV": "Lettland",
        "LY": "Libyen",
        "MA": "Marokko",
        "MD": "Republik Moldau",
        "MF": "St. Martin",
        "MG": "Madagaskar",
        "MH": "Marshallinseln",
        "MK": "Mazedonien",
        "MM": "Myanmar",
        "MN": "Mongolei",
        "MO": "Macao",
        "MP": "Nördliche Marianen",
        "MR": "Mauretanien",
        "MV": "Malediven",
        "MX": "Mexiko",
        "MZ": "Mosambik",
        "NC": "Neukaledonien",
        "NF": "Norfolkinsel",
        "NL": "Niederlande",
        "NO": "Norwegen",
        "NZ": "Neuseeland",
        "PF": "Französisch-Polynesien",
        "PG": "Papua-Neuguinea",
        "PH": "Philippinen",
        "PL": "Polen",
        "PM": "St. Pierre und Miquelon",
        "PN": "Pitcairn",
        "PS": "Palästinensische Autonomiegebiete",
        "QA": "Katar",
        "QO": "Äußeres Ozeanien",
        "RO": "Rumänien",
        "RS": "Serbien",
        "RU": "Russische Föderation",
        "RW": "Ruanda",
        "SA": "Saudi-Arabien",
        "SB": "Salomonen",
        "SC": "Seychellen",
        "SE": "Schweden",
        "SG": "Singapur",
        "SH": "St. Helena",
        "SI": "Slowenien",
        "SJ": "Svalbard und Jan Mayen",
        "SK": "Slowakei",
        "ST": "São Tomé und Príncipe",
        "SY": "Syrien",
        "SZ": "Swasiland",
        "TC": "Turks- und Caicosinseln",
        "TD": "Tschad",
        "TF": "Französische Süd- und Antarktisgebiete",
        "TJ": "Tadschikistan",
        "TL": "Osttimor",
        "TN": "Tunesien",
        "TR": "Türkei",
        "TT": "Trinidad und Tobago",
        "TZ": "Tansania",
        "UM": "Amerikanisch-Ozeanien",
        "US": "Vereinigte Staaten",
        "UZ": "Usbekistan",
        "VA": "Vatikanstadt",
        "VC": "St. Vincent und die Grenadinen",
        "VG": "Britische Jungferninseln",
        "VI": "Amerikanische Jungferninseln",
        "WF": "Wallis und Futuna",
        "YE": "Jemen",
        "ZA": "Südafrika",
        "ZM": "Sambia",
        "ZW": "Simbabwe",
        "ZZ": "Unbekannte Region"
    };
  }-*/;
}
