/*
 * Decompiled with CFR 0.152.
 */
package org.kie.config.cli;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Produces;
import javax.inject.Named;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.exception.UnauthorizedException;
import org.kie.config.cli.CliIdentity;
import org.uberfire.io.IOService;
import org.uberfire.io.impl.IOServiceDotFileImpl;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.rpc.impl.SessionInfoImpl;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.security.authz.RuntimeResource;
import org.uberfire.security.impl.authz.RuntimeAuthorizationManager;

@ApplicationScoped
public class EnvironmentProvider {
    private final IOService ioService = new IOServiceDotFileImpl();
    public static final Role ADMIN_ROLE = new Role(){

        public String getName() {
            return "admin";
        }
    };

    @Produces
    @Named(value="ioStrategy")
    public IOService ioService() {
        return this.ioService;
    }

    @Produces
    @Alternative
    public SessionInfo getSessionInfo() {
        CliIdentity identity = new CliIdentity();
        return new SessionInfoImpl(identity.getIdentifier(), (User)identity);
    }

    @Produces
    public AuthorizationManager getAuthManager() {
        return new RuntimeAuthorizationManager(){

            public boolean supports(Resource resource) {
                return resource instanceof RuntimeResource;
            }

            public boolean authorize(Resource resource, User subject) throws UnauthorizedException {
                return subject.getRoles().contains(ADMIN_ROLE);
            }
        };
    }
}

