/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpSession;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.bus.server.api.RpcContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.backend.vfs.VFSLockService;
import org.uberfire.backend.vfs.impl.LockInfo;
import org.uberfire.backend.vfs.impl.LockResult;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceDeletedEvent;
import org.uberfire.workbench.events.ResourceRenamedEvent;

@Service
@ApplicationScoped
public class VFSLockServiceImpl
implements VFSLockService {
    public static final String LOCK_SESSION_ATTRIBUTE_NAME = "uf-locks";
    private static final Logger logger = LoggerFactory.getLogger(VFSLockServiceImpl.class);
    @Inject
    @Named(value="configIO")
    private IOService ioService;
    @Inject
    private SessionInfo sessionInfo;

    public LockResult acquireLock(org.uberfire.backend.vfs.Path path) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        LockResult result;
        String userId = this.sessionInfo.getIdentity().getIdentifier();
        LockInfo lockInfo = this.retrieveLockInfo(path);
        if (lockInfo.isLocked() && !lockInfo.lockedBy().equals(userId)) {
            result = LockResult.failed((LockInfo)lockInfo);
        } else {
            this.ioService.write(Paths.convert(lockInfo.getLock()), userId, new OpenOption[0]);
            result = LockResult.acquired((org.uberfire.backend.vfs.Path)path, (String)userId);
            this.updateSession(result.getLockInfo());
        }
        return result;
    }

    public LockResult releaseLock(org.uberfire.backend.vfs.Path path) throws IllegalArgumentException, IOException {
        return this.releaseLock(path, false);
    }

    public LockResult forceReleaseLock(org.uberfire.backend.vfs.Path path) throws IllegalArgumentException, IOException {
        String userId = this.sessionInfo.getIdentity().getIdentifier();
        logger.info("User " + userId + " forced a lock release of: " + path.toURI());
        return this.releaseLock(path, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LockResult releaseLock(org.uberfire.backend.vfs.Path path, boolean force) throws IllegalArgumentException, IOException {
        LockInfo lockInfo = this.retrieveLockInfo(path);
        if (!lockInfo.isLocked()) return LockResult.failed((LockInfo)lockInfo);
        if (this.sessionInfo.getIdentity().getIdentifier().equals(lockInfo.lockedBy()) || force) {
            this.ioService.delete(Paths.convert(lockInfo.getLock()), new DeleteOption[0]);
            this.updateSession(lockInfo, true);
            return LockResult.released((org.uberfire.backend.vfs.Path)path);
        }
        logger.error("Client requested to release a lock it doesn't hold: " + path.toURI());
        throw new IOException("Not allowed");
    }

    public LockInfo retrieveLockInfo(org.uberfire.backend.vfs.Path path) throws IllegalArgumentException, IOException {
        LockInfo result;
        org.uberfire.backend.vfs.Path vfsLock = PathFactory.newLock((org.uberfire.backend.vfs.Path)path);
        Path realLock = Paths.convert(vfsLock);
        if (this.ioService.exists(realLock)) {
            String lockedBy = this.ioService.readAllString(realLock);
            result = new LockInfo(true, lockedBy, path, vfsLock);
        } else {
            result = new LockInfo(false, null, path, vfsLock);
        }
        return result;
    }

    public List<LockInfo> retrieveLockInfos(org.uberfire.backend.vfs.Path path, boolean excludeOwnedLocks) throws IllegalArgumentException, IOException {
        if (!Files.isDirectory((Path)Paths.convert(path), (LinkOption[])new LinkOption[0])) {
            return Collections.emptyList();
        }
        org.uberfire.backend.vfs.Path lockPath = PathFactory.newLockPath((org.uberfire.backend.vfs.Path)path);
        ArrayList<org.uberfire.backend.vfs.Path> locks = new ArrayList<org.uberfire.backend.vfs.Path>();
        this.retrieveLocks(this.ioService.get(URI.create(lockPath.toURI())), locks);
        LinkedList<LockInfo> lockInfos = new LinkedList<LockInfo>();
        for (org.uberfire.backend.vfs.Path lock : locks) {
            LockInfo lockInfo = this.retrieveLockInfo(PathFactory.fromLock((org.uberfire.backend.vfs.Path)lock));
            if (excludeOwnedLocks && this.sessionInfo.getIdentity().getIdentifier().equals(lockInfo.lockedBy()) || !Files.exists((Path)Paths.convert(lockInfo.getFile()), (LinkOption[])new LinkOption[0])) continue;
            lockInfos.add(lockInfo);
        }
        return lockInfos;
    }

    private void retrieveLocks(Path path, final List<org.uberfire.backend.vfs.Path> accu) {
        if (!Files.exists((Path)path, (LinkOption[])new LinkOption[0])) {
            return;
        }
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                if (Paths.convert(entry).toURI().endsWith(".ulock")) {
                    accu.add(Paths.convert(entry));
                } else if (Files.isDirectory((Path)entry, (LinkOption[])new LinkOption[0])) {
                    VFSLockServiceImpl.this.retrieveLocks(VFSLockServiceImpl.this.ioService.get(entry.toUri()), accu);
                }
                return true;
            }
        };
        Iterator it = this.ioService.newDirectoryStream(path, (DirectoryStream.Filter)filter).iterator();
        while (it.hasNext()) {
            it.next();
        }
    }

    private void updateSession(LockInfo lockInfo, boolean remove) {
        HttpSession session = RpcContext.getHttpSession();
        HashSet<LockInfo> locks = (HashSet<LockInfo>)session.getAttribute(LOCK_SESSION_ATTRIBUTE_NAME);
        if (remove && locks != null) {
            locks.remove(lockInfo);
        } else {
            if (locks == null) {
                locks = new HashSet<LockInfo>();
            }
            locks.add(lockInfo);
            session.setAttribute(LOCK_SESSION_ATTRIBUTE_NAME, locks);
        }
    }

    private void updateSession(LockInfo lockInfo) {
        this.updateSession(lockInfo, false);
    }

    private void onResourceDeleted(@Observes ResourceDeletedEvent res) {
        this.maybeDeleteLock(res.getPath());
    }

    private void onResourceRenamed(@Observes ResourceRenamedEvent res) {
        this.maybeDeleteLock(res.getPath());
    }

    private void maybeDeleteLock(org.uberfire.backend.vfs.Path path) {
        LockInfo lockInfo = this.retrieveLockInfo(path);
        if (lockInfo.isLocked()) {
            this.ioService.delete(Paths.convert(lockInfo.getLock()), new DeleteOption[0]);
        }
    }
}

