/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.bpmn2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.BPMN2ProcessFactory;
import org.drools.compiler.compiler.BPMN2ProcessProvider;
import org.drools.core.io.impl.ByteArrayResource;
import org.drools.core.util.StringUtils;
import org.drools.core.xml.SemanticModule;
import org.jbpm.bpmn2.xml.BPMNDISemanticModule;
import org.jbpm.kie.services.impl.bpmn2.BPMN2DataServiceExtensionSemanticModule;
import org.jbpm.kie.services.impl.bpmn2.BPMN2DataServiceSemanticModule;
import org.jbpm.kie.services.impl.bpmn2.ProcessDescRepoHelper;
import org.jbpm.kie.services.impl.bpmn2.builder.DataServiceExpressionBuilder;
import org.jbpm.kie.services.impl.bpmn2.builder.dialect.ThreadLocalAbstractBuilderFacade;
import org.jbpm.kie.services.impl.bpmn2.builder.dialect.java.DataServiceJavaProcessDialect;
import org.jbpm.kie.services.impl.bpmn2.builder.dialect.mvel.DataServiceMvelProcessDialect;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.process.builder.ActionBuilder;
import org.jbpm.process.builder.AssignmentBuilder;
import org.jbpm.process.builder.ProcessClassBuilder;
import org.jbpm.process.builder.ReturnValueEvaluatorBuilder;
import org.jbpm.process.builder.dialect.ProcessDialect;
import org.jbpm.process.builder.dialect.ProcessDialectRegistry;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.DeploymentEvent;
import org.jbpm.services.api.DeploymentEventListener;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.api.model.UserTaskDefinition;
import org.kie.api.definition.process.Process;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieContainer;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.definition.KnowledgePackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BPMN2DataServiceImpl
implements DefinitionService,
DeploymentEventListener {
    private static final Logger logger = LoggerFactory.getLogger(BPMN2DataServiceImpl.class);
    private static final BPMN2DataServiceSemanticModule MODULE = new BPMN2DataServiceSemanticModule();
    private static final BPMN2DataServiceExtensionSemanticModule EXTENSIONS_MODULE = new BPMN2DataServiceExtensionSemanticModule(MODULE);
    private ConcurrentMap<String, Map<String, ProcessDescRepoHelper>> definitionCache = new ConcurrentHashMap<String, Map<String, ProcessDescRepoHelper>>();
    static final String[] SCRIPT_DIALECT_NAMES = new String[]{"java", "mvel"};
    private static final ProcessDialect[] dataServiceDialects = new ProcessDialect[]{new DataServiceJavaProcessDialect(), new DataServiceMvelProcessDialect()};

    public BPMN2ProcessProvider getProvider(final BPMN2DataServiceSemanticModule module, final BPMN2DataServiceExtensionSemanticModule extensionsModule) {
        return new BPMN2ProcessProvider(){

            public void configurePackageBuilder(KnowledgeBuilder packageBuilder) {
                KnowledgeBuilderConfigurationImpl conf = ((KnowledgeBuilderImpl)packageBuilder).getBuilderConfiguration();
                if (conf.getSemanticModules().getSemanticModule("http://www.jboss.org/bpmn2-data-services") == null) {
                    conf.addSemanticModule((SemanticModule)module);
                }
                if (conf.getSemanticModules().getSemanticModule("http://www.jboss.org/bpmn2-data-services-ext") == null) {
                    conf.addSemanticModule((SemanticModule)extensionsModule);
                }
                conf.addSemanticModule((SemanticModule)new BPMNDISemanticModule());
            }
        };
    }

    private void validateNonEmptyDeploymentIdAndProcessId(String deploymentId, String processId) {
        this.validateNonEmptyDeploymentIdAndProcessIdAndTaskName(deploymentId, processId, "x");
    }

    private void validateNonEmptyDeploymentIdAndProcessIdAndTaskName(String deploymentId, String processId, String taskName) {
        boolean emptyDepId = StringUtils.isEmpty((CharSequence)deploymentId);
        boolean emptyProcId = StringUtils.isEmpty((CharSequence)processId);
        boolean emptyTaskName = StringUtils.isEmpty((CharSequence)taskName);
        if (emptyDepId || emptyProcId || emptyTaskName) {
            StringBuffer msg = new StringBuffer("The ");
            if (emptyDepId) {
                msg.append("deployment id ");
            }
            if (emptyDepId && (emptyProcId || emptyTaskName)) {
                msg.append("and the ");
            }
            if (emptyProcId) {
                msg.append("process id ");
            }
            if (emptyDepId && emptyTaskName) {
                msg.append("and the ");
            }
            if (emptyTaskName) {
                msg.append("task name ");
            }
            msg.append("may not be empty or null!");
            throw new IllegalStateException(msg.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessDefinition buildProcessDefinition(String deploymentId, String bpmn2Content, KieContainer kieContainer, boolean cache) throws IllegalArgumentException {
        if (StringUtils.isEmpty((CharSequence)bpmn2Content)) {
            return null;
        }
        this.validateNonEmptyDeploymentIdAndProcessId(deploymentId, "no proc id");
        BPMN2ProcessProvider provider = this.getProvider(MODULE, EXTENSIONS_MODULE);
        BPMN2ProcessProvider originalProvider = BPMN2ProcessFactory.getBPMN2ProcessProvider();
        if (originalProvider != provider) {
            BPMN2ProcessFactory.setBPMN2ProcessProvider((BPMN2ProcessProvider)provider);
        }
        try {
            ProcessDescRepoHelper threadLocalHelper = new ProcessDescRepoHelper();
            BPMN2DataServiceSemanticModule.setRepoHelper(threadLocalHelper);
            BPMN2DataServiceExtensionSemanticModule.setRepoHelper(threadLocalHelper);
            KnowledgeBuilder kbuilder = null;
            if (kieContainer != null && kieContainer.getClassLoader() != null) {
                KnowledgeBuilderConfigurationImpl pconf = new KnowledgeBuilderConfigurationImpl(new ClassLoader[]{kieContainer.getClassLoader()});
                kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)pconf);
            } else {
                kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            }
            kbuilder.add((Resource)new ByteArrayResource(bpmn2Content.getBytes()), ResourceType.BPMN2);
            if (kbuilder.hasErrors()) {
                for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                    logger.error("Error: {}", (Object)error.getMessage());
                }
                logger.debug("Process Cannot be Parsed! \n {} \n", (Object)bpmn2Content);
                Iterator i$ = null;
                return i$;
            }
            KnowledgePackage pckg = (KnowledgePackage)kbuilder.getKnowledgePackages().iterator().next();
            Process process = (Process)pckg.getProcesses().iterator().next();
            ProcessDescRepoHelper helper = MODULE.getRepo().removeProcessDescription(process.getId());
            ProcessAssetDesc definition = helper.getProcess();
            definition.setAssociatedEntities(helper.getTaskAssignments());
            definition.setProcessVariables(helper.getInputs());
            definition.setServiceTasks(helper.getServiceTasks());
            if (kieContainer != null && helper.hasUnresolvedReusableSubProcessNames()) {
                helper.resolveReusableSubProcessNames(kieContainer.getKieBase().getProcesses());
            }
            definition.setReusableSubProcesses(helper.getReusableSubProcesses());
            if (cache) {
                ConcurrentHashMap<String, ProcessDescRepoHelper> definitions = null;
                ConcurrentMap<String, Map<String, ProcessDescRepoHelper>> concurrentMap = this.definitionCache;
                synchronized (concurrentMap) {
                    definitions = (ConcurrentHashMap<String, ProcessDescRepoHelper>)this.definitionCache.get(deploymentId);
                    if (definitions == null) {
                        definitions = new ConcurrentHashMap<String, ProcessDescRepoHelper>();
                        this.definitionCache.put(deploymentId, definitions);
                    }
                    definitions.put(process.getId(), helper);
                }
            }
            ProcessAssetDesc processAssetDesc = definition;
            return processAssetDesc;
        }
        finally {
            BPMN2ProcessFactory.setBPMN2ProcessProvider((BPMN2ProcessProvider)originalProvider);
            BPMN2DataServiceSemanticModule.dispose();
        }
    }

    static void useDataServiceExpressionBuilders(ProcessDescRepoHelper processHelper) {
        for (int i = 0; i < SCRIPT_DIALECT_NAMES.length; ++i) {
            ProcessDialect dialect = ProcessDialectRegistry.getDialect((String)SCRIPT_DIALECT_NAMES[i]);
            ActionBuilder actionBuilder = null;
            try {
                actionBuilder = dialect.getActionBuilder();
                if (actionBuilder instanceof ThreadLocalAbstractBuilderFacade) {
                    ((ThreadLocalAbstractBuilderFacade)actionBuilder).useDataServiceBuilder(processHelper);
                }
            }
            catch (UnsupportedOperationException uoe) {
                // empty catch block
            }
            AssignmentBuilder assignmentBuilder = null;
            try {
                assignmentBuilder = dialect.getAssignmentBuilder();
                if (assignmentBuilder instanceof DataServiceExpressionBuilder) {
                    ((DataServiceExpressionBuilder)assignmentBuilder).setProcessHelperForThread(processHelper);
                }
            }
            catch (UnsupportedOperationException uoe) {
                // empty catch block
            }
            ReturnValueEvaluatorBuilder returnValueEvaluatorBuilder = null;
            try {
                returnValueEvaluatorBuilder = dialect.getReturnValueEvaluatorBuilder();
                if (returnValueEvaluatorBuilder instanceof DataServiceExpressionBuilder) {
                    ((DataServiceExpressionBuilder)returnValueEvaluatorBuilder).setProcessHelperForThread(processHelper);
                }
            }
            catch (UnsupportedOperationException uoe) {
                // empty catch block
            }
            ProcessClassBuilder processClassBuilder = null;
            try {
                processClassBuilder = dialect.getProcessClassBuilder();
                if (!(processClassBuilder instanceof DataServiceExpressionBuilder)) continue;
                ((DataServiceExpressionBuilder)processClassBuilder).setProcessHelperForThread(processHelper);
                continue;
            }
            catch (UnsupportedOperationException uoe) {
                // empty catch block
            }
        }
    }

    static void resetDialectExpressionBuilders() {
        for (int i = 0; i < SCRIPT_DIALECT_NAMES.length; ++i) {
            ProcessDialect dialect = ProcessDialectRegistry.getDialect((String)SCRIPT_DIALECT_NAMES[i]);
            ActionBuilder actionBuilder = null;
            try {
                actionBuilder = dialect.getActionBuilder();
                if (actionBuilder instanceof ThreadLocalAbstractBuilderFacade) {
                    ((ThreadLocalAbstractBuilderFacade)actionBuilder).resetThreadLocalBuilder();
                }
            }
            catch (UnsupportedOperationException uoe) {
                // empty catch block
            }
            AssignmentBuilder assignmentBuilder = null;
            try {
                assignmentBuilder = dialect.getAssignmentBuilder();
                if (assignmentBuilder instanceof ThreadLocalAbstractBuilderFacade) {
                    ((ThreadLocalAbstractBuilderFacade)assignmentBuilder).resetThreadLocalBuilder();
                }
            }
            catch (UnsupportedOperationException uoe) {
                // empty catch block
            }
            ReturnValueEvaluatorBuilder returnValueEvaluatorBuilder = null;
            try {
                returnValueEvaluatorBuilder = dialect.getReturnValueEvaluatorBuilder();
                if (returnValueEvaluatorBuilder instanceof ThreadLocalAbstractBuilderFacade) {
                    ((ThreadLocalAbstractBuilderFacade)returnValueEvaluatorBuilder).resetThreadLocalBuilder();
                }
            }
            catch (UnsupportedOperationException uoe) {
                // empty catch block
            }
            ProcessClassBuilder processClassBuilder = null;
            try {
                processClassBuilder = dialect.getProcessClassBuilder();
                if (!(processClassBuilder instanceof ThreadLocalAbstractBuilderFacade)) continue;
                ((ThreadLocalAbstractBuilderFacade)processClassBuilder).resetThreadLocalBuilder();
                continue;
            }
            catch (UnsupportedOperationException uoe) {
                // empty catch block
            }
        }
    }

    public Map<String, String> getServiceTasks(String deploymentId, String processId) {
        this.validateNonEmptyDeploymentIdAndProcessId(deploymentId, processId);
        if (this.definitionCache.containsKey(deploymentId)) {
            ProcessDescRepoHelper helper = (ProcessDescRepoHelper)((Map)this.definitionCache.get(deploymentId)).get(processId);
            if (helper == null) {
                throw new IllegalStateException("No process available with given id : " + processId);
            }
            return Collections.unmodifiableMap(helper.getServiceTasks());
        }
        return Collections.emptyMap();
    }

    public ProcessDefinition getProcessDefinition(String deploymentId, String processId) {
        this.validateNonEmptyDeploymentIdAndProcessId(deploymentId, processId);
        if (this.definitionCache.containsKey(deploymentId)) {
            ProcessDescRepoHelper helper = (ProcessDescRepoHelper)((Map)this.definitionCache.get(deploymentId)).get(processId);
            if (helper == null) {
                throw new IllegalStateException("No process available with given id : " + processId);
            }
            return helper.getProcess();
        }
        return null;
    }

    public Collection<String> getReusableSubProcesses(String deploymentId, String processId) {
        this.validateNonEmptyDeploymentIdAndProcessId(deploymentId, processId);
        if (this.definitionCache.containsKey(deploymentId)) {
            ProcessDescRepoHelper helper = (ProcessDescRepoHelper)((Map)this.definitionCache.get(deploymentId)).get(processId);
            if (helper == null) {
                throw new IllegalStateException("No process available with given id : " + processId);
            }
            if (helper.getReusableSubProcesses() != null) {
                return new ArrayList<String>(helper.getReusableSubProcesses());
            }
        }
        return Collections.emptyList();
    }

    public Map<String, String> getProcessVariables(String deploymentId, String processId) {
        this.validateNonEmptyDeploymentIdAndProcessId(deploymentId, processId);
        if (this.definitionCache.containsKey(deploymentId)) {
            ProcessDescRepoHelper helper = (ProcessDescRepoHelper)((Map)this.definitionCache.get(deploymentId)).get(processId);
            if (helper == null) {
                throw new IllegalStateException("No process available with given id : " + processId);
            }
            if (helper.getInputs() != null) {
                return Collections.unmodifiableMap(helper.getInputs());
            }
        }
        return Collections.emptyMap();
    }

    public Map<String, Collection<String>> getAssociatedEntities(String deploymentId, String processId) {
        this.validateNonEmptyDeploymentIdAndProcessId(deploymentId, processId);
        if (this.definitionCache.containsKey(deploymentId)) {
            ProcessDescRepoHelper helper = (ProcessDescRepoHelper)((Map)this.definitionCache.get(deploymentId)).get(processId);
            if (helper == null) {
                throw new IllegalStateException("No process available with given id : " + processId);
            }
            if (helper.getTaskAssignments() != null) {
                return Collections.unmodifiableMap(helper.getTaskAssignments());
            }
        }
        return Collections.emptyMap();
    }

    public Collection<UserTaskDefinition> getTasksDefinitions(String deploymentId, String processId) {
        this.validateNonEmptyDeploymentIdAndProcessId(deploymentId, processId);
        if (this.definitionCache.containsKey(deploymentId)) {
            ProcessDescRepoHelper helper = (ProcessDescRepoHelper)((Map)this.definitionCache.get(deploymentId)).get(processId);
            if (helper == null) {
                throw new IllegalStateException("No process available with given id : " + processId);
            }
            if (helper.getTasks() != null) {
                return new ArrayList<UserTaskDefinition>(helper.getTasks().values());
            }
        }
        return Collections.emptyList();
    }

    public Map<String, String> getTaskInputMappings(String deploymentId, String processId, String taskName) {
        this.validateNonEmptyDeploymentIdAndProcessIdAndTaskName(deploymentId, processId, taskName);
        if (this.definitionCache.containsKey(deploymentId)) {
            ProcessDescRepoHelper helper = (ProcessDescRepoHelper)((Map)this.definitionCache.get(deploymentId)).get(processId);
            if (helper == null) {
                throw new IllegalStateException("No process available with given id : " + processId);
            }
            if (helper.getTaskInputMappings().containsKey(taskName)) {
                return Collections.unmodifiableMap(helper.getTaskInputMappings().get(taskName));
            }
        }
        return Collections.emptyMap();
    }

    public Map<String, String> getTaskOutputMappings(String deploymentId, String processId, String taskName) {
        this.validateNonEmptyDeploymentIdAndProcessIdAndTaskName(deploymentId, processId, taskName);
        if (this.definitionCache.containsKey(deploymentId)) {
            ProcessDescRepoHelper helper = (ProcessDescRepoHelper)((Map)this.definitionCache.get(deploymentId)).get(processId);
            if (helper == null) {
                throw new IllegalStateException("No process available with given id : " + processId);
            }
            if (helper.getTaskOutputMappings().containsKey(taskName)) {
                return Collections.unmodifiableMap(helper.getTaskOutputMappings().get(taskName));
            }
        }
        return Collections.emptyMap();
    }

    public void onDeploy(DeploymentEvent event) {
    }

    public void onUnDeploy(DeploymentEvent event) {
        this.definitionCache.remove(event.getDeploymentId());
    }

    public void onActivate(DeploymentEvent event) {
    }

    public void onDeactivate(DeploymentEvent event) {
    }

    public Set<String> getJavaClasses(String deploymentId, String processId) {
        this.validateNonEmptyDeploymentIdAndProcessId(deploymentId, processId);
        if (this.definitionCache.containsKey(deploymentId)) {
            ProcessDescRepoHelper helper = (ProcessDescRepoHelper)((Map)this.definitionCache.get(deploymentId)).get(processId);
            if (helper == null) {
                throw new IllegalStateException("No process available with given id : " + processId);
            }
            return Collections.unmodifiableSet(helper.getReferencedClasses());
        }
        return Collections.emptySet();
    }

    public Set<String> getRuleSets(String deploymentId, String processId) {
        this.validateNonEmptyDeploymentIdAndProcessId(deploymentId, processId);
        if (this.definitionCache.containsKey(deploymentId)) {
            ProcessDescRepoHelper helper = (ProcessDescRepoHelper)((Map)this.definitionCache.get(deploymentId)).get(processId);
            if (helper == null) {
                throw new IllegalStateException("No process available with given id : " + processId);
            }
            return Collections.unmodifiableSet(helper.getReferencedRules());
        }
        return Collections.emptySet();
    }

    static {
        for (int i = 0; i < SCRIPT_DIALECT_NAMES.length; ++i) {
            ProcessDialectRegistry.setDialect((String)SCRIPT_DIALECT_NAMES[i], (ProcessDialect)dataServiceDialects[i]);
        }
    }
}

