/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.drools.core.base.ClassObjectType;
import org.drools.core.facttemplates.Fact;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.reteoo.ClassObjectTypeConf;
import org.drools.core.reteoo.FactTemplateTypeConf;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.rule.EntryPointId;
import org.drools.core.spi.Activation;

public class ObjectTypeConfigurationRegistry
implements Serializable {
    private static final long serialVersionUID = 510L;
    private InternalKnowledgeBase kBase;
    private ConcurrentMap<Object, ObjectTypeConf> typeConfMap;

    public ObjectTypeConfigurationRegistry(InternalKnowledgeBase kBase) {
        this.kBase = kBase;
        this.typeConfMap = new ConcurrentHashMap<Object, ObjectTypeConf>();
    }

    public ObjectTypeConf getObjectTypeConf(EntryPointId entrypoint, Object object) {
        ObjectTypeConf existing;
        ObjectTypeConf objectTypeConf = null;
        Class<?> cls = object instanceof Activation ? ClassObjectType.Match_ObjectType.getClassType() : object.getClass();
        Object key = object instanceof Fact ? ((Fact)object).getFactTemplate().getName() : cls;
        objectTypeConf = (ObjectTypeConf)this.typeConfMap.get(key);
        if (objectTypeConf == null) {
            objectTypeConf = object instanceof Fact ? new FactTemplateTypeConf(entrypoint, ((Fact)object).getFactTemplate(), this.kBase) : new ClassObjectTypeConf(entrypoint, (Class<?>)key, this.kBase);
        }
        if ((existing = this.typeConfMap.putIfAbsent(key, objectTypeConf)) != null) {
            objectTypeConf = existing;
        }
        return objectTypeConf;
    }

    public ObjectTypeConf getObjectTypeConfByClass(Class<?> cls) {
        return (ObjectTypeConf)this.typeConfMap.get(cls);
    }

    public Collection<ObjectTypeConf> values() {
        return this.typeConfMap.values();
    }
}

