/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.common.BaseNode;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.reteoo.AbstractLeftTupleSinkAdapter;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSinkNodeList;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.Sink;
import org.drools.core.spi.PropagationContext;

public class CompositeLeftTupleSinkAdapter
extends AbstractLeftTupleSinkAdapter {
    private LeftTupleSinkNodeList sinks;
    private LeftTupleSink[] sinkArray;

    public CompositeLeftTupleSinkAdapter() {
        super(RuleBasePartitionId.MAIN_PARTITION);
    }

    public CompositeLeftTupleSinkAdapter(RuleBasePartitionId partitionId) {
        super(partitionId);
        this.sinks = new LeftTupleSinkNodeList();
    }

    public void addTupleSink(LeftTupleSink sink) {
        this.sinks.add((LeftTupleSinkNode)sink);
        this.sinkArray = null;
    }

    public void removeTupleSink(LeftTupleSink sink) {
        this.sinks.remove((LeftTupleSinkNode)sink);
        this.sinkArray = null;
    }

    public LeftTupleSinkNodeList getRawSinks() {
        return this.sinks;
    }

    @Override
    public void createChildLeftTuplesforQuery(LeftTuple leftTuple, RightTuple rightTuple, boolean leftTupleMemoryEnabled, boolean linkRightTuple) {
        for (LeftTupleSinkNode sink = this.sinks.getLast(); sink != null; sink = sink.getPreviousLeftTupleSinkNode()) {
            LeftTuple leftTuple2 = sink.createLeftTuple(leftTuple, rightTuple, (Sink)sink);
        }
    }

    @Override
    public void propagateAssertLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, PropagationContext context, InternalWorkingMemory workingMemory, boolean leftTupleMemoryEnabled) {
        for (LeftTupleSinkNode sink = this.sinks.getFirst(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            LeftTuple newLeftTuple = sink.createLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
            this.doPropagateAssertLeftTuple(context, workingMemory, sink, newLeftTuple);
        }
    }

    @Override
    public void propagateAssertLeftTuple(LeftTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory, boolean leftTupleMemoryEnabled) {
        for (LeftTupleSinkNode sink = this.sinks.getFirst(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            this.doPropagateAssertLeftTuple(context, workingMemory, sink, sink.createLeftTuple(tuple, sink, context, leftTupleMemoryEnabled));
        }
    }

    @Override
    public void createAndPropagateAssertLeftTuple(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory, boolean leftTupleMemoryEnabled, LeftInputAdapterNode liaNode) {
        for (LeftTupleSinkNode sink = this.sinks.getFirst(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            LeftTuple lt = sink.createLeftTuple(factHandle, sink, leftTupleMemoryEnabled);
            lt.setPropagationContext(context);
            this.doPropagateAssertLeftTuple(context, workingMemory, sink, lt);
        }
    }

    @Override
    public void propagateRetractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple child = leftTuple.getFirstChild();
        while (child != null) {
            LeftTuple temp = (LeftTuple)child.getHandleNext();
            child.retractTuple(context, workingMemory);
            child.unlinkFromRightParent();
            child.unlinkFromLeftParent();
            child = temp;
        }
    }

    @Override
    public void propagateRetractLeftTupleDestroyRightTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple child = leftTuple.getFirstChild();
        InternalFactHandle rightParent = child.getRightParent().getFactHandle();
        while (child != null) {
            LeftTuple temp = (LeftTuple)child.getHandleNext();
            child.retractTuple(context, workingMemory);
            child.unlinkFromRightParent();
            child.unlinkFromLeftParent();
            child = temp;
        }
    }

    @Override
    public void propagateRetractRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple child = rightTuple.getFirstChild();
        while (child != null) {
            LeftTuple temp = child.getRightParentNext();
            child.retractTuple(context, workingMemory);
            child.unlinkFromLeftParent();
            child.unlinkFromRightParent();
            child = temp;
        }
    }

    @Override
    public BaseNode getMatchingNode(BaseNode candidate) {
        for (LeftTupleSinkNode sink = this.sinks.getFirst(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            if (!candidate.equals(sink)) continue;
            return (BaseNode)((Object)sink);
        }
        return null;
    }

    @Override
    public LeftTupleSink[] getSinks() {
        if (this.sinkArray == null) {
            this.sinkArray = new LeftTupleSink[this.sinks.size()];
            int i = 0;
            for (LeftTupleSinkNode sink = this.sinks.getFirst(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
                this.sinkArray[i++] = sink;
            }
        }
        return this.sinkArray;
    }

    @Override
    public LeftTupleSinkNode getFirstLeftTupleSink() {
        return this.sinks.getFirst();
    }

    @Override
    public LeftTupleSinkNode getLastLeftTupleSink() {
        return this.sinks.getLast();
    }

    @Override
    public int size() {
        return this.sinks.size();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.sinks = (LeftTupleSinkNodeList)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.sinks);
    }

    @Override
    public void doPropagateAssertLeftTuple(PropagationContext context, InternalWorkingMemory workingMemory, LeftTuple leftTuple, LeftTupleSink sink) {
        sink.assertLeftTuple(leftTuple, context, workingMemory);
    }

    protected void doPropagateAssertLeftTuple(PropagationContext context, InternalWorkingMemory workingMemory, LeftTupleSinkNode sink, LeftTuple leftTuple) {
        sink.assertLeftTuple(leftTuple, context, workingMemory);
    }

    public void doPropagateModifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory, LeftTupleSink sink) {
        sink.modifyLeftTuple(factHandle, modifyPreviousTuples, context, workingMemory);
    }

    @Override
    public void propagateModifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        for (LeftTupleSinkNode sink = this.sinks.getFirst(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            this.doPropagateModifyObject(factHandle, modifyPreviousTuples, context, workingMemory, sink);
        }
    }

    @Override
    public LeftTuple propagateModifyChildLeftTuple(LeftTuple childLeftTuple, RightTuple parentRightTuple, PropagationContext context, InternalWorkingMemory workingMemory, boolean tupleMemoryEnabled) {
        while (childLeftTuple != null && childLeftTuple.getRightParent() == parentRightTuple) {
            LeftTuple temp = childLeftTuple;
            childLeftTuple.modifyTuple(context, workingMemory);
            childLeftTuple = (LeftTuple)childLeftTuple.getHandleNext();
            temp.reAddRight();
        }
        return childLeftTuple;
    }

    @Override
    public LeftTuple propagateModifyChildLeftTuple(LeftTuple childLeftTuple, LeftTuple parentLeftTuple, PropagationContext context, InternalWorkingMemory workingMemory, boolean tupleMemoryEnabled) {
        while (childLeftTuple != null && childLeftTuple.getLeftParent() == parentLeftTuple) {
            LeftTuple temp = childLeftTuple;
            childLeftTuple.modifyTuple(context, workingMemory);
            childLeftTuple = childLeftTuple.getRightParentNext();
            temp.reAddLeft();
        }
        return childLeftTuple;
    }

    @Override
    public void propagateModifyChildLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory, boolean tupleMemoryEnabled) {
        for (LeftTuple childLeftTuple = leftTuple.getFirstChild(); childLeftTuple != null; childLeftTuple = (LeftTuple)childLeftTuple.getHandleNext()) {
            childLeftTuple.modifyTuple(context, workingMemory);
        }
    }

    @Override
    public LeftTuple propagateRetractChildLeftTuple(LeftTuple childLeftTuple, RightTuple parentRightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        while (childLeftTuple != null && childLeftTuple.getRightParent() == parentRightTuple) {
            LeftTuple temp = (LeftTuple)childLeftTuple.getHandleNext();
            childLeftTuple.retractTuple(context, workingMemory);
            childLeftTuple.unlinkFromRightParent();
            childLeftTuple.unlinkFromLeftParent();
            childLeftTuple = temp;
        }
        return childLeftTuple;
    }

    @Override
    public LeftTuple propagateRetractChildLeftTuple(LeftTuple childLeftTuple, LeftTuple parentLeftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        while (childLeftTuple != null && childLeftTuple.getLeftParent() == parentLeftTuple) {
            LeftTuple temp = childLeftTuple.getRightParentNext();
            childLeftTuple.retractTuple(context, workingMemory);
            childLeftTuple.unlinkFromRightParent();
            childLeftTuple.unlinkFromLeftParent();
            childLeftTuple = temp;
        }
        return childLeftTuple;
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        for (LeftTupleSinkNode sink = this.sinks.getFirst(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            sink.modifyLeftTuple(factHandle, modifyPreviousTuples, context, workingMemory);
        }
    }
}

