/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.explorer.backend.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.inject.Inject;
import org.guvnor.common.services.backend.file.LinkedDotFileFilter;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Repository;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.workbench.common.screens.explorer.backend.server.Content;
import org.kie.workbench.common.screens.explorer.backend.server.ExplorerServiceHelper;
import org.kie.workbench.common.screens.explorer.backend.server.UserExplorerData;
import org.kie.workbench.common.screens.explorer.backend.server.UserExplorerLastData;
import org.kie.workbench.common.screens.explorer.model.FolderItem;
import org.kie.workbench.common.screens.explorer.model.FolderItemType;
import org.kie.workbench.common.screens.explorer.model.FolderListing;
import org.kie.workbench.common.screens.explorer.model.ProjectExplorerContent;
import org.kie.workbench.common.screens.explorer.service.ActiveOptions;
import org.kie.workbench.common.screens.explorer.service.Option;
import org.kie.workbench.common.screens.explorer.service.ProjectExplorerContentQuery;
import org.kie.workbench.common.screens.explorer.utils.Sorters;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.Path;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;

public class ProjectExplorerContentResolver {
    private LinkedDotFileFilter dotFileFilter = new LinkedDotFileFilter();
    private KieProjectService projectService;
    private ExplorerServiceHelper helper;
    private AuthorizationManager authorizationManager;
    private OrganizationalUnitService organizationalUnitService;
    private ExplorerServiceHelper explorerServiceHelper;
    @Inject
    protected User identity;

    @Inject
    public ProjectExplorerContentResolver(KieProjectService projectService, ExplorerServiceHelper helper, AuthorizationManager authorizationManager, OrganizationalUnitService organizationalUnitService, ExplorerServiceHelper explorerServiceHelper) {
        this.projectService = projectService;
        this.helper = helper;
        this.authorizationManager = authorizationManager;
        this.organizationalUnitService = organizationalUnitService;
        this.explorerServiceHelper = explorerServiceHelper;
    }

    public ProjectExplorerContent resolve(ProjectExplorerContentQuery query) {
        Content content = this.setupSelectedItems(query);
        this.setSelectedOrganizationalUnit(content);
        this.setSelectedRepository(content);
        this.setSelectedBranch(content);
        this.setSelectedProject(content);
        this.setSelectedPackage(content);
        this.setSelectedItem(content);
        if (content.getSelectedOrganizationalUnit() == null || content.getSelectedRepository() == null || content.getSelectedProject() == null) {
            return this.emptyProjectExplorerContent(content);
        }
        return this.projectExplorerContentWithSelections(content, query.getOptions());
    }

    private ProjectExplorerContent projectExplorerContentWithSelections(final Content content, ActiveOptions options) {
        this.setFolderListing(content, options);
        this.setSiblings(content);
        this.helper.store(content.getSelectedOrganizationalUnit(), content.getSelectedRepository(), content.getSelectedBranch(), content.getSelectedProject(), content.getFolderListing(), content.getSelectedPackage(), options);
        return new ProjectExplorerContent((Set)new TreeSet<OrganizationalUnit>(Sorters.ORGANIZATIONAL_UNIT_SORTER){
            {
                super(x0);
                this.addAll(content.getOrganizationalUnits());
            }
        }, content.getSelectedOrganizationalUnit(), (Set)new TreeSet<Repository>(Sorters.REPOSITORY_SORTER){
            {
                super(x0);
                this.addAll(content.getRepositories().values());
            }
        }, content.getSelectedRepository(), content.getSelectedBranch(), (Set)new TreeSet<Project>(Sorters.PROJECT_SORTER){
            {
                super(x0);
                this.addAll(content.getProjects().values());
            }
        }, content.getSelectedProject(), content.getFolderListing(), content.getSiblings());
    }

    private void setFolderListing(Content content, ActiveOptions options) {
        content.setFolderListing(this.helper.getFolderListing(content.getSelectedItem(), content.getSelectedProject(), content.getSelectedPackage(), options));
    }

    private void setSiblings(Content content) {
        ArrayList<FolderItem> result;
        if (content.getFolderListing().getSegments().size() > 1) {
            ListIterator li = content.getFolderListing().getSegments().listIterator(content.getFolderListing().getSegments().size());
            while (li.hasPrevious()) {
                FolderItem currentItem = (FolderItem)li.previous();
                ArrayList<FolderItem> result2 = new ArrayList<FolderItem>();
                result2.add(currentItem);
                if (currentItem.getItem() instanceof Package) {
                    result2.addAll(this.getSegmentSiblings((Package)currentItem.getItem()));
                } else if (currentItem.getItem() instanceof org.uberfire.backend.vfs.Path) {
                    result2.addAll(this.getSegmentSiblings((org.uberfire.backend.vfs.Path)currentItem.getItem()));
                }
                content.getSiblings().put(currentItem, result2);
            }
        }
        if (content.getSelectedItem() != null && content.getSelectedItem().getType().equals((Object)FolderItemType.FOLDER) && !content.getSiblings().containsKey(content.getSelectedItem())) {
            result = new ArrayList<FolderItem>();
            result.add(content.getSelectedItem());
            if (content.getSelectedItem().getItem() instanceof Package) {
                result.addAll(this.getSegmentSiblings((Package)content.getSelectedItem().getItem()));
            } else if (content.getSelectedItem().getItem() instanceof org.uberfire.backend.vfs.Path) {
                result.addAll(this.getSegmentSiblings((org.uberfire.backend.vfs.Path)content.getSelectedItem().getItem()));
            }
            content.getSiblings().put(content.getSelectedItem(), result);
        }
        if (content.getFolderListing().getItem().getType().equals((Object)FolderItemType.FOLDER) && !content.getSiblings().containsKey(content.getFolderListing().getItem())) {
            result = new ArrayList();
            result.add(content.getFolderListing().getItem());
            if (content.getFolderListing().getItem().getItem() instanceof Package) {
                result.addAll(this.getSegmentSiblings((Package)content.getFolderListing().getItem().getItem()));
            } else if (content.getFolderListing().getItem().getItem() instanceof org.uberfire.backend.vfs.Path) {
                result.addAll(this.getSegmentSiblings((org.uberfire.backend.vfs.Path)content.getFolderListing().getItem().getItem()));
            }
            if (!result.isEmpty()) {
                content.getSiblings().put(content.getFolderListing().getItem(), result);
            }
        }
        for (Map.Entry<FolderItem, List<FolderItem>> e : content.getSiblings().entrySet()) {
            Collections.sort(e.getValue(), Sorters.ITEM_SORTER);
        }
    }

    private ProjectExplorerContent emptyProjectExplorerContent(final Content content) {
        return new ProjectExplorerContent((Set)new TreeSet<OrganizationalUnit>(Sorters.ORGANIZATIONAL_UNIT_SORTER){
            {
                super(x0);
                this.addAll(content.getOrganizationalUnits());
            }
        }, content.getSelectedOrganizationalUnit(), (Set)new TreeSet<Repository>(Sorters.REPOSITORY_SORTER){
            {
                super(x0);
                this.addAll(content.getRepositories().values());
            }
        }, content.getSelectedRepository(), content.getSelectedBranch(), (Set)new TreeSet<Project>(Sorters.PROJECT_SORTER){
            {
                super(x0);
                this.addAll(content.getProjects().values());
            }
        }, content.getSelectedProject(), new FolderListing(null, Collections.emptyList(), Collections.emptyList()), Collections.emptyMap());
    }

    private void setSelectedPackage(Content content) {
        if (content.getSelectedProject() == null) {
            content.setSelectedPackage(null);
        } else {
            Project selectedProject = content.getSelectedProject();
            if (content.getSelectedPackage() != null && !content.getSelectedPackage().getProjectRootPath().equals(selectedProject.getRootPath())) {
                content.setSelectedPackage(null);
                content.setSelectedItem(null);
            }
        }
    }

    private void setSelectedItem(Content content) {
        if (content.getSelectedProject() == null) {
            content.setSelectedItem(null);
        } else {
            Project selectedProject = content.getSelectedProject();
            if (content.getSelectedItem() != null) {
                org.uberfire.backend.vfs.Path itemPath;
                Project owningProject;
                if (content.getSelectedItem().getItem() instanceof Package) {
                    Package pkg = (Package)content.getSelectedItem().getItem();
                    if (!pkg.getProjectRootPath().equals(selectedProject.getRootPath())) {
                        content.setSelectedPackage(null);
                        content.setSelectedItem(null);
                    }
                } else if (content.getSelectedItem().getItem() instanceof org.uberfire.backend.vfs.Path && !(owningProject = this.projectService.resolveProject(itemPath = (org.uberfire.backend.vfs.Path)content.getSelectedItem().getItem())).getRootPath().equals(selectedProject.getRootPath())) {
                    content.setSelectedPackage(null);
                    content.setSelectedItem(null);
                }
            }
        }
    }

    private void setSelectedProject(Content content) {
        content.setProjects(this.getProjects(content.getSelectedRepository(), content.getSelectedBranch()));
        if (content.getSelectedProject() == null || !content.getProjects().containsKey(content.getSelectedProject().getProjectName())) {
            content.setSelectedProject(content.getProjects().isEmpty() ? null : content.getProjects().values().iterator().next());
        } else {
            content.setSelectedProject(content.getProjects().get(content.getSelectedProject().getProjectName()));
        }
    }

    private void setSelectedRepository(Content content) {
        content.setRepositories(this.getRepositories(content.getSelectedOrganizationalUnit()));
        if (content.getSelectedRepository() == null || !content.getRepositories().containsKey(content.getSelectedRepository().getAlias())) {
            content.setSelectedRepository(content.getRepositories().isEmpty() ? null : content.getRepositories().values().iterator().next());
        }
    }

    private void setSelectedBranch(Content content) {
        if (content.getSelectedRepository() == null) {
            return;
        }
        if (!content.getSelectedRepository().getBranches().contains(content.getSelectedBranch())) {
            content.setSelectedBranch(this.getBranch(content));
        }
    }

    private String getBranch(Content content) {
        if (content.getSelectedRepository().getBranches().contains(content.getSelectedBranch())) {
            return content.getSelectedBranch();
        }
        if (content.getSelectedRepository().getBranches().contains("master")) {
            return "master";
        }
        if (content.getSelectedRepository().getBranches().isEmpty()) {
            return null;
        }
        return (String)content.getSelectedRepository().getBranches().iterator().next();
    }

    private boolean isCurrentRepositoryUpToDate(Content content) {
        return !content.getSelectedRepository().equals(content.getRepositories().get(content.getSelectedRepository().getAlias()));
    }

    private void setSelectedOrganizationalUnit(Content content) {
        content.setOrganizationalUnits(this.getOrganizationalUnits());
        if (!content.getOrganizationalUnits().contains(content.getSelectedOrganizationalUnit())) {
            content.setSelectedOrganizationalUnit(content.getOrganizationalUnits().isEmpty() ? null : content.getOrganizationalUnits().iterator().next());
        }
    }

    protected Content setupSelectedItems(ProjectExplorerContentQuery query) {
        Content content = new Content(query);
        UserExplorerLastData lastContent = this.helper.getLastContent();
        UserExplorerData userContent = this.helper.loadUserContent();
        if (!lastContent.isDataEmpty()) {
            if (query.getOrganizationalUnit() == null && query.getRepository() == null && query.getProject() == null) {
                if (query.getOptions().contains(Option.BUSINESS_CONTENT) && lastContent.getLastPackage() != null) {
                    content.setSelectedOrganizationalUnit(lastContent.getLastPackage().getOrganizationalUnit());
                    content.setSelectedRepository(lastContent.getLastPackage().getRepository());
                    content.setSelectedBranch(lastContent.getLastPackage().getBranch());
                    content.setSelectedProject(lastContent.getLastPackage().getProject());
                    content.setSelectedPackage(lastContent.getLastPackage().getPkg());
                    content.setSelectedItem(null);
                } else if (query.getOptions().contains(Option.TECHNICAL_CONTENT) && lastContent.getLastFolderItem() != null) {
                    content.setSelectedOrganizationalUnit(lastContent.getLastFolderItem().getOrganizationalUnit());
                    content.setSelectedRepository(lastContent.getLastFolderItem().getRepository());
                    content.setSelectedBranch(lastContent.getLastPackage().getBranch());
                    content.setSelectedProject(lastContent.getLastFolderItem().getProject());
                    content.setSelectedItem(lastContent.getLastFolderItem().getItem());
                    content.setSelectedPackage(null);
                }
            } else if (query.getOptions().contains(Option.BUSINESS_CONTENT) && lastContent.getLastPackage() != null) {
                if (!query.getOrganizationalUnit().equals(lastContent.getLastPackage().getOrganizationalUnit()) || query.getRepository() != null && !query.getRepository().equals(lastContent.getLastPackage().getRepository()) || query.getBranch() != null && !query.getBranch().equals(lastContent.getLastPackage().getBranch()) || query.getProject() != null && !query.getProject().equals((Object)lastContent.getLastPackage().getProject())) {
                    content.setSelectedOrganizationalUnit(this.loadOrganizationalUnit(query.getOrganizationalUnit(), userContent));
                    content.setSelectedRepository(this.loadRepository(content.getSelectedOrganizationalUnit(), query.getRepository(), userContent));
                    content.setSelectedBranch(this.loadBranch(content.getSelectedOrganizationalUnit(), query.getRepository(), query.getBranch()));
                    content.setSelectedProject(this.loadProject(content.getSelectedOrganizationalUnit(), content.getSelectedRepository(), query.getProject(), userContent));
                    content.setSelectedPackage(this.loadPackage(content.getSelectedOrganizationalUnit(), content.getSelectedRepository(), content.getSelectedProject(), query.getPkg(), userContent));
                    content.setSelectedItem(null);
                } else {
                    content.setSelectedOrganizationalUnit(this.loadOrganizationalUnit(lastContent.getLastPackage().getOrganizationalUnit(), userContent));
                    content.setSelectedRepository(this.loadRepository(content.getSelectedOrganizationalUnit(), lastContent.getLastPackage().getRepository(), userContent));
                    content.setSelectedBranch(this.loadBranch(content.getSelectedOrganizationalUnit(), content.getSelectedRepository(), lastContent.getLastPackage().getBranch()));
                    content.setSelectedProject(this.loadProject(content.getSelectedOrganizationalUnit(), content.getSelectedRepository(), lastContent.getLastPackage().getProject(), userContent));
                    content.setSelectedPackage(this.loadPackage(content.getSelectedOrganizationalUnit(), content.getSelectedRepository(), content.getSelectedProject(), lastContent.getLastPackage().getPkg(), userContent));
                    content.setSelectedItem(null);
                }
            } else if (query.getOptions().contains(Option.TECHNICAL_CONTENT) && lastContent.getLastFolderItem() != null) {
                if (lastContent.getOptions().contains(Option.BUSINESS_CONTENT)) {
                    content.setSelectedOrganizationalUnit(this.loadOrganizationalUnit(lastContent.getLastFolderItem().getOrganizationalUnit(), userContent));
                    content.setSelectedRepository(this.loadRepository(content.getSelectedOrganizationalUnit(), lastContent.getLastFolderItem().getRepository(), userContent));
                    content.setSelectedBranch(this.loadBranch(content.getSelectedOrganizationalUnit(), content.getSelectedRepository(), lastContent.getLastPackage().getBranch()));
                    content.setSelectedProject(this.loadProject(content.getSelectedOrganizationalUnit(), content.getSelectedRepository(), lastContent.getLastFolderItem().getProject(), userContent));
                    content.setSelectedItem(null);
                    content.setSelectedPackage(null);
                } else if (!query.getOrganizationalUnit().equals(lastContent.getLastFolderItem().getOrganizationalUnit()) || query.getRepository() != null && !query.getRepository().equals(lastContent.getLastFolderItem().getRepository()) || query.getProject() != null && !query.getProject().equals((Object)lastContent.getLastFolderItem().getProject())) {
                    content.setSelectedOrganizationalUnit(this.loadOrganizationalUnit(query.getOrganizationalUnit(), userContent));
                    content.setSelectedRepository(this.loadRepository(content.getSelectedOrganizationalUnit(), query.getRepository(), userContent));
                    content.setSelectedBranch(this.loadBranch(content.getSelectedOrganizationalUnit(), content.getSelectedRepository(), query.getBranch()));
                    content.setSelectedProject(this.loadProject(content.getSelectedOrganizationalUnit(), content.getSelectedRepository(), query.getProject(), userContent));
                    content.setSelectedItem(null);
                    content.setSelectedPackage(null);
                } else {
                    content.setSelectedOrganizationalUnit(this.loadOrganizationalUnit(lastContent.getLastFolderItem().getOrganizationalUnit(), userContent));
                    content.setSelectedRepository(this.loadRepository(content.getSelectedOrganizationalUnit(), lastContent.getLastFolderItem().getRepository(), userContent));
                    content.setSelectedBranch(this.loadBranch(content.getSelectedOrganizationalUnit(), content.getSelectedRepository(), lastContent.getLastFolderItem().getBranch()));
                    content.setSelectedProject(this.loadProject(content.getSelectedOrganizationalUnit(), content.getSelectedRepository(), lastContent.getLastFolderItem().getProject(), userContent));
                    content.setSelectedItem(this.loadFolderItem(content.getSelectedOrganizationalUnit(), content.getSelectedRepository(), content.getSelectedProject(), lastContent.getLastFolderItem().getItem(), userContent));
                    content.setSelectedPackage(null);
                }
            }
        }
        return content;
    }

    private List<FolderItem> getSegmentSiblings(org.uberfire.backend.vfs.Path path) {
        ArrayList<FolderItem> result = new ArrayList<FolderItem>();
        Path nioParentPath = Paths.convert((org.uberfire.backend.vfs.Path)path).getParent();
        for (Path sibling : Files.newDirectoryStream((Path)nioParentPath, (DirectoryStream.Filter)this.dotFileFilter)) {
            result.add(this.explorerServiceHelper.toFolderItem(sibling));
        }
        return result;
    }

    private List<FolderItem> getSegmentSiblings(Package pkg) {
        ArrayList<FolderItem> result = new ArrayList<FolderItem>();
        Package parentPkg = this.projectService.resolveParentPackage(pkg);
        if (parentPkg == null) {
            return Collections.emptyList();
        }
        Set siblings = this.projectService.resolvePackages(parentPkg);
        if (siblings != null && !siblings.isEmpty()) {
            for (Package sibling : siblings) {
                if (sibling.equals((Object)pkg)) continue;
                result.add(this.explorerServiceHelper.toFolderItem(sibling));
            }
        }
        return result;
    }

    private OrganizationalUnit loadOrganizationalUnit(OrganizationalUnit organizationalUnit, UserExplorerData content) {
        if (organizationalUnit != null) {
            return organizationalUnit;
        }
        return content.getOrganizationalUnit();
    }

    private Repository loadRepository(OrganizationalUnit organizationalUnit, Repository repository, UserExplorerData content) {
        if (organizationalUnit == null) {
            return null;
        }
        if (repository != null) {
            return repository;
        }
        return content.get(organizationalUnit);
    }

    private String loadBranch(OrganizationalUnit selectedOrganizationalUnit, Repository repository, String branch) {
        if (selectedOrganizationalUnit == null) {
            return null;
        }
        if (repository == null) {
            return null;
        }
        if (branch != null) {
            return branch;
        }
        if (!repository.getBranches().isEmpty()) {
            return (String)repository.getBranches().iterator().next();
        }
        return null;
    }

    private Project loadProject(OrganizationalUnit organizationalUnit, Repository repository, Project project, UserExplorerData content) {
        if (repository == null) {
            return null;
        }
        if (project != null) {
            return project;
        }
        return content.get(organizationalUnit, repository);
    }

    private Package loadPackage(OrganizationalUnit organizationalUnit, Repository repository, Project project, Package pkg, UserExplorerData content) {
        if (project == null) {
            return null;
        }
        if (pkg != null) {
            return pkg;
        }
        return content.getPackage(organizationalUnit, repository, project);
    }

    private FolderItem loadFolderItem(OrganizationalUnit organizationalUnit, Repository repository, Project project, FolderItem item, UserExplorerData content) {
        if (project == null) {
            return null;
        }
        if (item != null) {
            return item;
        }
        return content.getFolderItem(organizationalUnit, repository, project);
    }

    private Set<OrganizationalUnit> getOrganizationalUnits() {
        Collection organizationalUnits = this.organizationalUnitService.getOrganizationalUnits();
        HashSet<OrganizationalUnit> authorizedOrganizationalUnits = new HashSet<OrganizationalUnit>();
        for (OrganizationalUnit organizationalUnit : organizationalUnits) {
            if (!this.authorizationManager.authorize((Resource)organizationalUnit, this.identity)) continue;
            authorizedOrganizationalUnits.add(organizationalUnit);
        }
        return authorizedOrganizationalUnits;
    }

    private Map<String, Repository> getRepositories(OrganizationalUnit organizationalUnit) {
        HashMap<String, Repository> authorizedRepositories = new HashMap<String, Repository>();
        if (organizationalUnit == null) {
            return authorizedRepositories;
        }
        Collection repositories = this.organizationalUnitService.getOrganizationalUnit(organizationalUnit.getName()).getRepositories();
        for (Repository repository : repositories) {
            if (!this.authorizationManager.authorize((Resource)repository, this.identity)) continue;
            authorizedRepositories.put(repository.getAlias(), repository);
        }
        return authorizedRepositories;
    }

    private Map<String, Project> getProjects(Repository repository, String branch) {
        HashMap<String, Project> authorizedProjects = new HashMap<String, Project>();
        if (repository == null) {
            return authorizedProjects;
        }
        Set allProjects = this.projectService.getProjects(repository, branch);
        for (Project project : allProjects) {
            if (!this.authorizationManager.authorize((Resource)project, this.identity)) continue;
            authorizedProjects.put(project.getProjectName(), project);
        }
        return authorizedProjects;
    }
}

