/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server;

import com.thoughtworks.xstream.XStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.backend.server.UserServicesImpl;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileVisitResult;
import org.uberfire.java.nio.file.FileVisitor;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.SimpleFileVisitor;
import org.uberfire.java.nio.file.StandardDeleteOption;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.workbench.model.PerspectiveDefinition;
import org.uberfire.workbench.model.SplashScreenFilter;
import org.uberfire.workbench.services.WorkbenchServices;

@Service
@ApplicationScoped
public class WorkbenchServicesImpl
implements WorkbenchServices {
    public static final String PERSPECTIVE_EXTENSION = ".perspective";
    @Inject
    @Named(value="configIO")
    private IOService ioService;
    @Inject
    private UserServicesImpl userServices;
    private final XStream xs = new XStream();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String perspectiveId, PerspectiveDefinition perspective) {
        String xml = this.xs.toXML((Object)perspective);
        Path perspectivePath = this.userServices.buildPath("perspectives", perspectiveId + PERSPECTIVE_EXTENSION);
        try {
            this.ioService.startBatch(perspectivePath.getFileSystem());
            this.ioService.write(perspectivePath, xml, new OpenOption[0]);
        }
        finally {
            this.ioService.endBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(SplashScreenFilter splashFilter) {
        String xml = this.xs.toXML((Object)splashFilter);
        Path splashFilterPath = this.userServices.buildPath("splash", splashFilter.getName() + ".filter");
        try {
            this.ioService.startBatch(splashFilterPath.getFileSystem());
            this.ioService.write(splashFilterPath, xml, new OpenOption[0]);
        }
        finally {
            this.ioService.endBatch();
        }
    }

    public PerspectiveDefinition loadPerspective(String perspectiveName) {
        Path perspectivePath = this.userServices.buildPath("perspectives", perspectiveName + PERSPECTIVE_EXTENSION);
        if (this.ioService.exists(perspectivePath)) {
            String xml = this.ioService.readAllString(perspectivePath);
            return (PerspectiveDefinition)this.xs.fromXML(xml);
        }
        return null;
    }

    public Set<PerspectiveDefinition> loadPerspectives() {
        final HashSet<PerspectiveDefinition> result = new HashSet<PerspectiveDefinition>();
        Path perspectivesPath = this.userServices.buildPath("perspectives");
        if (this.ioService.exists(perspectivesPath)) {
            Files.walkFileTree((Path)perspectivesPath, (FileVisitor)new SimpleFileVisitor<Path>(){

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        String perspectiveName;
                        PerspectiveDefinition def;
                        PortablePreconditions.checkNotNull((String)"file", (Object)file);
                        PortablePreconditions.checkNotNull((String)"attrs", (Object)attrs);
                        String fileName = file.getFileName().toString();
                        if (fileName.endsWith(WorkbenchServicesImpl.PERSPECTIVE_EXTENSION) && attrs.isRegularFile() && (def = WorkbenchServicesImpl.this.loadPerspective(perspectiveName = fileName.substring(0, fileName.indexOf(WorkbenchServicesImpl.PERSPECTIVE_EXTENSION)))) != null) {
                            result.add(def);
                        }
                    }
                    catch (Exception ex) {
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return result;
    }

    public void removePerspectiveState(String perspectiveId) {
        Path perspectivePath = this.userServices.buildPath("perspectives", perspectiveId + PERSPECTIVE_EXTENSION);
        if (this.ioService.exists(perspectivePath)) {
            this.ioService.delete(perspectivePath, new DeleteOption[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePerspectiveStates() {
        Path perspectivesPath = this.userServices.buildPath("perspectives");
        if (this.ioService.exists(perspectivesPath)) {
            try {
                this.ioService.startBatch(perspectivesPath.getFileSystem());
                this.ioService.delete(perspectivesPath, new DeleteOption[]{StandardDeleteOption.NON_EMPTY_DIRECTORIES});
            }
            finally {
                this.ioService.endBatch();
            }
        }
    }

    public SplashScreenFilter loadSplashScreenFilter(String filterName) {
        Path splashFilterPath = this.userServices.buildPath("splash", filterName + ".filter");
        if (this.ioService.exists(splashFilterPath)) {
            String xml = this.ioService.readAllString(splashFilterPath);
            return (SplashScreenFilter)this.xs.fromXML(xml);
        }
        return null;
    }

    public Map<String, String> loadDefaultEditorsMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Path path = this.getPathToDefaultEditors();
            if (this.ioService.exists(path)) {
                for (String line : this.ioService.readAllLines(path)) {
                    if (line.trim().startsWith("#")) continue;
                    String[] split = line.split("=");
                    map.put(split[0], split[1]);
                }
            }
            return map;
        }
        catch (NoSuchFileException e) {
            e.printStackTrace();
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDefaultEditors(Map<String, String> properties) {
        StringBuilder text = new StringBuilder();
        for (String key : properties.keySet()) {
            text.append(String.format("%s=%s", key, properties.get(key)));
        }
        Path path = this.getPathToDefaultEditors();
        try {
            this.ioService.startBatch(path.getFileSystem());
            this.ioService.write(path, text.toString(), new OpenOption[0]);
        }
        finally {
            this.ioService.endBatch();
        }
    }

    private Path getPathToDefaultEditors() {
        return this.userServices.buildPath("defaultEditors", null);
    }
}

