/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.backend.marshalling.v1_1;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.dmn.api.marshalling.v1_1.DMNMarshaller;
import org.kie.dmn.backend.marshalling.v1_1.DMNMarshallerFactory;
import org.kie.dmn.feel.model.v1_1.Decision;
import org.kie.dmn.feel.model.v1_1.Definitions;
import org.kie.dmn.feel.model.v1_1.InformationRequirement;
import org.kie.dmn.feel.model.v1_1.InputData;
import org.kie.dmn.feel.model.v1_1.LiteralExpression;

public class DMNXMLLoaderTest {
    @Test
    public void testLoadingDefinitions() {
        DMNMarshaller DMNMarshaller2 = DMNMarshallerFactory.newDefaultMarshaller();
        InputStream is = this.getClass().getResourceAsStream("0001-input-data-string.dmn");
        InputStreamReader isr = new InputStreamReader(is);
        Definitions def = DMNMarshaller2.unmarshal((Reader)isr);
        Assert.assertThat((Object)def, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)def.getName(), (Matcher)CoreMatchers.is((Object)"0001-input-data-string"));
        Assert.assertThat((Object)def.getId(), (Matcher)CoreMatchers.is((Object)"_0001-input-data-string"));
        Assert.assertThat((Object)def.getNamespace(), (Matcher)CoreMatchers.is((Object)"https://github.com/agilepro/dmn-tck"));
        Assert.assertThat((Object)def.getDrgElement().size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat(def.getDrgElement().get(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Decision.class)));
        Decision dec = (Decision)def.getDrgElement().get(0);
        Assert.assertThat((Object)dec.getName(), (Matcher)CoreMatchers.is((Object)"Greeting Message"));
        Assert.assertThat((Object)dec.getId(), (Matcher)CoreMatchers.is((Object)"d_GreetingMessage"));
        Assert.assertThat((Object)dec.getVariable().getName(), (Matcher)CoreMatchers.is((Object)"Greeting Message"));
        Assert.assertThat((Object)dec.getVariable().getTypeRef().getPrefix(), (Matcher)CoreMatchers.is((Object)"feel"));
        Assert.assertThat((Object)dec.getVariable().getTypeRef().getLocalPart(), (Matcher)CoreMatchers.is((Object)"string"));
        Assert.assertThat((Object)dec.getVariable().getTypeRef().getNamespaceURI(), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)dec.getInformationRequirement().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((InformationRequirement)dec.getInformationRequirement().get(0)).getRequiredInput().getHref(), (Matcher)CoreMatchers.is((Object)"#i_FullName"));
        Assert.assertThat((Object)dec.getExpression(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(LiteralExpression.class)));
        LiteralExpression le = (LiteralExpression)dec.getExpression();
        Assert.assertThat((Object)le.getText(), (Matcher)CoreMatchers.is((Object)"\"Hello \" + Full Name"));
        InputData idata = (InputData)def.getDrgElement().get(1);
        Assert.assertThat((Object)idata.getId(), (Matcher)CoreMatchers.is((Object)"i_FullName"));
        Assert.assertThat((Object)idata.getName(), (Matcher)CoreMatchers.is((Object)"Full Name"));
        Assert.assertThat((Object)idata.getVariable().getName(), (Matcher)CoreMatchers.is((Object)"Full Name"));
        Assert.assertThat((Object)idata.getVariable().getTypeRef().getPrefix(), (Matcher)CoreMatchers.is((Object)"feel"));
        Assert.assertThat((Object)idata.getVariable().getTypeRef().getLocalPart(), (Matcher)CoreMatchers.is((Object)"string"));
        Assert.assertThat((Object)idata.getVariable().getTypeRef().getNamespaceURI(), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    @Ignore(value="No unmarshaller implemented")
    public void testLoadingExample() {
        Definitions o;
        DMNMarshaller DMNMarshaller2 = DMNMarshallerFactory.newDefaultMarshaller();
        InputStream is = this.getClass().getResourceAsStream("/src/test/resources/ch11example.xml");
        InputStreamReader isr = new InputStreamReader(is);
        Definitions root = o = DMNMarshaller2.unmarshal((Reader)isr);
        Assert.assertNotNull((Object)root);
    }

    @Test
    @Ignore(value="No unmarshaller implemented")
    public void testLoadingDishDecision() {
        Definitions o;
        DMNMarshaller DMNMarshaller2 = DMNMarshallerFactory.newDefaultMarshaller();
        InputStream is = this.getClass().getResourceAsStream("/src/test/resources/dish-decision.xml");
        InputStreamReader isr = new InputStreamReader(is);
        Definitions root = o = DMNMarshaller2.unmarshal((Reader)isr);
        Assert.assertNotNull((Object)root);
    }
}

