/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.backend.marshalling.v1_1.xstream;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.kie.dmn.feel.model.v1_1.Context;
import org.kie.dmn.feel.model.v1_1.DecisionTable;
import org.kie.dmn.feel.model.v1_1.Expression;
import org.kie.dmn.feel.model.v1_1.FunctionDefinition;
import org.kie.dmn.feel.model.v1_1.Invocation;
import org.kie.dmn.feel.model.v1_1.LiteralExpression;
import org.kie.dmn.feel.model.v1_1.Relation;

public class MarshallingUtils {
    private static final Pattern QNAME_PAT = Pattern.compile("((\\{([^\\}]*)\\})?([^:]*):)?(.*)");

    public static QName parseQNameString(String qns) {
        if (qns != null) {
            Matcher m = QNAME_PAT.matcher(qns);
            if (m.matches() && m.group(4) != null) {
                return new QName(m.group(3), m.group(5), m.group(4));
            }
            return new QName(qns);
        }
        return null;
    }

    public static String formatQName(QName qname) {
        if (!"".equals(qname.getPrefix())) {
            return qname.getPrefix() + ":" + qname.getLocalPart();
        }
        return qname.toString();
    }

    public static String defineExpressionNodeName(Expression e) {
        String nodeName = "expression";
        if (e instanceof Context) {
            nodeName = "context";
        } else if (e instanceof DecisionTable) {
            nodeName = "decisionTable";
        } else if (e instanceof FunctionDefinition) {
            nodeName = "functionDefinition";
        } else if (e instanceof Invocation) {
            nodeName = "invocation";
        } else if (e instanceof LiteralExpression) {
            nodeName = "literalExpression";
        } else if (e instanceof Relation) {
            nodeName = "relation";
        }
        return nodeName;
    }
}

