/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.backend.marshalling.v1_1;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashSet;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.dmn.backend.marshalling.v1_1.xstream.XStreamMarshaller;
import org.kie.dmn.model.v1_1.Definitions;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.ComparisonType;
import org.xmlunit.diff.Diff;
import org.xmlunit.diff.DifferenceEvaluator;
import org.xmlunit.diff.DifferenceEvaluators;
import org.xmlunit.validation.ValidationProblem;
import org.xmlunit.validation.ValidationResult;
import org.xmlunit.validation.Validator;

public class UnmarshalMarshalTest {
    @Test
    public void test0001() throws Exception {
        this.testRoundTrip("org/kie/dmn/backend/marshalling/v1_1/", "0001-input-data-string.dmn");
    }

    @Test
    public void test0002() throws Exception {
        this.testRoundTrip("org/kie/dmn/backend/marshalling/v1_1/", "0002-input-data-number.dmn");
    }

    @Test
    public void test0003() throws Exception {
        this.testRoundTrip("org/kie/dmn/backend/marshalling/v1_1/", "0003-input-data-string-allowed-values.dmn");
    }

    @Test
    public void testDish() throws Exception {
        this.testRoundTrip("", "dish-decision.xml");
    }

    @Ignore(value="failing to compare over a xsi:type=\"tImport\" attribute, but why content generated 'control' need to explicit it ?")
    @Test
    public void testDummyDefinitions() throws Exception {
        this.testRoundTrip("", "dummy-definitions.xml");
    }

    @Test
    public void testDummyRelation() throws Exception {
        this.testRoundTrip("", "dummy-relation.xml");
    }

    @Test
    public void testCh11() throws Exception {
        this.testRoundTrip("", "ch11example.xml");
    }

    @Ignore(value="Need first for XMLUnit to reconciliate the namespaces for comparison. ")
    @Test
    public void testSemanticNamespace() throws Exception {
        this.testRoundTrip("", "semantic-namespace.xml");
    }

    @Ignore(value="Need first for XMLUnit to reconciliate the namespaces for comparison. ")
    @Test
    public void test20161014() throws Exception {
        this.testRoundTrip("", "test20161014.xml");
    }

    @Ignore(value="A problem with the StaxDriver has still to be resolved.")
    @Test
    public void testFAILforMissingNamespaces() {
        Assert.fail((String)"PERFORM A MANUAL CHECK: does now the Stax driver do output the namespace for 'feel:' ?? ");
    }

    public void testRoundTrip(String subdir, String xmlfile) throws Exception {
        XStreamMarshaller marshaller = new XStreamMarshaller();
        File baseOutputDir = new File("target/test-xmlunit/");
        File testClassesBaseDir = new File("target/test-classes/");
        File inputXMLFile = new File(testClassesBaseDir, subdir + xmlfile);
        FileInputStream fis = new FileInputStream(inputXMLFile);
        Definitions unmarshal = marshaller.unmarshal((Reader)new InputStreamReader(fis));
        Validator v = Validator.forLanguage((String)"http://www.w3.org/2001/XMLSchema");
        v.setSchemaSource((Source)new StreamSource(this.getClass().getResource("/dmn.xsd").getFile()));
        ValidationResult validateInputResult = v.validateInstance((Source)new StreamSource(inputXMLFile));
        if (!validateInputResult.isValid()) {
            for (ValidationProblem p : validateInputResult.getProblems()) {
                System.err.println(p);
            }
        }
        Assert.assertTrue((boolean)validateInputResult.isValid());
        new File(baseOutputDir, subdir).mkdirs();
        FileOutputStream sourceFos = new FileOutputStream(new File(baseOutputDir, subdir + "a." + xmlfile));
        Files.copy(new File(testClassesBaseDir, subdir + xmlfile).toPath(), sourceFos);
        sourceFos.flush();
        sourceFos.close();
        System.out.println(marshaller.marshal((Object)unmarshal));
        File outputXMLFile = new File(baseOutputDir, subdir + "b." + xmlfile);
        FileWriter targetFos = new FileWriter(outputXMLFile);
        marshaller.marshal((Object)unmarshal, (Writer)targetFos);
        targetFos.flush();
        targetFos.close();
        ValidationResult validateOutputResult = v.validateInstance((Source)new StreamSource(outputXMLFile));
        if (!validateOutputResult.isValid()) {
            for (ValidationProblem p : validateOutputResult.getProblems()) {
                System.err.println(p);
            }
        }
        Assert.assertTrue((boolean)validateOutputResult.isValid());
        System.out.println("\n---\nDefault XMLUnit comparison:");
        Source control = Input.fromFile((File)inputXMLFile).build();
        Source test = Input.fromFile((File)outputXMLFile).build();
        Diff allDiffsSimilarAndDifferent = DiffBuilder.compare((Object)control).withTest((Object)test).build();
        allDiffsSimilarAndDifferent.getDifferences().forEach(System.out::println);
        System.out.println("XMLUnit comparison with customized similarity for defaults:");
        HashSet<QName> attrWhichCanDefault = new HashSet<QName>();
        attrWhichCanDefault.addAll(Arrays.asList(new QName("expressionLanguage"), new QName("typeLanguage"), new QName("isCollection"), new QName("hitPolicy"), new QName("preferredOrientation")));
        HashSet<String> nodeHavingDefaultableAttr = new HashSet<String>();
        nodeHavingDefaultableAttr.addAll(Arrays.asList("definitions", "decisionTable", "itemDefinition", "itemComponent"));
        Diff checkSimilar = DiffBuilder.compare((Object)control).withTest((Object)test).withDifferenceEvaluator(DifferenceEvaluators.chain((DifferenceEvaluator[])new DifferenceEvaluator[]{DifferenceEvaluators.Default, (comparison, outcome) -> {
            if (outcome == ComparisonResult.DIFFERENT && comparison.getType() == ComparisonType.ELEMENT_NUM_ATTRIBUTES && comparison.getControlDetails().getTarget().getNodeName().equals(comparison.getTestDetails().getTarget().getNodeName()) && nodeHavingDefaultableAttr.contains(comparison.getControlDetails().getTarget().getNodeName())) {
                return ComparisonResult.SIMILAR;
            }
            if (outcome == ComparisonResult.DIFFERENT && comparison.getType() == ComparisonType.ATTR_NAME_LOOKUP) {
                boolean testIsDefaulableAttribute = false;
                QName whichDefaultableAttr = null;
                if (comparison.getControlDetails().getValue() == null && attrWhichCanDefault.contains(comparison.getTestDetails().getValue())) {
                    for (QName a : attrWhichCanDefault) {
                        boolean check = comparison.getTestDetails().getXPath().endsWith("@" + a);
                        if (!check) continue;
                        testIsDefaulableAttribute = true;
                        whichDefaultableAttr = a;
                    }
                }
                if (testIsDefaulableAttribute && comparison.getTestDetails().getXPath().equals(comparison.getControlDetails().getXPath() + "/@" + whichDefaultableAttr)) {
                    return ComparisonResult.SIMILAR;
                }
            }
            return outcome;
        }})).ignoreWhitespace().checkForSimilar().build();
        checkSimilar.getDifferences().forEach(System.err::println);
        if (!checkSimilar.getDifferences().iterator().hasNext()) {
            System.out.println("[ EMPTY - no diffs using customized similarity ]");
        }
        Assert.assertFalse((String)("XML are NOT similar: " + checkSimilar.toString()), (boolean)checkSimilar.hasDifferences());
    }
}

