/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.backend.marshalling.v1_2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashSet;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.marshalling.DMNMarshaller;
import org.kie.dmn.backend.marshalling.v1x.XStreamMarshaller;
import org.kie.dmn.model.api.Definitions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.ComparisonType;
import org.xmlunit.diff.Diff;
import org.xmlunit.diff.DifferenceEvaluator;
import org.xmlunit.diff.DifferenceEvaluators;

public class UnmarshalMarshalTest {
    private static final StreamSource DMN12_SCHEMA_SOURCE = null;
    protected static final Logger logger = LoggerFactory.getLogger(UnmarshalMarshalTest.class);

    @Test
    public void testV12_ch11example() throws Exception {
        this.testRoundTripV12("org/kie/dmn/backend/marshalling/v1_2/", "ch11example.dmn");
    }

    @Test
    public void testV12_ImportName() throws Exception {
        this.testRoundTripV12("org/kie/dmn/backend/marshalling/v1_2/", "ImportName.dmn");
    }

    public void testRoundTripV12(String subdir, String xmlfile) throws Exception {
        XStreamMarshaller marshaller = new XStreamMarshaller();
        this.testRoundTrip(subdir, xmlfile, (DMNMarshaller)marshaller, DMN12_SCHEMA_SOURCE);
    }

    public void testRoundTrip(String subdir, String xmlfile, DMNMarshaller marshaller, Source schemaSource) throws Exception {
        File baseOutputDir = new File("target/test-xmlunit/");
        File testClassesBaseDir = new File("target/test-classes/");
        File inputXMLFile = new File(testClassesBaseDir, subdir + xmlfile);
        FileInputStream fis = new FileInputStream(inputXMLFile);
        Definitions unmarshal = marshaller.unmarshal((Reader)new InputStreamReader(fis));
        File subdirFile = new File(baseOutputDir, subdir);
        if (!subdirFile.mkdirs()) {
            logger.warn("mkdirs() failed for File: " + subdirFile.getAbsolutePath() + "!");
        }
        FileOutputStream sourceFos = new FileOutputStream(new File(baseOutputDir, subdir + "a." + xmlfile));
        Files.copy(new File(testClassesBaseDir, subdir + xmlfile).toPath(), sourceFos);
        sourceFos.flush();
        sourceFos.close();
        System.out.println(marshaller.marshal((Object)unmarshal));
        File outputXMLFile = new File(baseOutputDir, subdir + "b." + xmlfile);
        try (FileWriter targetFos = new FileWriter(outputXMLFile);){
            marshaller.marshal((Object)unmarshal, (Writer)targetFos);
        }
        System.out.println("\n---\nDefault XMLUnit comparison:");
        Source control = Input.fromFile((File)inputXMLFile).build();
        Source test = Input.fromFile((File)outputXMLFile).build();
        Diff allDiffsSimilarAndDifferent = DiffBuilder.compare((Object)control).withTest((Object)test).build();
        allDiffsSimilarAndDifferent.getDifferences().forEach(System.out::println);
        System.out.println("XMLUnit comparison with customized similarity for defaults:");
        HashSet<QName> attrWhichCanDefault = new HashSet<QName>();
        attrWhichCanDefault.addAll(Arrays.asList(new QName("expressionLanguage"), new QName("typeLanguage"), new QName("isCollection"), new QName("hitPolicy"), new QName("preferredOrientation"), new QName("kind"), new QName("textFormat"), new QName("associationDirection"), new QName("isCollapsed")));
        HashSet<String> nodeHavingDefaultableAttr = new HashSet<String>();
        nodeHavingDefaultableAttr.addAll(Arrays.asList("definitions", "decisionTable", "itemDefinition", "itemComponent", "encapsulatedLogic", "textAnnotation", "association", "DMNShape"));
        Diff checkSimilar = DiffBuilder.compare((Object)control).withTest((Object)test).withDifferenceEvaluator(DifferenceEvaluators.chain((DifferenceEvaluator[])new DifferenceEvaluator[]{DifferenceEvaluators.Default, (comparison, outcome) -> {
            if (outcome == ComparisonResult.DIFFERENT && comparison.getType() == ComparisonType.ELEMENT_NUM_ATTRIBUTES && comparison.getControlDetails().getTarget().getNodeName().equals(comparison.getTestDetails().getTarget().getNodeName()) && nodeHavingDefaultableAttr.contains(this.safeStripDMNPRefix(comparison.getControlDetails().getTarget()))) {
                return ComparisonResult.SIMILAR;
            }
            if (outcome == ComparisonResult.DIFFERENT && comparison.getType() == ComparisonType.ATTR_VALUE && comparison.getControlDetails().getTarget().getNodeName().equals(comparison.getTestDetails().getTarget().getNodeName()) && comparison.getControlDetails().getTarget().getNodeType() == 2 && comparison.getControlDetails().getTarget().getLocalName().equals("documentation")) {
                return ComparisonResult.SIMILAR;
            }
            if (outcome == ComparisonResult.DIFFERENT && comparison.getType() == ComparisonType.ATTR_NAME_LOOKUP) {
                boolean testIsDefaulableAttribute = false;
                QName whichDefaultableAttr = null;
                if (comparison.getControlDetails().getValue() == null && attrWhichCanDefault.contains(comparison.getTestDetails().getValue())) {
                    for (QName a : attrWhichCanDefault) {
                        boolean check = comparison.getTestDetails().getXPath().endsWith("@" + a);
                        if (!check) continue;
                        testIsDefaulableAttribute = true;
                        whichDefaultableAttr = a;
                    }
                }
                if (testIsDefaulableAttribute && comparison.getTestDetails().getXPath().equals(comparison.getControlDetails().getXPath() + "/@" + whichDefaultableAttr)) {
                    return ComparisonResult.SIMILAR;
                }
            }
            return outcome;
        }})).ignoreWhitespace().checkForSimilar().build();
        checkSimilar.getDifferences().forEach(System.err::println);
        if (!checkSimilar.getDifferences().iterator().hasNext()) {
            System.out.println("[ EMPTY - no diffs using customized similarity ]");
        }
        Assert.assertFalse((String)("XML are NOT similar: " + checkSimilar.toString()), (boolean)checkSimilar.hasDifferences());
    }

    private String safeStripDMNPRefix(Node target) {
        if ("http://www.omg.org/spec/DMN/20180521/MODEL/".equals(target.getNamespaceURI()) || "http://www.omg.org/spec/DMN/20180521/DMNDI/".equals(target.getNamespaceURI())) {
            return target.getLocalName();
        }
        return null;
    }
}

