/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.backend.marshalling;

import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.io.xml.QNameMap;
import com.thoughtworks.xstream.io.xml.StaxReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class CustomStaxReader
extends StaxReader {
    private XMLStreamReader in;

    public CustomStaxReader(QNameMap qnameMap, XMLStreamReader in) {
        super(qnameMap, in);
        this.in = in;
        this.moveDown();
    }

    public Map<String, String> getNsContext() {
        HashMap<String, String> nsContext = new HashMap<String, String>();
        for (int nsIndex = 0; nsIndex < this.in.getNamespaceCount(); ++nsIndex) {
            String nsPrefix = this.in.getNamespacePrefix(nsIndex);
            String nsId = this.in.getNamespaceURI(nsIndex);
            nsContext.put(nsPrefix != null ? nsPrefix : "", nsId);
        }
        return nsContext;
    }

    public Location getLocation() {
        return this.in.getLocation();
    }

    public String getAttribute(String name) {
        return this.getAttribute("", this.encodeAttribute(name));
    }

    public String getAttribute(String namespaceURI, String name) {
        return this.in.getAttributeValue(namespaceURI, this.encodeAttribute(name));
    }

    public Map<QName, String> getAdditionalAttributes() {
        HashMap<QName, String> result = new HashMap<QName, String>();
        for (int aIndex = 0; aIndex < this.in.getAttributeCount(); ++aIndex) {
            String attributePrefix = this.in.getAttributePrefix(aIndex);
            if ("".equals(attributePrefix)) continue;
            result.put(new QName(this.in.getAttributeNamespace(aIndex), this.in.getAttributeLocalName(aIndex), attributePrefix), this.in.getAttributeValue(aIndex));
        }
        return result;
    }

    public void moveDown() {
        if (this.in == null) {
            return;
        }
        super.moveDown();
    }

    protected int pullNextEvent() {
        try {
            switch (this.in.next()) {
                case 1: 
                case 7: {
                    return 1;
                }
                case 2: 
                case 8: {
                    return 2;
                }
                case 4: 
                case 12: {
                    return 3;
                }
                case 5: {
                    return 4;
                }
            }
            return 0;
        }
        catch (XMLStreamException e) {
            throw new StreamException((Throwable)e);
        }
    }
}

