/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.backend.marshalling.v1_2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashSet;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.marshalling.DMNMarshaller;
import org.kie.dmn.backend.marshalling.v1_2.extensions.MyTestRegister;
import org.kie.dmn.backend.marshalling.v1x.DMNMarshallerFactory;
import org.kie.dmn.backend.marshalling.v1x.XStreamMarshaller;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.api.dmndi.DMNDiagram;
import org.kie.dmn.model.api.dmndi.DMNShape;
import org.kie.dmn.model.api.dmndi.DMNStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.ComparisonType;
import org.xmlunit.diff.Diff;
import org.xmlunit.diff.DifferenceEvaluator;
import org.xmlunit.diff.DifferenceEvaluators;
import org.xmlunit.validation.ValidationProblem;
import org.xmlunit.validation.ValidationResult;
import org.xmlunit.validation.Validator;

public class UnmarshalMarshalTest {
    private static final StreamSource DMN12_SCHEMA_SOURCE = new StreamSource(UnmarshalMarshalTest.class.getResource("/DMN12.xsd").getFile());
    private static final DMNMarshaller MARSHALLER = new XStreamMarshaller();
    protected static final Logger logger = LoggerFactory.getLogger(UnmarshalMarshalTest.class);

    @Test
    public void testV12_ch11example() throws Exception {
        this.testRoundTripV12("org/kie/dmn/backend/marshalling/v1_2/", "ch11example.dmn");
    }

    @Test
    public void testV12_ImportName() throws Exception {
        this.testRoundTripV12("org/kie/dmn/backend/marshalling/v1_2/", "ImportName.dmn");
    }

    @Test
    public void testV12_DecisionService20180911v12() throws Exception {
        this.testRoundTripV12("org/kie/dmn/backend/marshalling/v1_2/", "DecisionService20180911v12.dmn");
    }

    @Test
    public void testV12_DiamondWithColors() throws Exception {
        this.testRoundTripV12("org/kie/dmn/backend/marshalling/v1_2/", "diamondWithColors.dmn");
    }

    @Test
    public void testV12_DMNDIDiagramElementExtension() throws Exception {
        this.testRoundTripV12("org/kie/dmn/backend/marshalling/v1_2/", "DMNDIDiagramElementExtension.dmn");
    }

    @Test
    public void testV12_DMNDIDiagramElementExtension_withContent() throws Exception {
        DMNMarshaller marshaller = DMNMarshallerFactory.newMarshallerWithExtensions(Arrays.asList(new MyTestRegister()));
        this.testRoundTrip("org/kie/dmn/backend/marshalling/v1_2/", "DMNDIDiagramElementExtension_withContent.dmn", marshaller, DMN12_SCHEMA_SOURCE);
    }

    @Test
    public void test_hardcoded_java_max_call() throws Exception {
        this.testRoundTripV12("org/kie/dmn/backend/marshalling/v1_2/", "hardcoded-java-max-call.dmn");
    }

    @Test
    public void test_FontSize_sharedStyle() throws Exception {
        this.testRoundTripV12("org/kie/dmn/backend/marshalling/v1_2/", "test-FontSize-sharedStyle.dmn");
        Definitions definitions = MARSHALLER.unmarshal((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test-FontSize-sharedStyle.dmn")));
        DMNShape shape0 = (DMNShape)((DMNDiagram)definitions.getDMNDI().getDMNDiagram().get(0)).getDMNDiagramElement().get(0);
        DMNStyle shape0sharedStyle = (DMNStyle)shape0.getDMNLabel().getSharedStyle();
        Assert.assertEquals((Object)"LS_4d396200-362f-4939-830d-32d2b4c87042_0", (Object)shape0sharedStyle.getId());
        Assert.assertEquals((double)21.0, (double)shape0sharedStyle.getFontSize(), (double)0.0);
    }

    @Test
    public void test_DMNLabel_Text() throws Exception {
        this.testRoundTripV12("org/kie/dmn/backend/marshalling/v1_2/", "DMNLabel-Text.dmn");
    }

    public void testRoundTripV12(String subdir, String xmlfile) throws Exception {
        this.testRoundTrip(subdir, xmlfile, MARSHALLER, DMN12_SCHEMA_SOURCE);
    }

    public void testRoundTrip(String subdir, String xmlfile, DMNMarshaller marshaller, Source schemaSource) throws Exception {
        File baseOutputDir = new File("target/test-xmlunit/");
        File testClassesBaseDir = new File("target/test-classes/");
        File inputXMLFile = new File(testClassesBaseDir, subdir + xmlfile);
        FileInputStream fis = new FileInputStream(inputXMLFile);
        Definitions unmarshal = marshaller.unmarshal((Reader)new InputStreamReader(fis));
        Validator v = Validator.forLanguage((String)"http://www.w3.org/2001/XMLSchema");
        v.setSchemaSource(schemaSource);
        ValidationResult validateInputResult = v.validateInstance((Source)new StreamSource(inputXMLFile));
        if (!validateInputResult.isValid()) {
            for (ValidationProblem p : validateInputResult.getProblems()) {
                System.err.println(p);
            }
        }
        Assert.assertTrue((boolean)validateInputResult.isValid());
        File subdirFile = new File(baseOutputDir, subdir);
        if (!subdirFile.mkdirs()) {
            logger.warn("mkdirs() failed for File: " + subdirFile.getAbsolutePath() + "!");
        }
        FileOutputStream sourceFos = new FileOutputStream(new File(baseOutputDir, subdir + "a." + xmlfile));
        Files.copy(new File(testClassesBaseDir, subdir + xmlfile).toPath(), sourceFos);
        sourceFos.flush();
        sourceFos.close();
        System.out.println(marshaller.marshal((Object)unmarshal));
        File outputXMLFile = new File(baseOutputDir, subdir + "b." + xmlfile);
        FileWriter targetFos = new FileWriter(outputXMLFile);
        Object object = null;
        try {
            marshaller.marshal((Object)unmarshal, (Writer)targetFos);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (targetFos != null) {
                if (object != null) {
                    try {
                        targetFos.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    targetFos.close();
                }
            }
        }
        ValidationResult validateOutputResult = v.validateInstance((Source)new StreamSource(outputXMLFile));
        if (!validateOutputResult.isValid()) {
            for (ValidationProblem p : validateOutputResult.getProblems()) {
                System.err.println(p);
            }
        }
        Assert.assertTrue((boolean)validateOutputResult.isValid());
        System.out.println("\n---\nDefault XMLUnit comparison:");
        Source control = Input.fromFile((File)inputXMLFile).build();
        Source test = Input.fromFile((File)outputXMLFile).build();
        Diff allDiffsSimilarAndDifferent = DiffBuilder.compare((Object)control).withTest((Object)test).build();
        allDiffsSimilarAndDifferent.getDifferences().forEach(System.out::println);
        System.out.println("XMLUnit comparison with customized similarity for defaults:");
        HashSet<QName> attrWhichCanDefault = new HashSet<QName>();
        attrWhichCanDefault.addAll(Arrays.asList(new QName("expressionLanguage"), new QName("typeLanguage"), new QName("isCollection"), new QName("hitPolicy"), new QName("preferredOrientation"), new QName("kind"), new QName("textFormat"), new QName("associationDirection"), new QName("isCollapsed")));
        HashSet<String> nodeHavingDefaultableAttr = new HashSet<String>();
        nodeHavingDefaultableAttr.addAll(Arrays.asList("definitions", "decisionTable", "itemDefinition", "itemComponent", "encapsulatedLogic", "textAnnotation", "association", "DMNShape"));
        Diff checkSimilar = DiffBuilder.compare((Object)control).withTest((Object)test).withDifferenceEvaluator(DifferenceEvaluators.chain((DifferenceEvaluator[])new DifferenceEvaluator[]{DifferenceEvaluators.Default, (comparison, outcome) -> {
            if (outcome == ComparisonResult.DIFFERENT && comparison.getType() == ComparisonType.ELEMENT_NUM_ATTRIBUTES && comparison.getControlDetails().getTarget().getNodeName().equals(comparison.getTestDetails().getTarget().getNodeName()) && nodeHavingDefaultableAttr.contains(this.safeStripDMNPRefix(comparison.getControlDetails().getTarget()))) {
                return ComparisonResult.SIMILAR;
            }
            if (outcome == ComparisonResult.DIFFERENT && comparison.getType() == ComparisonType.ATTR_VALUE && comparison.getControlDetails().getTarget().getNodeName().equals(comparison.getTestDetails().getTarget().getNodeName()) && comparison.getControlDetails().getTarget().getNodeType() == 2 && comparison.getControlDetails().getTarget().getLocalName().equals("documentation")) {
                return ComparisonResult.SIMILAR;
            }
            if (outcome == ComparisonResult.DIFFERENT && comparison.getType() == ComparisonType.ATTR_NAME_LOOKUP) {
                boolean testIsDefaulableAttribute = false;
                QName whichDefaultableAttr = null;
                if (comparison.getControlDetails().getValue() == null && attrWhichCanDefault.contains(comparison.getTestDetails().getValue())) {
                    for (QName a : attrWhichCanDefault) {
                        boolean check = comparison.getTestDetails().getXPath().endsWith("@" + a);
                        if (!check) continue;
                        testIsDefaulableAttribute = true;
                        whichDefaultableAttr = a;
                    }
                }
                if (testIsDefaulableAttribute && comparison.getTestDetails().getXPath().equals(comparison.getControlDetails().getXPath() + "/@" + whichDefaultableAttr)) {
                    return ComparisonResult.SIMILAR;
                }
            }
            return outcome;
        }})).ignoreWhitespace().checkForSimilar().build();
        checkSimilar.getDifferences().forEach(System.err::println);
        if (!checkSimilar.getDifferences().iterator().hasNext()) {
            System.out.println("[ EMPTY - no diffs using customized similarity ]");
        }
        Assert.assertFalse((String)("XML are NOT similar: " + checkSimilar.toString()), (boolean)checkSimilar.hasDifferences());
    }

    private String safeStripDMNPRefix(Node target) {
        if ("http://www.omg.org/spec/DMN/20180521/MODEL/".equals(target.getNamespaceURI()) || "http://www.omg.org/spec/DMN/20180521/DMNDI/".equals(target.getNamespaceURI())) {
            return target.getLocalName();
        }
        return null;
    }
}

