/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.backend.marshalling.v1_1;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.marshalling.DMNMarshaller;
import org.kie.dmn.backend.marshalling.v1_1.xstream.extensions.DecisionServicesExtensionRegister;
import org.kie.dmn.backend.marshalling.v1x.DMNMarshallerFactory;
import org.kie.dmn.model.api.DMNElementReference;
import org.kie.dmn.model.api.Decision;
import org.kie.dmn.model.api.DecisionService;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.api.InformationRequirement;
import org.kie.dmn.model.api.InputData;
import org.kie.dmn.model.api.LiteralExpression;

public class DMNXMLLoaderTest {
    @Test
    public void testLoadingDefinitions() {
        DMNMarshaller DMNMarshaller2 = DMNMarshallerFactory.newDefaultMarshaller();
        InputStream is = this.getClass().getResourceAsStream("0001-input-data-string.dmn");
        InputStreamReader isr = new InputStreamReader(is);
        Definitions def = DMNMarshaller2.unmarshal((Reader)isr);
        Assert.assertThat((Object)def, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)def.getName(), (Matcher)CoreMatchers.is((Object)"0001-input-data-string"));
        Assert.assertThat((Object)def.getId(), (Matcher)CoreMatchers.is((Object)"_0001-input-data-string"));
        Assert.assertThat((Object)def.getNamespace(), (Matcher)CoreMatchers.is((Object)"https://github.com/agilepro/dmn-tck"));
        Assert.assertThat((Object)def.getDrgElement().size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat(def.getDrgElement().get(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Decision.class)));
        Decision dec = (Decision)def.getDrgElement().get(0);
        Assert.assertThat((Object)dec.getName(), (Matcher)CoreMatchers.is((Object)"Greeting Message"));
        Assert.assertThat((Object)dec.getId(), (Matcher)CoreMatchers.is((Object)"d_GreetingMessage"));
        Assert.assertThat((Object)dec.getVariable().getName(), (Matcher)CoreMatchers.is((Object)"Greeting Message"));
        Assert.assertThat((Object)dec.getVariable().getTypeRef().getPrefix(), (Matcher)CoreMatchers.is((Object)"feel"));
        Assert.assertThat((Object)dec.getVariable().getTypeRef().getLocalPart(), (Matcher)CoreMatchers.is((Object)"string"));
        Assert.assertThat((Object)dec.getVariable().getTypeRef().getNamespaceURI(), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)dec.getInformationRequirement().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((InformationRequirement)dec.getInformationRequirement().get(0)).getRequiredInput().getHref(), (Matcher)CoreMatchers.is((Object)"#i_FullName"));
        Assert.assertThat((Object)dec.getExpression(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(LiteralExpression.class)));
        LiteralExpression le = (LiteralExpression)dec.getExpression();
        Assert.assertThat((Object)le.getText(), (Matcher)CoreMatchers.is((Object)"\"Hello \" + Full Name"));
        InputData idata = (InputData)def.getDrgElement().get(1);
        Assert.assertThat((Object)idata.getId(), (Matcher)CoreMatchers.is((Object)"i_FullName"));
        Assert.assertThat((Object)idata.getName(), (Matcher)CoreMatchers.is((Object)"Full Name"));
        Assert.assertThat((Object)idata.getVariable().getName(), (Matcher)CoreMatchers.is((Object)"Full Name"));
        Assert.assertThat((Object)idata.getVariable().getTypeRef().getPrefix(), (Matcher)CoreMatchers.is((Object)"feel"));
        Assert.assertThat((Object)idata.getVariable().getTypeRef().getLocalPart(), (Matcher)CoreMatchers.is((Object)"string"));
        Assert.assertThat((Object)idata.getVariable().getTypeRef().getNamespaceURI(), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void testLoadingDecisionServices() {
        DMNMarshaller DMNMarshaller2 = DMNMarshallerFactory.newMarshallerWithExtensions(Arrays.asList(new DecisionServicesExtensionRegister()));
        InputStream is = this.getClass().getResourceAsStream("0004-decision-services.dmn");
        InputStreamReader isr = new InputStreamReader(is);
        Definitions def = DMNMarshaller2.unmarshal((Reader)isr);
        Assert.assertThat((Object)def.getDecisionService().size(), (Matcher)CoreMatchers.is((Object)2));
        DecisionService decisionService1 = (DecisionService)def.getDecisionService().get(0);
        Assert.assertThat((Object)decisionService1.getId(), (Matcher)CoreMatchers.is((Object)"_70386614-9838-420b-a2ae-ff901ada63fb"));
        Assert.assertThat((Object)decisionService1.getName(), (Matcher)CoreMatchers.is((Object)"A Only Knowing B and C"));
        Assert.assertThat((Object)decisionService1.getDescription(), (Matcher)CoreMatchers.is((Object)"Description of A (BC)"));
        Assert.assertThat((Object)decisionService1.getOutputDecision().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)decisionService1.getEncapsulatedDecision().size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)decisionService1.getInputDecision().size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)decisionService1.getInputData().size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)((DMNElementReference)decisionService1.getOutputDecision().get(0)).getHref(), (Matcher)CoreMatchers.is((Object)"#_c2b44706-d479-4ceb-bb74-73589d26dd04"));
        DecisionService decisionService2 = (DecisionService)def.getDecisionService().get(1);
        Assert.assertThat((Object)decisionService2.getId(), (Matcher)CoreMatchers.is((Object)"_4620ef13-248a-419e-bc68-6b601b725a03"));
        Assert.assertThat((Object)decisionService2.getName(), (Matcher)CoreMatchers.is((Object)"A only as output knowing D and E"));
        Assert.assertThat((Object)decisionService2.getOutputDecision().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)decisionService2.getEncapsulatedDecision().size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)decisionService2.getInputDecision().size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)decisionService2.getInputData().size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((DMNElementReference)decisionService2.getInputData().get(0)).getHref(), (Matcher)CoreMatchers.is((Object)"#_bcea16fb-6c19-4bde-b37d-73407002c064"));
        Assert.assertThat((Object)((DMNElementReference)decisionService2.getInputData().get(1)).getHref(), (Matcher)CoreMatchers.is((Object)"#_207b9195-a441-47f2-9414-2fad64b463f9"));
    }

    @Test
    public void testLoadingWithNoDecisionServices() {
        DMNMarshaller DMNMarshaller2 = DMNMarshallerFactory.newMarshallerWithExtensions(Arrays.asList(new DecisionServicesExtensionRegister()));
        InputStream is = this.getClass().getResourceAsStream("0001-input-data-string.dmn");
        InputStreamReader isr = new InputStreamReader(is);
        Definitions def = DMNMarshaller2.unmarshal((Reader)isr);
        Assert.assertThat((Object)def.getDecisionService().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void test0004_multiple_extensions() throws Exception {
        DMNMarshaller marshaller = DMNMarshallerFactory.newMarshallerWithExtensions(Arrays.asList(new DecisionServicesExtensionRegister()));
        InputStream is = this.getClass().getResourceAsStream("0004-decision-services_multiple_extensions.dmn");
        InputStreamReader isr = new InputStreamReader(is);
        Definitions def = marshaller.unmarshal((Reader)isr);
        Assert.assertThat((Object)def.getExtensionElements().getAny().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testLoadingExample() {
        Definitions o;
        DMNMarshaller DMNMarshaller2 = DMNMarshallerFactory.newDefaultMarshaller();
        InputStream is = this.getClass().getResourceAsStream("ch11example.xml");
        InputStreamReader isr = new InputStreamReader(is);
        Definitions root = o = DMNMarshaller2.unmarshal((Reader)isr);
        Assert.assertNotNull((Object)root);
    }

    @Test
    public void testLoadingDishDecision() {
        Definitions o;
        DMNMarshaller DMNMarshaller2 = DMNMarshallerFactory.newDefaultMarshaller();
        InputStream is = this.getClass().getResourceAsStream("dish-decision.xml");
        InputStreamReader isr = new InputStreamReader(is);
        Definitions root = o = DMNMarshaller2.unmarshal((Reader)isr);
        Assert.assertNotNull((Object)root);
    }
}

