/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.backend.marshalling.v1_1;

import javax.xml.namespace.QName;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.backend.marshalling.v1_1.xstream.MarshallingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarshallingUtilsTest {
    protected static final Logger logger = LoggerFactory.getLogger(MarshallingUtilsTest.class);

    private void checkAndRoundTrip(QName qname, String formatQName) {
        String formatted = MarshallingUtils.formatQName((QName)qname);
        Assertions.assertThat((String)formatted).isEqualTo(formatQName);
        QName roundTrip = MarshallingUtils.parseQNameString((String)formatted);
        Assertions.assertThat((String)roundTrip.getLocalPart()).isEqualTo(qname.getLocalPart());
        if (roundTrip.getPrefix() != "") {
            Assertions.assertThat((String)roundTrip.getPrefix()).isEqualTo(qname.getPrefix());
        }
        if (roundTrip.getNamespaceURI() != "") {
            Assertions.assertThat((String)roundTrip.getNamespaceURI()).isEqualTo(qname.getNamespaceURI());
        }
    }

    @Test
    public void testLocal() throws Exception {
        QName qname = new QName("local1");
        this.checkAndRoundTrip(qname, "local1");
    }

    @Test
    public void testPrefixLocal() throws Exception {
        QName qname = new QName("", "local2", "prefix");
        this.checkAndRoundTrip(qname, "prefix:local2");
    }

    @Test
    public void testNamespaceLocal() throws Exception {
        QName qname = new QName("http://namespace", "local3");
        this.checkAndRoundTrip(qname, "{http://namespace}local3");
    }

    @Test
    public void testNamespaceLocal_b() throws Exception {
        QName qname = new QName("http://namespace", "local3", "");
        this.checkAndRoundTrip(qname, "{http://namespace}local3");
    }

    @Test
    public void testNamespacePrefixLocal() throws Exception {
        QName qname = new QName("http://namespace", "local4", "prefix");
        this.checkAndRoundTrip(qname, "prefix:local4");
    }
}

