/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.backend.marshalling.v1_1;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.marshalling.DMNMarshaller;
import org.kie.dmn.backend.marshalling.v1_1.xstream.extensions.DecisionServicesExtensionRegister;
import org.kie.dmn.backend.marshalling.v1x.DMNMarshallerFactory;
import org.kie.dmn.model.api.DMNElementReference;
import org.kie.dmn.model.api.DRGElement;
import org.kie.dmn.model.api.Decision;
import org.kie.dmn.model.api.DecisionService;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.api.InformationRequirement;
import org.kie.dmn.model.api.InputData;
import org.kie.dmn.model.api.LiteralExpression;

public class DMNXMLLoaderTest {
    @Test
    public void testLoadingDefinitions() {
        DMNMarshaller DMNMarshaller2 = DMNMarshallerFactory.newDefaultMarshaller();
        InputStream is = this.getClass().getResourceAsStream("0001-input-data-string.dmn");
        InputStreamReader isr = new InputStreamReader(is);
        Definitions def = DMNMarshaller2.unmarshal((Reader)isr);
        Assertions.assertThat((Object)def).isNotNull();
        Assertions.assertThat((String)def.getName()).isEqualTo("0001-input-data-string");
        Assertions.assertThat((String)def.getId()).isEqualTo("_0001-input-data-string");
        Assertions.assertThat((String)def.getNamespace()).isEqualTo("https://github.com/agilepro/dmn-tck");
        Assertions.assertThat((List)def.getDrgElement()).hasSize(2);
        Assertions.assertThat((Object)((DRGElement)def.getDrgElement().get(0))).isInstanceOf(Decision.class);
        Decision dec = (Decision)def.getDrgElement().get(0);
        Assertions.assertThat((String)dec.getName()).isEqualTo("Greeting Message");
        Assertions.assertThat((String)dec.getId()).isEqualTo("d_GreetingMessage");
        Assertions.assertThat((String)dec.getVariable().getName()).isEqualTo("Greeting Message");
        Assertions.assertThat((String)dec.getVariable().getTypeRef().getPrefix()).isEqualTo("feel");
        Assertions.assertThat((String)dec.getVariable().getTypeRef().getLocalPart()).isEqualTo("string");
        Assertions.assertThat((String)dec.getVariable().getTypeRef().getNamespaceURI()).isEqualTo("");
        Assertions.assertThat((List)dec.getInformationRequirement()).hasSize(1);
        Assertions.assertThat((String)((InformationRequirement)dec.getInformationRequirement().get(0)).getRequiredInput().getHref()).isEqualTo("#i_FullName");
        Assertions.assertThat((Object)dec.getExpression()).isInstanceOf(LiteralExpression.class);
        LiteralExpression le = (LiteralExpression)dec.getExpression();
        Assertions.assertThat((String)le.getText()).isEqualTo("\"Hello \" + Full Name");
        InputData idata = (InputData)def.getDrgElement().get(1);
        Assertions.assertThat((String)idata.getId()).isEqualTo("i_FullName");
        Assertions.assertThat((String)idata.getName()).isEqualTo("Full Name");
        Assertions.assertThat((String)idata.getVariable().getName()).isEqualTo("Full Name");
        Assertions.assertThat((String)idata.getVariable().getTypeRef().getPrefix()).isEqualTo("feel");
        Assertions.assertThat((String)idata.getVariable().getTypeRef().getLocalPart()).isEqualTo("string");
        Assertions.assertThat((String)idata.getVariable().getTypeRef().getNamespaceURI()).isEqualTo("");
    }

    @Test
    public void testLoadingDecisionServices() {
        DMNMarshaller DMNMarshaller2 = DMNMarshallerFactory.newMarshallerWithExtensions(List.of(new DecisionServicesExtensionRegister()));
        InputStream is = this.getClass().getResourceAsStream("0004-decision-services.dmn");
        InputStreamReader isr = new InputStreamReader(is);
        Definitions def = DMNMarshaller2.unmarshal((Reader)isr);
        Assertions.assertThat((List)def.getDecisionService()).hasSize(2);
        DecisionService decisionService1 = (DecisionService)def.getDecisionService().get(0);
        Assertions.assertThat((String)decisionService1.getId()).isEqualTo("_70386614-9838-420b-a2ae-ff901ada63fb");
        Assertions.assertThat((String)decisionService1.getName()).isEqualTo("A Only Knowing B and C");
        Assertions.assertThat((String)decisionService1.getDescription()).isEqualTo("Description of A (BC)");
        Assertions.assertThat((List)decisionService1.getOutputDecision()).hasSize(1);
        Assertions.assertThat((List)decisionService1.getEncapsulatedDecision()).hasSize(0);
        Assertions.assertThat((List)decisionService1.getInputDecision()).hasSize(2);
        Assertions.assertThat((List)decisionService1.getInputData()).hasSize(0);
        Assertions.assertThat((String)((DMNElementReference)decisionService1.getOutputDecision().get(0)).getHref()).isEqualTo("#_c2b44706-d479-4ceb-bb74-73589d26dd04");
        DecisionService decisionService2 = (DecisionService)def.getDecisionService().get(1);
        Assertions.assertThat((String)decisionService2.getId()).isEqualTo("_4620ef13-248a-419e-bc68-6b601b725a03");
        Assertions.assertThat((String)decisionService2.getName()).isEqualTo("A only as output knowing D and E");
        Assertions.assertThat((List)decisionService2.getOutputDecision()).hasSize(1);
        Assertions.assertThat((List)decisionService2.getEncapsulatedDecision()).hasSize(2);
        Assertions.assertThat((List)decisionService2.getInputDecision()).hasSize(0);
        Assertions.assertThat((List)decisionService2.getInputData()).hasSize(2);
        Assertions.assertThat((String)((DMNElementReference)decisionService2.getInputData().get(0)).getHref()).isEqualTo("#_bcea16fb-6c19-4bde-b37d-73407002c064");
        Assertions.assertThat((String)((DMNElementReference)decisionService2.getInputData().get(1)).getHref()).isEqualTo("#_207b9195-a441-47f2-9414-2fad64b463f9");
    }

    @Test
    public void testLoadingWithNoDecisionServices() {
        DMNMarshaller DMNMarshaller2 = DMNMarshallerFactory.newMarshallerWithExtensions(List.of(new DecisionServicesExtensionRegister()));
        InputStream is = this.getClass().getResourceAsStream("0001-input-data-string.dmn");
        InputStreamReader isr = new InputStreamReader(is);
        Definitions def = DMNMarshaller2.unmarshal((Reader)isr);
        Assertions.assertThat((List)def.getDecisionService()).hasSize(0);
    }

    @Test
    public void test0004_multiple_extensions() throws Exception {
        DMNMarshaller marshaller = DMNMarshallerFactory.newMarshallerWithExtensions(List.of(new DecisionServicesExtensionRegister()));
        InputStream is = this.getClass().getResourceAsStream("0004-decision-services_multiple_extensions.dmn");
        InputStreamReader isr = new InputStreamReader(is);
        Definitions def = marshaller.unmarshal((Reader)isr);
        Assertions.assertThat((List)def.getExtensionElements().getAny()).hasSize(1);
    }

    @Test
    public void testLoadingExample() {
        Definitions o;
        DMNMarshaller DMNMarshaller2 = DMNMarshallerFactory.newDefaultMarshaller();
        InputStream is = this.getClass().getResourceAsStream("ch11example.xml");
        InputStreamReader isr = new InputStreamReader(is);
        Definitions root = o = DMNMarshaller2.unmarshal((Reader)isr);
        Assertions.assertThat((Object)root).isNotNull();
    }

    @Test
    public void testLoadingDishDecision() {
        Definitions o;
        DMNMarshaller DMNMarshaller2 = DMNMarshallerFactory.newDefaultMarshaller();
        InputStream is = this.getClass().getResourceAsStream("dish-decision.xml");
        InputStreamReader isr = new InputStreamReader(is);
        Definitions root = o = DMNMarshaller2.unmarshal((Reader)isr);
        Assertions.assertThat((Object)root).isNotNull();
    }
}

