/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.codegen.feel11;

import org.kie.dmn.feel.lang.ast.InfixOpNode;
import org.kie.dmn.feel.util.AssignableFromUtil;

public abstract class CompiledFEELSemanticMappings {
    private static boolean compatible(Comparable left, Comparable right) {
        Class<?> rightClass;
        Class<?> leftClass = left.getClass();
        return AssignableFromUtil.isAssignableFrom(leftClass, rightClass = right.getClass()) || AssignableFromUtil.isAssignableFrom(rightClass, leftClass);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> T coerceTo(Class<?> paramType, Object value) {
        Object actual;
        if (AssignableFromUtil.isAssignableFrom(paramType, value.getClass())) {
            actual = value;
            return (T)actual;
        } else if (value instanceof Number) {
            if (paramType == Byte.TYPE || paramType == Byte.class) {
                actual = ((Number)value).byteValue();
                return (T)actual;
            } else if (paramType == Short.TYPE || paramType == Short.class) {
                actual = ((Number)value).shortValue();
                return (T)actual;
            } else if (paramType == Integer.TYPE || paramType == Integer.class) {
                actual = ((Number)value).intValue();
                return (T)actual;
            } else if (paramType == Long.TYPE || paramType == Long.class) {
                actual = ((Number)value).longValue();
                return (T)actual;
            } else if (paramType == Float.TYPE || paramType == Float.class) {
                actual = Float.valueOf(((Number)value).floatValue());
                return (T)actual;
            } else if (paramType == Double.TYPE || paramType == Double.class) {
                actual = ((Number)value).doubleValue();
                return (T)actual;
            } else {
                if (paramType != Object[].class) throw new IllegalArgumentException("Unable to coerce parameter " + value + ". Expected " + paramType + " but found " + value.getClass());
                actual = new Object[]{value};
            }
            return (T)actual;
        } else if (value instanceof String && ((String)value).length() == 1 && (paramType == Character.TYPE || paramType == Character.class)) {
            actual = Character.valueOf(((String)value).charAt(0));
            return (T)actual;
        } else {
            if (!(value instanceof Boolean) || paramType != Boolean.TYPE) throw new IllegalArgumentException("Unable to coerce parameter " + value + ". Expected " + paramType + " but found " + value.getClass());
            actual = value;
        }
        return (T)actual;
    }

    public static Object pow(Object left, Object right) {
        return InfixOpNode.math(left, right, null, (l, r) -> l.pow(r.intValue()));
    }
}

