/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.parser.feel11;

import com.google.gwt.regexp.shared.RegExp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.lang.FEELProfile;
import org.kie.dmn.feel.lang.Scope;
import org.kie.dmn.feel.lang.Symbol;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.impl.FEELEventListenersManager;
import org.kie.dmn.feel.lang.types.BuiltInTypeSymbol;
import org.kie.dmn.feel.lang.types.FEELTypeRegistry;
import org.kie.dmn.feel.parser.feel11.FEELErrorHandler;
import org.kie.dmn.feel.parser.feel11.FEELParserErrorListener;
import org.kie.dmn.feel.parser.feel11.FEEL_1_1Lexer;
import org.kie.dmn.feel.parser.feel11.FEEL_1_1Parser;
import org.kie.dmn.feel.parser.feel11.ParserHelper;
import org.kie.dmn.feel.runtime.FEELFunction;
import org.kie.dmn.feel.runtime.events.SyntaxErrorEvent;
import org.kie.dmn.feel.util.Msg;

public class FEELParser {
    static final List<String> REUSABLE_KEYWORDS = Arrays.asList("for", "return", "if", "then", "else", "some", "every", "satisfies", "instance", "of", "function", "external", "or", "and", "between", "not", "null", "true", "false");
    private static final RegExp DIGITS_PATTERN = RegExp.compile((String)"[0-9]*");

    public static FEEL_1_1Parser parse(FEELEventListenersManager eventsManager, String source, Map<String, Type> inputVariableTypes, Map<String, Object> inputVariables, Collection<FEELFunction> additionalFunctions, List<FEELProfile> profiles, FEELTypeRegistry typeRegistry) {
        CharStream input = CharStreams.fromString((String)source);
        FEEL_1_1Lexer lexer = new FEEL_1_1Lexer(input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        FEEL_1_1Parser parser = new FEEL_1_1Parser((TokenStream)tokens);
        ParserHelper parserHelper = new ParserHelper(eventsManager);
        additionalFunctions.forEach(f -> parserHelper.getSymbolTable().getBuiltInScope().define(f.getSymbol()));
        parser.setHelper(parserHelper);
        parser.setErrorHandler((ANTLRErrorStrategy)new FEELErrorHandler());
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new FEELParserErrorListener(eventsManager));
        FEELParser.defineVariables(inputVariableTypes, inputVariables, parser);
        if (typeRegistry != null) {
            parserHelper.setTypeRegistry(typeRegistry);
        }
        return parser;
    }

    public static boolean isVariableNamePartValid(String namePart, Scope scope) {
        if (DIGITS_PATTERN.exec(namePart) != null) {
            return true;
        }
        if (REUSABLE_KEYWORDS.contains(namePart)) {
            return scope.followUp(namePart, true);
        }
        return FEELParser.isVariableNameValid(namePart);
    }

    public static boolean isVariableNameValid(String source) {
        return FEELParser.checkVariableName(source).isEmpty();
    }

    public static List<FEELEvent> checkVariableName(String source) {
        if (source == null || source.isEmpty()) {
            return Collections.singletonList(new SyntaxErrorEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.INVALID_VARIABLE_NAME_EMPTY), null, 0, 0, null));
        }
        CharStream input = CharStreams.fromString((String)source);
        FEEL_1_1Lexer lexer = new FEEL_1_1Lexer(input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        FEEL_1_1Parser parser = new FEEL_1_1Parser((TokenStream)tokens);
        parser.setHelper(new ParserHelper());
        parser.setErrorHandler((ANTLRErrorStrategy)new FEELErrorHandler());
        FEELParserErrorListener errorChecker = new FEELParserErrorListener(null);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorChecker);
        FEEL_1_1Parser.NameDefinitionWithEOFContext nameDef = parser.nameDefinitionWithEOF();
        if (!errorChecker.hasErrors() && nameDef != null) {
            String string = source.trim();
            parser.getHelper();
            if (string.equals(ParserHelper.getOriginalText((ParserRuleContext)nameDef))) {
                return Collections.emptyList();
            }
        }
        return errorChecker.getErrors();
    }

    public static void defineVariables(Map<String, Type> inputVariableTypes, Map<String, Object> inputVariables, FEEL_1_1Parser parser) {
        inputVariableTypes.forEach((name, type) -> {
            parser.getHelper().defineVariable((String)name, (Type)type);
            if (type.getName() != null) {
                parser.getHelper().getSymbolTable().getGlobalScope().define((Symbol)new BuiltInTypeSymbol(type.getName(), type));
            }
        });
        inputVariables.forEach((name, value) -> {
            parser.getHelper().defineVariable((String)name);
            if (value instanceof Map) {
                try {
                    parser.getHelper().pushName((String)name);
                    parser.getHelper().pushScope();
                    FEELParser.defineVariables(Collections.EMPTY_MAP, (Map)value, parser);
                }
                finally {
                    parser.getHelper().popScope();
                    parser.getHelper().popName();
                }
            }
        });
    }
}

