/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.parser.feel11;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Vocabulary;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.misc.IntervalSet;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.lang.impl.FEELEventListenersManager;
import org.kie.dmn.feel.parser.feel11.FEELParser;
import org.kie.dmn.feel.runtime.events.SyntaxErrorEvent;
import org.kie.dmn.feel.util.Msg;

public class FEELParserErrorListener
extends BaseErrorListener {
    private final FEELEventListenersManager eventsManager;
    private List<FEELEvent> errors = null;

    public FEELParserErrorListener(FEELEventListenersManager eventsManager) {
        this.eventsManager = eventsManager;
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        List<String> expected;
        CommonToken token = (CommonToken)offendingSymbol;
        int tokenIndex = token.getTokenIndex();
        Parser parser = (Parser)recognizer;
        SyntaxErrorEvent error = parser.getRuleInvocationStack().contains("nameDefinitionWithEOF") ? FEELParserErrorListener.generateInvalidVariableError(offendingSymbol, line, charPositionInLine, e, token) : ("}".equals(token.getText()) && tokenIndex > 1 && ":".equals(parser.getTokenStream().get(tokenIndex - 1).getText()) ? new SyntaxErrorEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.MISSING_EXPRESSION, parser.getTokenStream().get(tokenIndex - 2).getText()), e, line, charPositionInLine, offendingSymbol) : (e != null && ((String)parser.getRuleInvocationStack().get(0)).equals("ifExpression") ? ((expected = FEELParserErrorListener.toList(e.getExpectedTokens(), e.getRecognizer().getVocabulary())).contains("ELSE") ? new SyntaxErrorEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.IF_MISSING_ELSE, token.getText(), msg), e, line, charPositionInLine, offendingSymbol) : (expected.contains("THEN") ? new SyntaxErrorEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.IF_MISSING_THEN, token.getText(), msg), e, line, charPositionInLine, offendingSymbol) : new SyntaxErrorEvent(FEELEvent.Severity.ERROR, msg, e, line, charPositionInLine, offendingSymbol))) : new SyntaxErrorEvent(FEELEvent.Severity.ERROR, msg, e, line, charPositionInLine, offendingSymbol)));
        if (this.eventsManager != null) {
            FEELEventListenersManager.notifyListeners((FEELEventListenersManager)this.eventsManager, () -> error);
        } else {
            if (this.errors == null) {
                this.errors = new ArrayList<FEELEvent>();
            }
            this.errors.add((FEELEvent)error);
        }
    }

    public boolean hasErrors() {
        return this.errors != null && !this.errors.isEmpty();
    }

    public List<FEELEvent> getErrors() {
        return this.errors == null ? Collections.emptyList() : this.errors;
    }

    private static SyntaxErrorEvent generateInvalidVariableError(Object offendingSymbol, int line, int charPositionInLine, RecognitionException e, CommonToken token) {
        String chars;
        String string = chars = token.getText().length() == 1 ? "character" : "sequence of characters";
        if (charPositionInLine == 0) {
            if ("in".equals(token.getText()) || FEELParser.REUSABLE_KEYWORDS.contains(token.getText())) {
                return new SyntaxErrorEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.INVALID_VARIABLE_NAME_START, "keyword", token.getText()), e, line, charPositionInLine, offendingSymbol);
            }
            return new SyntaxErrorEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.INVALID_VARIABLE_NAME_START, chars, token.getText()), e, line, charPositionInLine, offendingSymbol);
        }
        if ("in".equals(token.getText())) {
            return new SyntaxErrorEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.INVALID_VARIABLE_NAME, "keyword", token.getText()), e, line, charPositionInLine, offendingSymbol);
        }
        if ("}".equals(token.getText()) && e != null && e.getRecognizer() instanceof Parser && ((Parser)e.getRecognizer()).getRuleInvocationStack().contains("key")) {
            return new SyntaxErrorEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.MISSING_EXPRESSION, e.getCtx().getText()), e, line, charPositionInLine, offendingSymbol);
        }
        return new SyntaxErrorEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.INVALID_VARIABLE_NAME, chars, token.getText()), e, line, charPositionInLine, offendingSymbol);
    }

    private static List<String> toList(IntervalSet intervals, Vocabulary vocabulary) {
        ArrayList<String> result = new ArrayList<String>();
        if (intervals == null || intervals.getIntervals() == null || intervals.getIntervals().isEmpty()) {
            return result;
        }
        for (Interval I : intervals.getIntervals()) {
            int a = I.a;
            int b = I.b;
            if (a == b) {
                result.add(FEELParserErrorListener.elementName(vocabulary, a));
                continue;
            }
            for (int i = a; i <= b; ++i) {
                result.add(FEELParserErrorListener.elementName(vocabulary, i));
            }
        }
        return result;
    }

    private static String elementName(Vocabulary vocabulary, int a) {
        if (a == -1) {
            return "<EOF>";
        }
        if (a == -2) {
            return "<EPSILON>";
        }
        return vocabulary.getSymbolicName(a);
    }
}

