/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.impl;

import java.util.function.BiPredicate;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.util.AssignableFromUtil;
import org.kie.dmn.feel.util.EvalHelper;

public class RangeImpl
implements Range {
    private Range.RangeBoundary lowBoundary;
    private Range.RangeBoundary highBoundary;
    private Comparable lowEndPoint;
    private Comparable highEndPoint;

    public RangeImpl() {
    }

    public RangeImpl(Range.RangeBoundary lowBoundary, Comparable lowEndPoint, Comparable highEndPoint, Range.RangeBoundary highBoundary) {
        this.lowBoundary = lowBoundary;
        this.highBoundary = highBoundary;
        this.lowEndPoint = lowEndPoint;
        this.highEndPoint = highEndPoint;
    }

    public Range.RangeBoundary getLowBoundary() {
        return this.lowBoundary;
    }

    public Comparable getLowEndPoint() {
        return this.lowEndPoint;
    }

    public Comparable getHighEndPoint() {
        return this.highEndPoint;
    }

    public Range.RangeBoundary getHighBoundary() {
        return this.highBoundary;
    }

    public Boolean includes(Object param) {
        if (param == null) {
            return null;
        }
        if (this.lowEndPoint == null) {
            if (this.highEndPoint == null) {
                return null;
            }
            return this.negInfRangeIncludes(param);
        }
        if (this.highEndPoint == null) {
            return this.posInfRangeIncludes(param);
        }
        return this.finiteRangeIncludes(param);
    }

    private Boolean finiteRangeIncludes(Object param) {
        if (this.lowBoundary == Range.RangeBoundary.OPEN && this.highBoundary == Range.RangeBoundary.OPEN) {
            return this.bothOrThrow(RangeImpl.compare(this.lowEndPoint, param, (l, r) -> l.compareTo(r) < 0), RangeImpl.compare(this.highEndPoint, param, (l, r) -> l.compareTo(r) > 0), param);
        }
        if (this.lowBoundary == Range.RangeBoundary.OPEN && this.highBoundary == Range.RangeBoundary.CLOSED) {
            return this.bothOrThrow(RangeImpl.compare(this.lowEndPoint, param, (l, r) -> l.compareTo(r) < 0), RangeImpl.compare(this.highEndPoint, param, (l, r) -> l.compareTo(r) >= 0), param);
        }
        if (this.lowBoundary == Range.RangeBoundary.CLOSED && this.highBoundary == Range.RangeBoundary.OPEN) {
            return this.bothOrThrow(RangeImpl.compare(this.lowEndPoint, param, (l, r) -> l.compareTo(r) <= 0), RangeImpl.compare(this.highEndPoint, param, (l, r) -> l.compareTo(r) > 0), param);
        }
        if (this.lowBoundary == Range.RangeBoundary.CLOSED && this.highBoundary == Range.RangeBoundary.CLOSED) {
            return this.bothOrThrow(RangeImpl.compare(this.lowEndPoint, param, (l, r) -> l.compareTo(r) <= 0), RangeImpl.compare(this.highEndPoint, param, (l, r) -> l.compareTo(r) >= 0), param);
        }
        throw new RuntimeException("unknown boundary combination");
    }

    private Boolean posInfRangeIncludes(Object param) {
        if (this.lowBoundary == Range.RangeBoundary.OPEN) {
            return RangeImpl.compare(this.lowEndPoint, param, (l, r) -> l.compareTo(r) < 0);
        }
        return RangeImpl.compare(this.lowEndPoint, param, (l, r) -> l.compareTo(r) <= 0);
    }

    private Boolean negInfRangeIncludes(Object param) {
        if (this.highBoundary == Range.RangeBoundary.OPEN) {
            return RangeImpl.compare(this.highEndPoint, param, (l, r) -> l.compareTo(r) > 0);
        }
        return RangeImpl.compare(this.highEndPoint, param, (l, r) -> l.compareTo(r) >= 0);
    }

    private Boolean bothOrThrow(Boolean left, Boolean right, Object param) {
        if (left == null || right == null) {
            throw new IllegalArgumentException("Range.include(" + RangeImpl.classOf(param) + ") not comparable with " + RangeImpl.classOf(this.lowEndPoint) + ", " + RangeImpl.classOf(this.highEndPoint));
        }
        return left != false && right != false;
    }

    private static String classOf(Object p) {
        return p != null ? p.getClass().toString() : "null";
    }

    private static Boolean compare(Comparable left, Object right, BiPredicate<Comparable, Comparable> op) {
        if (AssignableFromUtil.isAssignableFrom(left.getClass(), right.getClass())) {
            return op.test(left, (Comparable)right);
        }
        return EvalHelper.compare(left, right, null, op);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RangeImpl)) {
            return false;
        }
        RangeImpl range = (RangeImpl)o;
        if (this.lowBoundary != range.lowBoundary) {
            return false;
        }
        if (this.highBoundary != range.highBoundary) {
            return false;
        }
        if (this.lowEndPoint != null ? !this.lowEndPoint.equals(range.lowEndPoint) : range.lowEndPoint != null) {
            return false;
        }
        return this.highEndPoint != null ? this.highEndPoint.equals(range.highEndPoint) : range.highEndPoint == null;
    }

    public int hashCode() {
        int result = this.lowBoundary != null ? this.lowBoundary.hashCode() : 0;
        result = 31 * result + (this.highBoundary != null ? this.highBoundary.hashCode() : 0);
        result = 31 * result + (this.lowEndPoint != null ? this.lowEndPoint.hashCode() : 0);
        result = 31 * result + (this.highEndPoint != null ? this.highEndPoint.hashCode() : 0);
        return result;
    }

    public String toString() {
        return (this.lowBoundary == Range.RangeBoundary.OPEN ? "(" : "[") + " " + this.lowEndPoint + " .. " + this.highEndPoint + " " + (this.highBoundary == Range.RangeBoundary.OPEN ? ")" : "]");
    }
}

