/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.legacy.tests.validation.v1_1;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.core.util.DynamicTypeUtils;
import org.kie.dmn.model.api.DMNElementReference;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.validation.AbstractValidatorTest;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.ValidatorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorImportTest
extends AbstractValidatorTest {
    public static final Logger LOG = LoggerFactory.getLogger(ValidatorImportTest.class);

    @Ignore
    @Test
    public void testBaseModelOK() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"import/Base-model.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"import/Import-base-model.dmn"});
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_b33fa7d9-f501-423b-afa8-15ded7e7f493", "Import base model");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("Customer", (Object)DynamicTypeUtils.mapOf((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"full name", (Object)"John Doe"), DynamicTypeUtils.entry((Object)"age", (Object)47)}));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)dmnResult);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
    }

    @Test
    public void testBaseModelOKFromReaderInput() throws IOException {
        try (Reader reader0 = this.getReader("import/Base-model.dmn");
             Reader reader1 = this.getReader("import/Import-base-model.dmn");){
            List messages = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION}).theseModels(new Reader[]{reader0, reader1});
            ((ListAssert)Assertions.assertThat((List)messages).as(ValidatorUtil.formatMessages((List)messages), new Object[0])).hasSize(0);
        }
    }

    @Test
    public void testBaseModelOKFromFileInput() throws IOException {
        List messages = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION}).theseModels(new File[]{this.getFile("import/Import-base-model.dmn"), this.getFile("import/Base-model.dmn")});
        ((ListAssert)Assertions.assertThat((List)messages).as(ValidatorUtil.formatMessages((List)messages), new Object[0])).hasSize(0);
    }

    @Test
    public void testBaseModelImportModelNameFromFileInput() throws IOException {
        List messages = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL}).theseModels(new File[]{this.getFile("import/Import-base-model-modelnameattribute.dmn"), this.getFile("import/Base-model.dmn")});
        ((ListAssert)Assertions.assertThat((List)messages).as(ValidatorUtil.formatMessages((List)messages), new Object[0])).hasSize(0);
    }

    @Test
    public void testBaseModelOKFromDefinitionsInput() throws IOException {
        List messages = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION}).theseModels(new Definitions[]{this.getDefinitions(Arrays.asList("import/Base-model.dmn", "import/Import-base-model.dmn"), "http://www.trisotech.com/definitions/_70df1ad5-2a33-4ede-b8b2-869988ac1d30", "Base model"), this.getDefinitions(Arrays.asList("import/Base-model.dmn", "import/Import-base-model.dmn"), "http://www.trisotech.com/dmn/definitions/_b33fa7d9-f501-423b-afa8-15ded7e7f493", "Import base model")});
        ((ListAssert)Assertions.assertThat((List)messages).as(ValidatorUtil.formatMessages((List)messages), new Object[0])).hasSize(0);
    }

    @Test
    public void testWrongImportBaseModelFromReaderInput() throws IOException {
        try (Reader reader0 = this.getReader("import/Base-model.dmn");
             Reader reader1 = this.getReader("import/Wrong-Import-base-model.dmn");){
            List messages = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL}).theseModels(new Reader[]{reader0, reader1});
            ((ListAssert)Assertions.assertThat((List)messages).as(ValidatorUtil.formatMessages((List)messages), new Object[0])).hasSize(1);
            Assertions.assertThat((boolean)messages.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND) && p.getSourceReference() instanceof DMNElementReference && ((DMNElementReference)p.getSourceReference()).getHref().equals("http://www.trisotech.com/definitions/_70df1ad5-2a33-4ede-b8b2-869988ac1d30#_1d52934e-aa4e-47c9-a011-fc989d795664"))).isTrue();
        }
    }

    @Test
    public void testWrongImportBaseModelFromFileInput() throws IOException {
        List messages = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL}).theseModels(new File[]{this.getFile("import/Base-model.dmn"), this.getFile("import/Wrong-Import-base-model.dmn")});
        ((ListAssert)Assertions.assertThat((List)messages).as(ValidatorUtil.formatMessages((List)messages), new Object[0])).hasSize(1);
        Assertions.assertThat((boolean)messages.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND) && p.getSourceReference() instanceof DMNElementReference && ((DMNElementReference)p.getSourceReference()).getHref().equals("http://www.trisotech.com/definitions/_70df1ad5-2a33-4ede-b8b2-869988ac1d30#_1d52934e-aa4e-47c9-a011-fc989d795664"))).isTrue();
    }

    @Test
    public void testWrongImportBaseModelFromDefinitionsInput() throws IOException {
        List messages = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL}).theseModels(new Definitions[]{this.getDefinitions(Arrays.asList("import/Base-model.dmn", "import/Wrong-Import-base-model.dmn"), "http://www.trisotech.com/definitions/_70df1ad5-2a33-4ede-b8b2-869988ac1d30", "Base model"), this.getDefinitions(Arrays.asList("import/Base-model.dmn", "import/Wrong-Import-base-model.dmn"), "http://www.trisotech.com/dmn/definitions/_719a2325-5cac-47ea-8a99-665c01d570a5", "Wrong Import base model")});
        Assertions.assertThat((boolean)messages.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND) && p.getSourceReference() instanceof DMNElementReference && ((DMNElementReference)p.getSourceReference()).getHref().equals("http://www.trisotech.com/definitions/_70df1ad5-2a33-4ede-b8b2-869988ac1d30#_1d52934e-aa4e-47c9-a011-fc989d795664"))).isTrue();
    }

    @Test
    public void testOnlyImportBaseModelFromReaderInput() throws IOException {
        try (Reader reader1 = this.getReader("import/Only-Import-base-model.dmn");){
            List messages = validator.validate(reader1, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL});
            Assertions.assertThat((boolean)messages.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.IMPORT_NOT_FOUND))).isTrue();
        }
    }

    @Test
    public void testOnlyImportBaseModelFromFileInput() throws IOException {
        List messages = validator.validate(this.getFile("import/Only-Import-base-model.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL});
        Assertions.assertThat((boolean)messages.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.IMPORT_NOT_FOUND))).isTrue();
    }

    @Test
    public void testOnlyImportBaseModelFromDefinitionsInput() throws IOException {
        List messages = validator.validate(this.getDefinitions("import/Only-Import-base-model.dmn", "http://www.trisotech.com/dmn/definitions/_a9bfa4de-cf5c-4b2f-9011-ab576e00b162", "Only Import base model"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL});
        Assertions.assertThat((boolean)messages.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.IMPORT_NOT_FOUND))).isTrue();
    }
}

