/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.legacy.tests.core.v1_1;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.event.AfterEvaluateDecisionTableEvent;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.kie.dmn.core.BaseVariantTest;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.core.util.KieHelper;
import org.kie.dmn.legacy.tests.core.v1_1.BaseDMN1_1VariantTest;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNDecisionTableRuntimeTest
extends BaseDMN1_1VariantTest {
    public static final Logger LOG = LoggerFactory.getLogger(DMNDecisionTableRuntimeTest.class);

    public DMNDecisionTableRuntimeTest(BaseVariantTest.VariantTestConf testConfig) {
        super(testConfig);
    }

    @Test
    public void testDecisionTableWithCalculatedResult() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"calculation1.dmn", ((Object)((Object)this)).getClass());
        this.checkDecisionTableWithCalculatedResult(runtime);
    }

    private void checkDecisionTableWithCalculatedResult(DMNRuntime runtime) {
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_77ae284e-ce52-4579-a50f-f3cc584d7f4b", "Calculation1");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = DMNFactory.newContext();
        context.set("MonthlyDeptPmt", (Object)BigDecimal.valueOf(200L));
        context.set("MonthlyPmt", (Object)BigDecimal.valueOf(100L));
        context.set("MonthlyIncome", (Object)BigDecimal.valueOf(600L));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assertions.assertThat((boolean)dmnResult.hasErrors()).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((BigDecimal)((BigDecimal)result.get("Logique de d\u00e9cision 1")).setScale(1, RoundingMode.CEILING)).isEqualTo((Object)BigDecimal.valueOf(0.5));
    }

    @Test(timeout=30000L)
    public void testDecisionTableWithCalculatedResult_parallel() throws Throwable {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"calculation1.dmn", ((Object)((Object)this)).getClass());
        Runnable task = () -> this.checkDecisionTableWithCalculatedResult(runtime);
        List problems = Collections.synchronizedList(new ArrayList());
        ArrayList<CompletionStage> tasks = new ArrayList<CompletionStage>();
        for (int i = 0; i < 10000; ++i) {
            CompletionStage newtask = CompletableFuture.runAsync(task).exceptionally(t -> {
                problems.add(t);
                return null;
            });
            tasks.add(newtask);
        }
        CompletableFuture.allOf(tasks.toArray(new CompletableFuture[0])).get();
        if (problems.size() > 0) {
            throw (Throwable)problems.get(0);
        }
    }

    @Test
    public void testDecisionTableMultipleResults() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"car_damage_responsibility.dmn", ((Object)((Object)this)).getClass());
        DMNRuntimeEventListener listener = (DMNRuntimeEventListener)Mockito.mock(DMNRuntimeEventListener.class);
        runtime.addListener(listener);
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_820611e9-c21c-47cd-8e52-5cba2be9f9cc", "Car Damage Responsibility");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = DMNFactory.newContext();
        context.set("Membership Level", (Object)"Silver");
        context.set("Damage Types", (Object)"Body");
        context.set("Responsible", (Object)"Driver");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assertions.assertThat((boolean)dmnResult.hasErrors()).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Map)((Map)result.get("Car Damage Responsibility"))).containsEntry((Object)"EU Rent", (Object)BigDecimal.valueOf(40L));
        Assertions.assertThat((Map)((Map)result.get("Car Damage Responsibility"))).containsEntry((Object)"Renter", (Object)BigDecimal.valueOf(60L));
        Assertions.assertThat((Object)result.get("Payment method")).isEqualTo((Object)"Check");
        ArgumentCaptor captor = ArgumentCaptor.forClass(AfterEvaluateDecisionTableEvent.class);
        ((DMNRuntimeEventListener)Mockito.verify((Object)listener, (VerificationMode)VerificationModeFactory.times((int)2))).afterEvaluateDecisionTable((AfterEvaluateDecisionTableEvent)captor.capture());
        AfterEvaluateDecisionTableEvent first = (AfterEvaluateDecisionTableEvent)captor.getAllValues().get(0);
        Assertions.assertThat((List)first.getMatches()).containsExactly((Object[])new Integer[]{5});
        Assertions.assertThat((List)first.getSelected()).containsExactly((Object[])new Integer[]{5});
        AfterEvaluateDecisionTableEvent second = (AfterEvaluateDecisionTableEvent)captor.getAllValues().get(1);
        Assertions.assertThat((List)second.getMatches()).containsExactly((Object[])new Integer[]{3});
        Assertions.assertThat((List)second.getSelected()).containsExactly((Object[])new Integer[]{3});
    }

    @Test
    public void testSimpleDecisionTableMultipleOutputWrongOutputType() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0004-simpletable-P-multiple-outputs-wrong-output.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0004-simpletable-P-multiple-outputs-wrong-output");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = DMNFactory.newContext();
        context.set("Age", (Object)BigDecimal.valueOf(18L));
        context.set("RiskCategory", (Object)"Medium");
        context.set("isAffordable", (Object)true);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assertions.assertThat((boolean)dmnResult.hasErrors()).isTrue();
        Assertions.assertThat((long)dmnResult.getMessages().stream().filter(message -> message.getFeelEvent().getSourceException() instanceof NullPointerException).count()).isEqualTo(0L);
    }

    @Test
    public void testDecisionTableInvalidInputErrorMessage() {
        DMNContext context = DMNFactory.newContext();
        context.set("Branches dispersion", (Object)"Province");
        context.set("Number of Branches", (Object)BigDecimal.valueOf(10L));
        this.testDecisionTableInvalidInput(context);
    }

    @Test
    public void testDecisionTableInvalidInputTypeErrorMessage() {
        DMNContext context = DMNFactory.newContext();
        context.set("Branches dispersion", (Object)1);
        context.set("Number of Branches", (Object)BigDecimal.valueOf(10L));
        this.testDecisionTableInvalidInput(context);
    }

    @Test
    public void testDecisionTableNonexistingInputErrorMessage() {
        DMNContext context = DMNFactory.newContext();
        context.set("Not exists", (Object)"Province");
        context.set("Number of Branches", (Object)BigDecimal.valueOf(10L));
        this.testDecisionTableInvalidInput(context);
    }

    private void testDecisionTableInvalidInput(DMNContext inputContext) {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"InvalidInput.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_cdf29af2-959b-4004-8271-82a9f5a62147", "Dessin 1");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, inputContext);
        Assertions.assertThat((boolean)dmnResult.hasErrors()).isTrue();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((boolean)result.isDefined("Branches distribution")).isEqualTo((Object)Boolean.FALSE);
    }

    @Test
    public void testDecisionTableDefaultValue() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"decisiontable-default-value.dmn", ((Object)((Object)this)).getClass());
        DMNRuntimeEventListener listener = (DMNRuntimeEventListener)Mockito.mock(DMNRuntimeEventListener.class);
        runtime.addListener(listener);
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "decisiontable-default-value");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("Age", (Object)new BigDecimal(16));
        context.set("RiskCategory", (Object)"Medium");
        context.set("isAffordable", (Object)true);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Approval Status")).isEqualTo((Object)"Declined");
        ArgumentCaptor captor = ArgumentCaptor.forClass(AfterEvaluateDecisionTableEvent.class);
        ((DMNRuntimeEventListener)Mockito.verify((Object)listener)).afterEvaluateDecisionTable((AfterEvaluateDecisionTableEvent)captor.capture());
        Assertions.assertThat((List)((AfterEvaluateDecisionTableEvent)captor.getValue()).getMatches()).isEmpty();
        Assertions.assertThat((List)((AfterEvaluateDecisionTableEvent)captor.getValue()).getSelected()).isEmpty();
    }

    @Test
    public void testTwoDecisionTables() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"two_decision_tables.dmn", ((Object)((Object)this)).getClass());
        DMNRuntimeEventListener listener = (DMNRuntimeEventListener)Mockito.mock(DMNRuntimeEventListener.class);
        runtime.addListener(listener);
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_bbb692e7-3d95-407a-bf39-353085bf57f0", "Invocation with two decision table as parameters");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("Number", (Object)50);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Map)((Map)result.get("Decision Logic 2"))).containsEntry((Object)"the 5 analysis", (Object)"A number greater than 5");
        Assertions.assertThat((Map)((Map)result.get("Decision Logic 2"))).containsEntry((Object)"the 100 analysis", (Object)"A number smaller than 100");
        ArgumentCaptor captor = ArgumentCaptor.forClass(AfterEvaluateDecisionTableEvent.class);
        ((DMNRuntimeEventListener)Mockito.verify((Object)listener, (VerificationMode)VerificationModeFactory.times((int)2))).afterEvaluateDecisionTable((AfterEvaluateDecisionTableEvent)captor.capture());
        Assertions.assertThat((String)((AfterEvaluateDecisionTableEvent)captor.getAllValues().get(0)).getDecisionTableName()).isEqualTo("a");
        Assertions.assertThat((String)((AfterEvaluateDecisionTableEvent)captor.getAllValues().get(1)).getDecisionTableName()).isEqualTo("b");
    }

    @Test
    public void testDTInputExpressionLocalXmlnsInference() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"drools1502-InputExpression.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://www.drools.org/kie-dmn/definitions", "definitions");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = runtime.newContext();
        context.set("MyInput", (Object)"a");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("MyDecision")).isEqualTo((Object)"Decision taken");
    }

    @Test
    public void testDTInContext() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"DT_in_context.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_4acdcb25-b298-435e-abd5-efd00ed686a5", "Drawing 1");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assertions.assertThat((List)dmnResult.getDecisionResults()).hasSize(1);
        Assertions.assertThat((Object)dmnResult.getDecisionResultByName("D1").getResult()).isInstanceOf(Map.class);
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat(((Map)result.get("D1")).get("Text color")).isEqualTo((Object)"red");
    }

    @Test
    public void testDTUsingEqualsUnaryTestWithVariable1() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"DT_using_variables.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_ed1ec15b-40aa-424d-b1d0-4936df80b135", "DT Using variables");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        HashMap<String, Object> complex = new HashMap<String, Object>();
        complex.put("aBoolean", true);
        complex.put("aNumber", 10);
        complex.put("aString", "bar");
        DMNContext context = DMNFactory.newContext();
        context.set("Complex", complex);
        context.set("Another boolean", (Object)true);
        context.set("Another String", (Object)"bar");
        context.set("Another number", (Object)10);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Compare Boolean")).isEqualTo((Object)"Same boolean");
        Assertions.assertThat((Object)result.get("Compare Number")).isEqualTo((Object)"Equals");
        Assertions.assertThat((Object)result.get("Compare String")).isEqualTo((Object)"Same String");
    }

    @Test
    public void testDTUsingEqualsUnaryTestWithVariable2() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"DT_using_variables.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_ed1ec15b-40aa-424d-b1d0-4936df80b135", "DT Using variables");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        Assertions.assertThat((boolean)dmnModel.hasErrors()).isFalse();
        HashMap<String, Object> complex = new HashMap<String, Object>();
        complex.put("aBoolean", true);
        complex.put("aNumber", 10);
        complex.put("aString", "bar");
        DMNContext context = DMNFactory.newContext();
        context.set("Complex", complex);
        context.set("Another boolean", (Object)false);
        context.set("Another String", (Object)"foo");
        context.set("Another number", (Object)20);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Compare Boolean")).isEqualTo((Object)"Not same boolean");
        Assertions.assertThat((Object)result.get("Compare Number")).isEqualTo((Object)"Bigger");
        Assertions.assertThat((Object)result.get("Compare String")).isEqualTo((Object)"Different String");
    }

    @Test
    public void testEmptyOutputCell() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"DT_empty_output_cell.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_77ae284e-ce52-4579-a50f-f3cc584d7f4b", "Calculation1");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = DMNFactory.newContext();
        context.set("MonthlyDeptPmt", (Object)BigDecimal.valueOf(1L));
        context.set("MonthlyPmt", (Object)BigDecimal.valueOf(1L));
        context.set("MonthlyIncome", (Object)BigDecimal.valueOf(1L));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)dmnResult);
        Assertions.assertThat((boolean)dmnResult.hasErrors()).isFalse();
        Assert.assertNull((Object)dmnResult.getContext().get("Logique de d\u00e9cision 1"));
    }

    @Test
    public void testNullRelation() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"nullrelation.dmn", ((Object)((Object)this)).getClass());
        DMNModel model = runtime.getModel("http://www.trisotech.com/definitions/_946a2145-89ae-4197-88b4-40e6f88c8101", "Null in relations");
        Assertions.assertThat((Object)model).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)model.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)model.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("Value", (Object)"a3");
        DMNResult result = runtime.evaluateByName(model, context, new String[]{"Mapping"});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)result.getMessages()), new Object[0])).isFalse();
    }

    @Test
    public void testDecisionTableOutputDMNTypeCollection() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"DecisionTableOutputDMNTypeCollection.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_ae5d2033-c6d0-411f-a394-da33a70e5638", "Drawing 1");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("selector", (Object)"asd");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("a decision")).asList().containsExactly(new Object[]{"abc", "xyz"});
    }

    @Test
    public void testDecisionTableOutputDMNTypeCollection_NOtypecheck() {
        KieServices ks = KieServices.Factory.get();
        KieContainer kieContainer = KieHelper.getKieContainer((ReleaseId)ks.newReleaseId("org.kie", "dmn-test-" + UUID.randomUUID(), "1.0"), (Resource[])new Resource[]{ks.getResources().newClassPathResource("DecisionTableOutputDMNTypeCollection.dmn", ((Object)((Object)this)).getClass())});
        DMNRuntime runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_ae5d2033-c6d0-411f-a394-da33a70e5638", "Drawing 1");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("selector", (Object)"asd");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("a decision")).asList().containsExactly(new Object[]{"abc", "xyz"});
    }

    @Test
    public void testDecisionTableOutputDMNTypeCollectionWithLOV() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"DecisionTableOutputDMNTypeCollectionWithLOV.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_ae5d2033-c6d0-411f-a394-da33a70e5638", "List of Words in DT");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("selector", (Object)"asd");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("a decision")).asList().containsExactly(new Object[]{"abc", "a"});
    }

    @Test
    public void testDecisionTableOutputDMNTypeCollectionWithLOV_NOtypecheck() {
        KieServices ks = KieServices.Factory.get();
        KieContainer kieContainer = KieHelper.getKieContainer((ReleaseId)ks.newReleaseId("org.kie", "dmn-test-" + UUID.randomUUID(), "1.0"), (Resource[])new Resource[]{ks.getResources().newClassPathResource("DecisionTableOutputDMNTypeCollectionWithLOV.dmn", ((Object)((Object)this)).getClass())});
        DMNRuntime runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_ae5d2033-c6d0-411f-a394-da33a70e5638", "List of Words in DT");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("selector", (Object)"asd");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("a decision")).asList().containsExactly(new Object[]{"abc", "a"});
    }
}

