/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.pmml;

import java.io.InputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.core.pmml.PMMLInfo;
import org.kie.dmn.core.pmml.PMMLModelInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PMMLInfoTest {
    public static final Logger LOG = LoggerFactory.getLogger(PMMLInfoTest.class);

    @Test
    public void testPMMLInfo() throws Exception {
        InputStream inputStream = PMMLInfoTest.class.getResourceAsStream("test_scorecard.pmml");
        PMMLInfo p0 = PMMLInfo.from((InputStream)inputStream);
        Assert.assertThat((Object)p0.getModels(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)p0.getHeader().getPmmlNSURI(), (Matcher)CoreMatchers.is((Object)"http://www.dmg.org/PMML-4_2"));
        PMMLModelInfo m0 = (PMMLModelInfo)p0.getModels().iterator().next();
        Assert.assertThat((Object)m0.getName(), (Matcher)CoreMatchers.is((Object)"Sample Score"));
        Assert.assertThat((Object)m0.getInputFieldNames(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CoreMatchers.is((Object)"age"), CoreMatchers.is((Object)"occupation"), CoreMatchers.is((Object)"residenceState"), CoreMatchers.is((Object)"validLicense")}));
        Assert.assertThat((Object)m0.getTargetFieldNames(), (Matcher)Matchers.containsInAnyOrder((Matcher)CoreMatchers.is((Object)"overallScore")));
        Assert.assertThat((Object)m0.getOutputFieldNames(), (Matcher)Matchers.containsInAnyOrder((Matcher)CoreMatchers.is((Object)"calculatedScore")));
    }
}

