/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.pmml;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DMNNaiveBayesPMMLTest {
    private static final Logger LOG = LoggerFactory.getLogger(DMNNaiveBayesPMMLTest.class);
    private DMNRuntime runtime;
    private DMNModel dmnModel;

    @Test
    public void testKMeans() {
        this.runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"NaiveBayes.dmn", DMNNaiveBayesPMMLTest.class, (String[])new String[]{"test_naive_bayes.pmml"});
        this.dmnModel = this.runtime.getModel("https://kiegroup.org/dmn/_51A1FD67-8A67-4332-9889-B718BE8B7456", "NaiveBayesDMN");
        Assertions.assertThat((Object)this.dmnModel).isNotNull();
        Assertions.assertThat((boolean)this.dmnModel.hasErrors()).isFalse();
        Assertions.assertThat((String)this.evaluateNaiveBayes(5.7, 3.8, 1.7, 0.3)).isEqualTo("setosa");
        Assertions.assertThat((String)this.evaluateNaiveBayes(6.4, 2.8, 5.6, 2.1)).isEqualTo("virginica");
        Assertions.assertThat((String)this.evaluateNaiveBayes(5.7, 2.9, 4.2, 1.3)).isEqualTo("versicolor");
    }

    private String evaluateNaiveBayes(double sepalLength, double sepalWidth, double petalLength, double petalWidth) {
        DMNContext dmnContext = DMNFactory.newContext();
        dmnContext.set("Sepal.Length", (Object)sepalLength);
        dmnContext.set("Sepal.Width", (Object)sepalWidth);
        dmnContext.set("Petal.Length", (Object)petalLength);
        dmnContext.set("Petal.Width", (Object)petalWidth);
        DMNResult dmnResult = this.runtime.evaluateAll(this.dmnModel, dmnContext);
        LOG.debug("{}", (Object)dmnResult);
        Assertions.assertThat((boolean)dmnResult.hasErrors()).isFalse();
        Assertions.assertThat((Object)dmnResult.getDecisionResultByName("Decision1").getResult()).isNotNull();
        Map decisionResult = (Map)dmnResult.getDecisionResultByName("Decision1").getResult();
        String predictedClassName = (String)decisionResult.get("Predicted_Species");
        return predictedClassName;
    }
}

